/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.channel;

import enea.ose.system.InSignal;
import java.util.ArrayList;
import se.ericsson.cello.faultmanagement.Event;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrNotReadableException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.ResourceLockedException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.AvailabilityStatusIntToEnum;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcPccpchProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsGetPccpchParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsPccpchCreatedIndS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsPccpchEventIndS;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.event.MoEvents;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.AlreadyActiveException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.InternalErrorException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.MoDisabledException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.NotActiveException;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.BchMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DbchDeviceSetMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PccpchMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsLocalCellMo;
import se.ericsson.wcdma.rbs.boam.mao.rmo.channel.BchMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.rmo.channel.ChannelHelper;

public class PccpchMoImpl
extends BoamManagedObject
implements PccpchMo {
    public static final String IDENTITY = "1";
    private static final String PCCPCH_FRO_ID = "pccpchFroId";
    private static final String TAG_LRS_PCCPCH_DL_CH_RESOURCE_REDUNDANCY_SWITCH_OVER = "_DownLinkChannelResourceRedundancySwitchOver";
    private MoData myData;
    private ChcPccpchProxy chcPccpchProxy = ChcPccpchProxy.instance();
    private MoEvents myMoEvents;
    private DbchDeviceSetMo deviceSetRef;

    private PccpchMoImpl(ManagedObject parent, int pccpchfroid, int dbchdevsetfroid, String thisMoName, String identity) throws MoAccessException {
        super(parent, thisMoName, identity, null);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        this.initMoData(identity, pccpchfroid, dbchdevsetfroid, null);
        this.addObservers(72, null);
        this.deviceSetRef = (DbchDeviceSetMo)ChannelHelper.resolveDeviceSetRefAndReserve(dbchdevsetfroid, "DbchDeviceSet", this);
        MessageLog.trace(1, this.getClass(), "MO Created");
    }

    public static synchronized ManagedObject create(LrsPccpchCreatedIndS indicationSig) throws MoAccessException {
        MessageLog.traceEnter(PccpchMoImpl.class, " create() ");
        PccpchMoImpl pccpchMo = null;
        ManagedObject cellMo = BoamHelper.getMoForFroId("RbsLocalCell", indicationSig.cellFroId);
        if (cellMo == null) {
            throw new MoNotFoundException("RbsLocalCell Mo has not been created");
        }
        if (((RbsLocalCellMo)cellMo).isCombinedCell(null)) {
            pccpchMo = new PccpchMoImpl(cellMo, indicationSig.pccpchFroId, indicationSig.dbchDevSetFroId, "Pccpch", IDENTITY);
        } else {
            ManagedObject carrierMo = ((RbsLocalCellMo)cellMo).getCarrierRef(null);
            if (carrierMo == null) {
                throw new MoNotFoundException("Carrier Mo has not been created");
            }
            pccpchMo = new PccpchMoImpl(carrierMo, indicationSig.pccpchFroId, indicationSig.dbchDevSetFroId, "Pccpch", IDENTITY);
        }
        pccpchMo.createMyOwnCommonChannel(indicationSig);
        return pccpchMo;
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete()");
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void deletePccpch(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deletePccpch()");
        this.deleteMyOwnCommonChannels(context);
        if (super.isReserved(context)) {
            throw new UndeletableMoException((ManagedObject)this);
        }
        ManagedObject dbchDevSetRef = this.getDbchDeviceSetRef(context);
        if (dbchDevSetRef != null) {
            ((Reservable)dbchDevSetRef).release((ManagedObject)this, context);
        }
        this.removeObservers(context);
        super.delete(context);
    }

    public String getType() {
        return "Pccpch";
    }

    public int getOperationalState(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException {
        MessageLog.traceEnter(this.getClass(), "getOperationalState()");
        LrsGetPccpchParamRspS rspSig = this.chcPccpchProxy.getPccpchParam(0, this.getFroId(context));
        return rspSig.pccpchOpState;
    }

    public int getAvailabilityStatus(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException {
        MessageLog.traceEnter(this.getClass(), "getAvailabilityStatus()");
        LrsGetPccpchParamRspS rspSig = this.chcPccpchProxy.getPccpchParam(0, this.getFroId(context));
        return AvailabilityStatusIntToEnum.convGetAvailStatIntToEnum(rspSig.pccpchAvailStatus);
    }

    public int getPnIsActive(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException {
        MessageLog.traceEnter(this.getClass(), "getPnIsActive()");
        LrsGetPccpchParamRspS rspSig = this.chcPccpchProxy.getPccpchParam(0, this.getFroId(context));
        return rspSig.pnIsActive;
    }

    public ManagedObject getDbchDeviceSetRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getDbchDeviceSetRef()");
        return this.deviceSetRef;
    }

    public Struct actionReadNbapData(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionReadNbapData()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        LrsGetPccpchParamRspS rspSig = this.chcPccpchProxy.getPccpchParam(0, this.getFroId(context));
        return this.convertSigToStruct(context, rspSig);
    }

    public void actionStartPn(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionStartPn()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        try {
            this.chcPccpchProxy.startPnGenPccpch(0, this.getFroId(context));
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 1) {
                throw new InternalErrorException();
            }
            if (e.getOrgErrorCode() == 2) {
                throw new MoDisabledException();
            }
            if (e.getOrgErrorCode() == 3) {
                throw new AlreadyActiveException();
            }
            throw e;
        }
    }

    public void actionStopPn(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionStopPn()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        try {
            this.chcPccpchProxy.stopPnGenPccpch(0, this.getFroId(context));
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 1) {
                throw new InternalErrorException();
            }
            if (e.getOrgErrorCode() == 4) {
                throw new NotActiveException();
            }
            throw e;
        }
    }

    private Struct convertSigToStruct(Coordinator context, LrsGetPccpchParamRspS rspSig) throws MoAccessException {
        String[] names = new String[1];
        Object[] values = new Object[1];
        names[0] = "phChId";
        Integer pccpchPhysChId = new Integer(rspSig.pccpchPhysChId);
        values[0] = pccpchPhysChId;
        if (rspSig.nbapIsValid == 1) {
            StructImpl status = new StructImpl(names, values);
            return status;
        }
        String msg = " Nbap data is not valid ";
        throw new AttrNotReadableException((ManagedObject)this, msg);
    }

    private void initMoData(String identity, int pccpchfroid, int dbchdevsetfroid, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initMoData()");
        this.myData = new MoData(super.getLocalDistinguishedName(), this.getType(), false, context);
        IntegerAttribute tmpIntAttribute1 = new IntegerAttribute(PCCPCH_FRO_ID, false);
        this.myData.registerTransientAttr((Attribute)tmpIntAttribute1);
        tmpIntAttribute1.setValue(pccpchfroid);
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return false;
    }

    public void releaseOldAndAllocatedNewDbchDevice(int newDbchDevSetFroId, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "releaseOldAndAllocatedNewDbchDevice()");
        MessageLog.trace(2, this.getClass(), "old " + this.getDbchDeviceSetRef(context));
        ((BoamManagedObject)this.getDbchDeviceSetRef(context)).release(this, context);
        this.deviceSetRef = (DbchDeviceSetMo)ChannelHelper.resolveDeviceSetRefAndReserve(newDbchDevSetFroId, "DbchDeviceSet", this);
        MessageLog.trace(2, this.getClass(), "new " + this.getDbchDeviceSetRef(context));
    }

    public void eventRaised(InSignal receiveSig) {
        MessageLog.traceEnter(this.getClass(), "eventRaised()");
        if (receiveSig instanceof LrsPccpchEventIndS) {
            MessageLog.trace(6, this.getClass(), " LrsPccpchEventIndS received ");
            String objectClass = this.getType();
            String managedObjectInstance = this.getFullDistinguishedName();
            String eventType = "0";
            String eventTime = "";
            String additionalText = this.bcmGetMEUserLabel();
            LrsPccpchEventIndS recSig = (LrsPccpchEventIndS)receiveSig;
            String specificEvent = "";
            if (recSig.pccpchEventType != 24976) {
                MessageLog.traceError(this.getClass(), "Unknown event received");
                return;
            }
            specificEvent = this.getType() + TAG_LRS_PCCPCH_DL_CH_RESOURCE_REDUNDANCY_SWITCH_OVER;
            MessageLog.trace(6, this.getClass(), "MO = " + objectClass + " specificEvent = _DownLinkChannelResourceRedundancySwitchOver");
            new Event(objectClass, managedObjectInstance, eventType, eventTime, specificEvent, additionalText, null);
        }
    }

    public int getFroId(Coordinator c) {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        int froId = 0;
        try {
            froId = this.bcmGetIntAttribute(PCCPCH_FRO_ID, c);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "MoAccessException caught in getFroId(Corrdinator c) ", e);
        }
        return froId;
    }

    private void createMyOwnCommonChannel(LrsPccpchCreatedIndS indicationSig) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createMyOwnCommonChannel()");
        new BchMoImpl((ManagedObject)this, indicationSig.pccpchFroId, indicationSig.bchFroId, "Bch", IDENTITY);
    }

    private void deleteMyOwnCommonChannels(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deleteMyOwnCommonChannels()");
        MoIterator mos = this.getChildren();
        ArrayList<ManagedObject> moList = new ArrayList<ManagedObject>();
        while (mos != null && mos.hasMoreElements()) {
            moList.add(mos.nextMo());
        }
        for (int i = 0; i < moList.size(); ++i) {
            ((BchMo)moList.get(i)).deleteBch(context);
        }
    }

    protected void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.myMoEvents = new MoEvents(this, this.chcPccpchProxy, this.getFroId(context), context);
    }

    protected void removeObservers(Coordinator context) throws MoAccessException {
        this.myMoEvents.delete(context);
    }
}

