/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.channel;

import enea.ose.system.InSignal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.FroStateObserver;
import se.ericsson.wcdma.rbs.boam.common.PlugAndPlayObserver;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcSccpchProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsSccpchCreatedIndS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsSccpchDeletedIndS;
import se.ericsson.wcdma.rbs.boam.mao.common.ErrorMgr;
import se.ericsson.wcdma.rbs.boam.mao.rmo.channel.SccpchMoImpl;
import se.ericsson.wcdma.rbs.boam.pms.iface.PmCapableMoFactory;
import se.ericsson.wcdma.rbs.boam.pms.impl.Counter;
import se.ericsson.wcdma.rbs.boam.pms.impl.CounterGroup;
import se.ericsson.wcdma.rbs.boam.pms.impl.MoScannerAgent;

public class SccpchMoFactory
implements PmCapableMoFactory,
PlugAndPlayObserver,
FroStateObserver {
    public static final int CLIENT_ID = 0;
    public static final int CM_OPERATION_OK = 0;
    private static SccpchMoFactory instance = null;
    private ChcSccpchProxy myProxy = ChcSccpchProxy.instance();
    private List counterList = new ArrayList();
    private HashMap sccpchList = new HashMap(5);

    private SccpchMoFactory() {
        MessageLog.traceEnter(this.getClass(), "constructor");
        MoFactoryMgr.instance().register((MoFactory)this, this.getMoTypeName());
        this.myProxy.registerForPlugAndPLayInd(null, this, -15L);
        this.myProxy.registerForStatePropagation(null, this);
        this.setupPmsCounters();
    }

    public static synchronized SccpchMoFactory instance() {
        if (instance == null) {
            instance = new SccpchMoFactory();
        }
        return instance;
    }

    public ManagedObject createMo(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createMo()");
        throw new MoCanNotBeCreatedException(this.getMoTypeName());
    }

    public ManagedObject recoverMo(MoData recoveredData) throws MoNameAlreadyTakenException {
        MessageLog.traceEnter(this.getClass(), "recoverMo()");
        ErrorMgr.shotDownIfNull(null, "SW error!!, this shouldn't be happened. No recovery for " + this.getMoTypeName());
        return null;
    }

    public synchronized void createInd(InSignal createInd) {
        MessageLog.traceEnter(this.getClass(), "createInd()");
        SccpchMoImpl sccpchMo = null;
        LrsSccpchCreatedIndS indicationSig = (LrsSccpchCreatedIndS)createInd;
        try {
            sccpchMo = (SccpchMoImpl)this.createPhysicalCommonChannel(indicationSig);
            Integer froId = new Integer(sccpchMo.getFroId(null));
            this.sccpchList.put(froId, sccpchMo);
            MessageLog.trace(4, this.getClass(), "createInd(), SccpchMo is created, froId= " + sccpchMo.getFroId(null) + ", Mo: " + sccpchMo.getLocalDistinguishedName());
        }
        catch (Throwable e) {
            MessageLog.traceError(this.getClass(), "Mo couldn't be created, froId: " + indicationSig.sccpchFroId, e);
        }
    }

    public synchronized void deleteInd(InSignal deleteInd) {
        MessageLog.traceEnter(this.getClass(), "deleteInd()");
        LrsSccpchDeletedIndS indicationSig = (LrsSccpchDeletedIndS)deleteInd;
        try {
            this.deleteSccpch(indicationSig.sccpchFroId);
        }
        catch (Throwable e) {
            MessageLog.traceError(this.getClass(), "Mo couldn't be deleted, froId: " + indicationSig.sccpchFroId, e);
        }
    }

    public synchronized void changeInd(InSignal changeInd) {
        MessageLog.traceEnter(this.getClass(), "changeInd()");
    }

    public void serviceRemoved(String proxyName) {
        MessageLog.traceEnter(this.getClass(), "serviceRemoved()");
        try {
            this.deleteAll();
        }
        catch (Exception t) {
            MessageLog.traceError(this.getClass(), "Couldn't reset the object list" + t);
        }
    }

    public void serviceAvailable(String proxyName) {
    }

    public void plugAndPlayInd(InSignal pnpIndSig) {
        MessageLog.traceEnter(this.getClass(), "plugAndPlayInd()");
        if (pnpIndSig == null) {
            MessageLog.traceError(this.getClass(), "The received signal is null!!");
            return;
        }
        if (pnpIndSig.getClass().getName().equals(LrsSccpchCreatedIndS.class.getName())) {
            this.createInd(pnpIndSig);
        } else if (pnpIndSig.getClass().getName().equals(LrsSccpchDeletedIndS.class.getName())) {
            this.deleteInd(pnpIndSig);
        } else {
            MessageLog.traceError(this.getClass(), "unexpected signal is received!! recSig:" + pnpIndSig.getClass().getName());
        }
    }

    public String getMoTypeName() {
        return "Sccpch";
    }

    private synchronized void deleteAll() throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deleteAll()");
        Collection set = this.sccpchList.values();
        Iterator objs = set.iterator();
        SccpchMoImpl tmpObj = null;
        while (objs.hasNext()) {
            tmpObj = (SccpchMoImpl)objs.next();
            tmpObj.moScannerServiceNotAvailable();
            tmpObj.deleteSccpch(null);
        }
        this.sccpchList.clear();
    }

    private void deleteSccpch(int froId) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deleteSccpch(), froId= " + froId);
        Integer key = new Integer(froId);
        SccpchMoImpl mo = (SccpchMoImpl)this.sccpchList.get(key);
        if (mo == null) {
            throw new MoNotFoundException("Couldn't find SccpchMo froId:" + froId);
        }
        mo.deleteSccpch(null);
        this.sccpchList.remove(key);
    }

    private ManagedObject createPhysicalCommonChannel(LrsSccpchCreatedIndS indicationSig) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createPhysicalCommonChannel()");
        return SccpchMoImpl.create(indicationSig);
    }

    public List getCounters() {
        return this.counterList;
    }

    private void setupPmsCounters() {
        MessageLog.traceEnter(this.getClass(), "setupPmsCounters()");
        try {
            CounterGroup cntGrp = new CounterGroup("FachNoOfTrchFrames");
            Counter cnt = new Counter("pmNoOfTfc1OnFach1", 1, cntGrp);
            this.counterList.add(cnt);
            cnt = new Counter("pmNoOfTfc2OnFach1", 1, cntGrp);
            this.counterList.add(cnt);
            cnt = new Counter("pmNoOfTfc3OnFach2", 1, cntGrp);
            this.counterList.add(cnt);
            cnt = new Counter("pmMbmsSccpchTransmittedTfc", 22, null);
            this.counterList.add(cnt);
            new MoScannerAgent("Sccpch", this.counterList);
        }
        catch (Exception pmse) {
            MessageLog.traceError(this.getClass(), "Could not setup boam.pms.MoScannerAgent.", pmse);
        }
    }

    public ManagedObject lookUpSccpchResMo(int sccpchFroId) {
        return (ManagedObject)this.sccpchList.get(new Integer(sccpchFroId));
    }

    public static synchronized void _reset_onlyForTest() {
        if (instance != null) {
            MoFactoryMgr.instance().deregister(instance.getMoTypeName());
            instance = null;
        }
    }
}

