/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.pms.impl;

import java.util.HashMap;
import java.util.Map;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.pms.impl.CounterScannerAgent;
import se.ericsson.wcdma.rbs.boam.pms.impl.GroupInOtherScannerException;

public class CounterGroup {
    private final String groupName;
    private final Map reservedBy = new HashMap(1);
    private final Object lock;
    private int gp;

    public CounterGroup(String groupName) {
        this.groupName = groupName;
        this.lock = new Object();
    }

    public String getGroupName() {
        return this.groupName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(CounterScannerAgent csAgent) {
        Object object = this.lock;
        synchronized (object) {
            this.reservedBy.remove(csAgent.getCounterName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reserve(CounterScannerAgent csAgent, int gp) throws GroupInOtherScannerException {
        Object object = this.lock;
        synchronized (object) {
            if (this.reservedBy.isEmpty()) {
                this.gp = gp;
            } else if (this.gp != gp) {
                String message = csAgent.getCounterName() + " group is already in another scanner with another GP. Group GP= " + this.gp + " , attributes GP= " + gp;
                MessageLog.trace(3, this.getClass(), message);
                throw new GroupInOtherScannerException(message);
            }
            this.reservedBy.put(csAgent.getCounterName(), csAgent);
        }
    }

    public String toString() {
        return this.groupName;
    }
}

