/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.pms.impl;

import java.util.HashSet;
import java.util.Iterator;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoRemovedException;
import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.proxies.ScannedValue;
import se.ericsson.wcdma.rbs.boam.pms.iface.PmPreCondition;
import se.ericsson.wcdma.rbs.boam.pms.iface.Scannable;
import se.ericsson.wcdma.rbs.boam.pms.impl.Counter;
import se.ericsson.wcdma.rbs.boam.pms.impl.CounterScannerAgent;
import se.ericsson.wcdma.rbs.boam.pms.impl.GroupScanner;
import se.ericsson.wcdma.rbs.boam.pms.impl.MoScannerAgent;
import se.ericsson.wcdma.rbs.boam.pms.impl.MoScannerAgentMgr;
import se.ericsson.wcdma.rbs.boam.pms.impl.PmsConst;
import se.ericsson.wcdma.rbs.boam.pms.impl.PmsException;
import se.ericsson.wcdma.rbs.boam.pms.impl.RBScanner;
import se.ericsson.wcdma.rbs.boam.pms.impl.ScannedData;

public class CounterScanner {
    private final Counter counter;
    private final CounterScannerAgent myAgent;
    private final Scannable myRO;
    private final HashSet myReserverList = new HashSet(1);
    private final String myMoLdn;
    private final Object adminLock = new Object();
    private final Object scanLock = new Object();
    private boolean _isActive = false;
    private int[] counterValues = null;
    private boolean _isRoActivated = false;
    private boolean isProxiesAvailable = false;
    private ScannedData scannedData = null;
    private GroupScanner.IScannerTiming _scannerTiming;

    public CounterScanner(Scannable myRO, Counter counter, boolean isRecovery) throws PmsException {
        this.myRO = myRO;
        this.myMoLdn = myRO.getLDN();
        this.counter = counter;
        this.isProxiesAvailable = !isRecovery;
        MoScannerAgent moScannerAgent = MoScannerAgentMgr.instance().lookup(myRO.getTypeName());
        this.myAgent = moScannerAgent.lookup(counter.getName());
        if (this.myAgent == null) {
            throw new PmsException("failed to look up a CounterScannerAgent for counter: " + counter);
        }
        this.myAgent.add(this);
        this._scannerTiming = myRO instanceof GroupScanner ? new NoScannerTiming() : new GroupScanner.ScannerTiming();
        MessageLog.trace(3, this.getClass(), "CounterScanner instance created, counter: " + counter);
    }

    private void sendStart() {
        MessageLog.trace(3, this.getClass(), "sendStart(), counter: " + this.counter);
        if (this.isRoActivated()) {
            return;
        }
        try {
            this.resetMyData();
            if (this.isProxiesAvailable && ((PmPreCondition)((Object)this.myRO)).isPmCounterStartable(this.counter.getName(), null)) {
                this.myRO.start(this.counter.getName(), this.myAgent.getGPInMinutes());
                this.setIsRoActivated(true);
            }
        }
        catch (MoAccessException e) {
            MessageLog.trace(3, this.getClass(), "could not start measurement for counter: " + this.counter + ", " + (Object)((Object)e));
        }
    }

    private void sendStop() {
        if (!this.isRoActivated()) {
            return;
        }
        this.setIsRoActivated(false);
        if (this.isProxiesAvailable) {
            try {
                this.myRO.stop(this.counter.getName());
            }
            catch (MoAccessException e) {
                MessageLog.trace(3, this.getClass(), "could not stop measurement for counter: " + this.counter + ", " + (Object)((Object)e));
            }
        }
    }

    public void delete() {
        MessageLog.trace(3, this.getClass(), "delete(), counter: " + this.counter);
        try {
            this.myAgent.remove(this);
            this.stop();
        }
        catch (PmsException pmse) {
            MessageLog.trace(3, this.getClass(), "failed to unregister CounterScanner: " + this + ", " + (Object)((Object)pmse));
        }
        Iterator iter = this.myReserverList.iterator();
        while (iter.hasNext()) {
            RBScanner reserver = (RBScanner)((Object)iter.next());
            reserver.removeCounterObject(this);
        }
    }

    public int[] getValue() {
        MessageLog.trace(3, this.getClass(), "getValue(), counter: " + this.counter);
        return this.counterValues;
    }

    private void handleReceivedData(ScannedValue[] values) {
        MessageLog.traceEnter(this.getClass(), "handleReceivedData(), counter: " + this.counter + ", MO: " + this.myMoLdn);
        if (values == null || values.length != 1) {
            MessageLog.trace(3, this.getClass(), "received counter value is empty or has more than one element");
            this.resetMyData();
        } else if (!values[0].getName().equals(this.counter.getName())) {
            MessageLog.trace(3, this.getClass(), "wrong counter value received: " + this.counter + " != " + values[0].getName());
            this.resetMyData();
        } else {
            this.counterValues = values[0].getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void proxiesUnavailable() {
        MessageLog.trace(3, this.getClass(), "proxiesUnavailable(), service removed, counter: " + this.counter);
        Object object = this.adminLock;
        synchronized (object) {
            this.isProxiesAvailable = false;
            this.setIsRoActivated(false);
            if (this.myRO instanceof GroupScanner) {
                ((GroupScanner)this.myRO).setInactive();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void proxiesAvailable() {
        MessageLog.trace(3, this.getClass(), "proxiesAvailable(), service added, counter: " + this.counter);
        Object object = this.adminLock;
        synchronized (object) {
            this.isProxiesAvailable = true;
            if (this.isActive() && !this.isRoActivated()) {
                this.sendStart();
            }
        }
    }

    public void release(RBScanner reserver) {
        MessageLog.trace(3, this.getClass(), "release(), counter: " + this.counter);
        this.myReserverList.remove((Object)reserver);
        reserver.removeCounterObject(this);
        this.suspend();
    }

    private ScannedData createScannedData() throws SoftwareErrorException {
        MessageLog.trace(3, this.getClass(), "replay()");
        return new ScannedData(this.counter.getName(), this.myMoLdn, this.counterValues);
    }

    public void reserve(RBScanner reserver) {
        MessageLog.trace(3, this.getClass(), "reserve(), counter: " + this.counter);
        this.myReserverList.add(reserver);
        reserver.addCounterObject(this);
    }

    private void resetMyData() {
        this.counterValues = PmsConst.getCounterDefaultArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScannedData scan(int granularityPeriodInSeconds) throws SoftwareErrorException {
        Object object = this.scanLock;
        synchronized (object) {
            MessageLog.trace(3, this.getClass(), "scan(), counter: " + this.counter);
            this._scannerTiming.scanningStarted();
            MessageLog.trace(3, this.getClass(), " granularityPeriodInSeconds : " + granularityPeriodInSeconds);
            if (this.scannedData == null) {
                this._scannerTiming.calibrateGP(granularityPeriodInSeconds);
                this.scannedData = this.resourceRead();
            } else if (this._scannerTiming.isNextGP()) {
                this._scannerTiming.calibrateGP(granularityPeriodInSeconds);
                this.scannedData = this.resourceRead();
            }
            return this.scannedData;
        }
    }

    private ScannedData resourceRead() throws SoftwareErrorException {
        if (!this.isRoActivated()) {
            this.sendStart();
            return this.createScannedData();
        }
        try {
            this.handleReceivedData(this.myRO.scan(this.counter.getName()));
        }
        catch (MoRemovedException morm) {
            MessageLog.trace(3, this.getClass(), "MO is removed, could not fetch measurement for counter: " + this.counter + ", " + (Object)((Object)morm));
            this.resetMyData();
        }
        catch (Exception e) {
            MessageLog.trace(3, this.getClass(), "could not fetch measurement for counter: " + this.counter + ", " + e);
            this.resetMyData();
        }
        return this.createScannedData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        MessageLog.trace(3, this.getClass(), "suspend(), counter: " + this.counter);
        Object object = this.adminLock;
        synchronized (object) {
            if (this.allReserversSuspended()) {
                this.setIsActive(false);
                if (this.isRoActivated()) {
                    this.sendStop();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        MessageLog.trace(3, this.getClass(), "stop(), counter: " + this.counter);
        Object object = this.adminLock;
        synchronized (object) {
            this.setIsActive(false);
            if (this.isRoActivated()) {
                this.sendStop();
            }
        }
    }

    private void setIsActive(boolean isIt) {
        this._isActive = isIt;
    }

    private void setIsRoActivated(boolean isIt) {
        this._isRoActivated = isIt;
    }

    private boolean isRoActivated() {
        return this._isRoActivated;
    }

    private boolean isActive() {
        return this._isActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCounterScannerActive() {
        Object object = this.adminLock;
        synchronized (object) {
            return this.isActive();
        }
    }

    public boolean allReserversSuspended() {
        Iterator iter = this.myReserverList.iterator();
        while (iter.hasNext()) {
            RBScanner reserver = (RBScanner)((Object)iter.next());
            if (reserver.isSuspended()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() {
        MessageLog.trace(3, this.getClass(), "activate(), counter: " + this.counter);
        Object object = this.adminLock;
        synchronized (object) {
            this.setIsActive(true);
            if (!this.isRoActivated()) {
                this.sendStart();
            }
        }
    }

    public String toString() {
        return "MO: " + this.myMoLdn + ", counter: " + this.counter;
    }

    public int _forTestOnly_getReserverList() {
        return this.myReserverList.size();
    }

    public static class NoScannerTiming
    implements GroupScanner.IScannerTiming {
        public boolean isNextGP() {
            return true;
        }

        public void calibrateGP(int gp) {
        }

        public void scanningStarted() {
        }
    }
}

