/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.pms.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.pms.generic.BasicScanner;
import se.ericsson.cello.pms.generic.BasicScannerFactory;
import se.ericsson.cello.pms.generic.DataConsumer;
import se.ericsson.cello.pms.generic.GranularityAndAttributeActivationException;
import se.ericsson.cello.pms.generic.GranularityPeriod;
import se.ericsson.cello.pms.generic.GranularityPeriodNotSupportedException;
import se.ericsson.cello.pms.generic.NumberOfCountersExceededException;
import se.ericsson.cello.pms.generic.ObservationClass;
import se.ericsson.cello.pms.generic.ObservationObject;
import se.ericsson.cello.pms.generic.OverloadException;
import se.ericsson.cello.pms.generic.ParameterNotAcceptedException;
import se.ericsson.cello.pms.generic.PerformanceMonitoringState;
import se.ericsson.cello.pms.generic.PmStateListener;
import se.ericsson.cello.pms.generic.PmsPortalImpl;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.pms.impl.Counter;
import se.ericsson.wcdma.rbs.boam.pms.impl.PredefinedScannerMgr;
import se.ericsson.wcdma.rbs.boam.pms.impl.RBScanner;

public class RBScannerFactory
implements BasicScannerFactory,
PmStateListener {
    private static final RBScannerFactory INSTANCE = new RBScannerFactory();
    private final Map counterLists = new HashMap();
    private volatile boolean isRegisteringStarted = false;

    private RBScannerFactory() {
    }

    public static RBScannerFactory instance() {
        return INSTANCE;
    }

    public void registerObservationClass(String moType, List counters) {
        MessageLog.trace(3, this.getClass(), "registerObservationClass()");
        if (this.counterLists.containsKey(moType)) {
            MessageLog.traceError(this.getClass(), "MO type already registered: " + moType);
        }
        this.counterLists.put(moType, counters);
        if (!this.isRegisteringStarted) {
            MessageLog.trace(3, this.getClass(), "init() has not been called yet; deferred registering to CPP for MO type: " + moType);
        } else {
            MessageLog.trace(3, this.getClass(), "init() has been called; registering to CPP for MO type: " + moType);
            PmsPortalImpl.getPortal().registerCounterTypes(moType, this.getCounterNames(counters), this.getArrayOfNoOfReturnElements(counters), (BasicScannerFactory)this);
        }
    }

    public void deregisterObservationClass(String moType) {
        MessageLog.trace(3, this.getClass(), "deregisterObservationClass()");
        if (this.counterLists.containsKey(moType)) {
            this.counterLists.remove(moType);
            if (this.isRegisteringStarted) {
                PmsPortalImpl.getPortal().deregisterCounterTypes(moType, (BasicScannerFactory)this);
            }
        }
    }

    public void moMoppletInit() {
        MessageLog.trace(3, this.getClass(), "moMoppletInit()");
        PmsPortalImpl.getPortal().addPmStateListener((PmStateListener)this);
    }

    public void init() {
        MessageLog.trace(3, this.getClass(), "init()");
        Iterator iter = this.counterLists.keySet().iterator();
        while (iter.hasNext()) {
            String moTypeName = (String)iter.next();
            List counterList = (List)this.counterLists.get(moTypeName);
            PmsPortalImpl.getPortal().registerCounterTypes(moTypeName, this.getCounterNames(counterList), this.getArrayOfNoOfReturnElements(counterList), (BasicScannerFactory)this);
        }
        this.isRegisteringStarted = true;
    }

    public BasicScanner create(ObservationClass[] ocList, ObservationObject[] ooList, GranularityPeriod gp, PerformanceMonitoringState state, DataConsumer destination, String measurementName, Coordinator coordinator) throws GranularityPeriodNotSupportedException, NumberOfCountersExceededException, GranularityAndAttributeActivationException, OverloadException, ParameterNotAcceptedException {
        MessageLog.trace(3, this.getClass(), "create(), measurementName:" + measurementName);
        return new RBScanner(ocList, ooList, gp, state, destination, measurementName, coordinator);
    }

    private String[] getCounterNames(List counters) {
        MessageLog.trace(3, this.getClass(), "getCounterNames()");
        String[] result2 = new String[counters.size()];
        Iterator iter = counters.iterator();
        for (int i = 0; i < result2.length; ++i) {
            result2[i] = ((Counter)iter.next()).getName();
        }
        return result2;
    }

    private int[] getArrayOfNoOfReturnElements(List counters) {
        MessageLog.trace(3, this.getClass(), "getArrayOfNoOfReturnElements()");
        int[] result2 = new int[counters.size()];
        Iterator iter = counters.iterator();
        for (int i = 0; i < result2.length; ++i) {
            result2[i] = ((Counter)iter.next()).getNoOfReturnElements();
        }
        return result2;
    }

    public void start() {
        MessageLog.trace(3, this.getClass(), "start()");
        PredefinedScannerMgr.instance().start();
    }

    public void _reset_onlyForTest() {
        this.counterLists.clear();
    }
}

