/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.jce.provider;

import com.ibm.j9.bluez.crypto.CL3;
import com.ibm.j9.jce.provider.Msg;
import java.math.BigInteger;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Random;
import javax.crypto.spec.DHGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public final class AlgorithmParameterGeneratorDH
extends AlgorithmParameterGeneratorSpi {
    private static final int DEFAULT_EXPONENT_LEN_BITS = 512;
    private static final int DEFAULT_PRIME_LEN_BITS = 512;
    private int exponentLenBits = 512;
    private int primeLenBits = 512;
    private SecureRandom sr = null;

    protected AlgorithmParameters engineGenerateParameters() {
        AlgorithmParameters result;
        CL3 parms = CL3.dhParamGen((int)this.primeLenBits, (Random)this.sr);
        BigInteger G = new BigInteger(CL3.dhGetBaseGenerator((CL3)parms));
        BigInteger P = new BigInteger(CL3.dhGetModulus((CL3)parms));
        DHParameterSpec spec = new DHParameterSpec(P, G, this.exponentLenBits);
        try {
            result = AlgorithmParameters.getInstance("DH", "J9JCE");
            result.init(spec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            return null;
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            return null;
        }
        return result;
    }

    protected void engineInit(int size, SecureRandom random) {
        this.exponentLenBits = size;
        this.primeLenBits = size;
        this.sr = random;
        this.validate();
    }

    private void validate() {
        if (this.exponentLenBits % 64 != 0) {
            throw new InvalidParameterException(Msg.getString("K01ec"));
        }
        if (this.exponentLenBits < 512) {
            throw new InvalidParameterException(Msg.getString("K01ed"));
        }
    }

    protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(genParamSpec instanceof DHGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException();
        }
        DHGenParameterSpec spec = (DHGenParameterSpec)genParamSpec;
        this.exponentLenBits = spec.getExponentSize();
        this.primeLenBits = spec.getPrimeSize();
        this.sr = random;
        this.validate();
    }
}

