/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.jce.provider;

import com.ibm.j9.jce.provider.CipherSpiJ9;
import com.ibm.j9.jce.provider.Msg;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;

public abstract class AsymmetricCipherSpi
extends CipherSpiJ9 {
    protected byte[] initializationVector = null;
    protected byte[] workingIV = null;
    private byte[] unprocessedBuffer = new byte[0];

    protected int getDefaultPadding() {
        return 3;
    }

    protected int getModeID(String mode) {
        if (mode.equalsIgnoreCase("ECB")) {
            return 1;
        }
        return -1;
    }

    protected int engineGetBlockSize() {
        return 0;
    }

    protected int engineGetOutputSize(int inputLength) {
        this.validateState();
        return this.getMaximumEncryptedSize();
    }

    protected byte[] engineGetIV() {
        return null;
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected void engineInit(int opMode, Key key, SecureRandom random) throws InvalidKeyException {
        this.initForOperation(opMode, key, random);
    }

    protected void engineInit(int opMode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(opMode, key, random);
    }

    protected void engineInit(int opMode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(opMode, key, random);
    }

    protected byte[] engineUpdate(byte[] input, int start, int inputLen) {
        this.validateState();
        if (inputLen < 0) {
            throw new IllegalArgumentException();
        }
        try {
            this.engineUpdate(input, start, inputLen, null, 0);
        }
        catch (ShortBufferException shortBufferException) {
            throw new InternalError();
        }
        return null;
    }

    protected int engineUpdate(byte[] input, int start, int inputLen, byte[] output, int outputStart) throws ShortBufferException {
        this.validateState();
        if (input == null || start < 0 || inputLen < 0 || outputStart < 0) {
            throw new IllegalArgumentException();
        }
        byte[] newUnprocessedBuffer = new byte[this.unprocessedBuffer.length + inputLen];
        System.arraycopy(this.unprocessedBuffer, 0, newUnprocessedBuffer, 0, this.unprocessedBuffer.length);
        System.arraycopy(input, start, newUnprocessedBuffer, this.unprocessedBuffer.length, inputLen);
        this.unprocessedBuffer = newUnprocessedBuffer;
        return 0;
    }

    protected byte[] engineDoFinal(byte[] input, int start, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        this.validateState();
        byte[] output = new byte[this.engineGetOutputSize(inputLen)];
        int bytesProcessed = 0;
        try {
            bytesProcessed = this.engineDoFinal(input, start, inputLen, output, 0);
        }
        catch (ShortBufferException shortBufferException) {
            throw new InternalError();
        }
        if (bytesProcessed == 0) {
            return null;
        }
        if (bytesProcessed < output.length) {
            byte[] buffer = new byte[bytesProcessed];
            System.arraycopy(output, 0, buffer, 0, bytesProcessed);
            return buffer;
        }
        return output;
    }

    protected int engineDoFinal(byte[] input, int start, int inputLen, byte[] output, int outputStart) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        this.validateState();
        if (start < 0 || inputLen < 0 || output == null || outputStart < 0) {
            throw new IllegalArgumentException();
        }
        if (input != null) {
            this.engineUpdate(input, start, inputLen, output, outputStart);
        }
        if (this.operationMode == 1) {
            if (this.unprocessedBuffer.length > this.getMaximumMessageSize()) {
                throw new IllegalBlockSizeException(Msg.getString("K0389"));
            }
            if (this.unprocessedBuffer.length < this.getMinimumMessageSize()) {
                throw new IllegalBlockSizeException(Msg.getString("K037f"));
            }
        }
        if (output.length - outputStart < this.engineGetOutputSize(inputLen)) {
            throw new ShortBufferException();
        }
        int length = this.process(this.unprocessedBuffer, this.unprocessedBuffer.length, output, outputStart);
        this.reset();
        if (this.operationMode == 2 && length == -1) {
            throw new BadPaddingException(Msg.getString("K035b"));
        }
        if (this.operationMode == 2 && length == -1) {
            throw new BadPaddingException(Msg.getString("K035c"));
        }
        return length;
    }

    protected void reset() {
        this.unprocessedBuffer = new byte[0];
        this.algorithmSpecificReset();
    }

    protected abstract int process(byte[] var1, int var2, byte[] var3, int var4);

    protected abstract void algorithmSpecificReset();

    protected abstract int getMaximumEncryptedSize();

    protected abstract int getMaximumMessageSize();

    protected abstract int getMinimumMessageSize();
}

