/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.jce.provider;

import com.ibm.j9.bluez.crypto.CL3;
import com.ibm.j9.jce.provider.Msg;
import com.ibm.j9.jce.provider.PrivateKeyDH;
import com.ibm.j9.jce.provider.PublicKeyDH;
import com.ibm.j9.jce.provider.Util;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class KeyAgreementDH
extends KeyAgreementSpi {
    private PrivateKeyDH key;
    private DHParameterSpec params;
    private SecureRandom random;
    private int exponentSize;
    private int primeSize;
    private boolean isInitialised = false;
    private byte[] sharedSecret = null;

    protected void engineInit(Key key, SecureRandom random) throws InvalidKeyException {
        if (!(key instanceof PrivateKeyDH)) {
            throw new InvalidKeyException();
        }
        this.key = (PrivateKeyDH)key;
        this.params = this.key.getParams();
        if (this.params == null) {
            throw new InvalidKeyException();
        }
        this.random = random;
        this.isInitialised = true;
    }

    protected void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(key instanceof PrivateKeyDH)) {
            throw new InvalidKeyException();
        }
        this.key = (PrivateKeyDH)key;
        if (!(params instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException();
        }
        if (!KeyAgreementDH.keyParametersMatch(this.key, (DHParameterSpec)params)) {
            throw new InvalidKeyException(Msg.getString("JCP016"));
        }
        this.params = (DHParameterSpec)params;
        this.random = random;
        this.isInitialised = true;
    }

    protected Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        if (!this.isInitialised) {
            throw new IllegalStateException();
        }
        if (!(key instanceof DHPublicKey)) {
            throw new InvalidKeyException();
        }
        DHPublicKey dhPubKey = (DHPublicKey)key;
        if (!KeyAgreementDH.keyParametersMatch(dhPubKey, this.key)) {
            throw new InvalidKeyException(Msg.getString("JCP016"));
        }
        int resultSizeBytes = this.params.getP().bitLength() + 0;
        byte[] resultCL3 = new byte[resultSizeBytes];
        byte[] publicKeyMaterial = dhPubKey.getY().toByteArray();
        int resultLen = CL3.dh((CL3)this.key.CL3Handle, (byte[])publicKeyMaterial, (int)0, (int)publicKeyMaterial.length, (byte[])resultCL3, (int)0);
        byte[] result = new byte[resultLen];
        System.arraycopy(resultCL3, 0, result, 0, resultLen);
        if (lastPhase) {
            this.sharedSecret = result;
            return null;
        }
        new BigInteger(1, result);
        CL3 pubKeyCL3 = CL3.dhGetPublicKeyFromComponents((byte[])this.params.getG().toByteArray(), (byte[])this.params.getP().toByteArray(), (byte[])result);
        return new PublicKeyDH(pubKeyCL3);
    }

    private static boolean keyParametersMatch(DHPublicKey pubKey, DHPrivateKey privKey) {
        DHParameterSpec pubKeyParms = pubKey.getParams();
        DHParameterSpec privKeyParms = privKey.getParams();
        if (!pubKeyParms.getG().equals(privKeyParms.getG())) {
            return false;
        }
        return pubKeyParms.getP().equals(pubKeyParms.getP());
    }

    private static boolean keyParametersMatch(DHPrivateKey key, DHParameterSpec params) {
        DHParameterSpec privKeyParms = key.getParams();
        if (!privKeyParms.getG().equals(params.getG())) {
            return false;
        }
        return privKeyParms.getP().equals(params.getP());
    }

    protected byte[] engineGenerateSecret() throws IllegalStateException {
        if (this.sharedSecret == null) {
            throw new IllegalStateException();
        }
        byte[] result = this.sharedSecret;
        this.sharedSecret = null;
        return result;
    }

    protected int engineGenerateSecret(byte[] sharedSecret, int offset) throws IllegalStateException, ShortBufferException {
        if (this.sharedSecret == null) {
            throw new IllegalStateException();
        }
        if (sharedSecret.length - offset < this.sharedSecret.length) {
            throw new ShortBufferException();
        }
        System.arraycopy(this.sharedSecret, 0, sharedSecret, offset, this.sharedSecret.length);
        int result = this.sharedSecret.length;
        this.sharedSecret = null;
        return result;
    }

    protected SecretKey engineGenerateSecret(String algorithm) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        if (this.sharedSecret == null) {
            throw new IllegalStateException();
        }
        SecretKeySpec spec = new SecretKeySpec(this.sharedSecret, 0, this.sharedSecret.length, algorithm);
        try {
            SecretKeyFactory skf = SecretKeyFactory.getInstance(algorithm);
            SecretKey key = skf.generateSecret(spec);
            this.sharedSecret = null;
            return key;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (Util.isSKSSupportedAlgorithm(algorithm)) {
                this.sharedSecret = null;
                return spec;
            }
            throw new NoSuchAlgorithmException();
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            if (Util.isSKSSupportedAlgorithm(algorithm)) {
                this.sharedSecret = null;
                return spec;
            }
            throw new NoSuchAlgorithmException();
        }
    }
}

