/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.jce.provider;

import com.ibm.j9.bluez.crypto.CL3;
import com.ibm.j9.bluez.crypto.CL3Exception;
import com.ibm.j9.jce.provider.PrivateKeyDH;
import com.ibm.j9.jce.provider.PublicKeyDH;
import com.ibm.oti.util.ASN1Decoder;
import com.ibm.oti.util.ASN1Exception;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;

public final class KeyFactoryDH
extends KeyFactorySpi {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof DHPrivateKeySpec) {
            DHPrivateKeySpec spec = (DHPrivateKeySpec)keySpec;
            CL3 dhPrivateKey = CL3.dhGetPrivateKeyFromComponents((byte[])spec.getG().toByteArray(), (byte[])spec.getP().toByteArray(), (byte[])spec.getX().toByteArray());
            return new PrivateKeyDH(dhPrivateKey);
        }
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            PKCS8EncodedKeySpec spec = (PKCS8EncodedKeySpec)keySpec;
            byte[] keyEncoding = spec.getEncoded();
            try {
                return this.dhPrivateKeyFromPKCS8(keyEncoding);
            }
            catch (RuntimeException runtimeException) {
                throw new InvalidKeySpecException();
            }
        }
        throw new InvalidKeySpecException();
    }

    private PrivateKey dhPrivateKeyFromPKCS8(byte[] keyEncoding) throws InvalidKeySpecException {
        Object[] privateKeyInfo;
        try {
            privateKeyInfo = (Object[])ASN1Decoder.getDecoded((byte[])keyEncoding);
        }
        catch (ASN1Exception aSN1Exception) {
            throw new InvalidKeySpecException();
        }
        Object[] privateKeyAlgorithm = (Object[])privateKeyInfo[1];
        Object[] parameters = (Object[])privateKeyAlgorithm[1];
        BigInteger P = (BigInteger)parameters[0];
        BigInteger G = (BigInteger)parameters[1];
        byte[] privateKeyBytes = (byte[])privateKeyInfo[2];
        CL3 dhPrivateKey = CL3.dhGetPrivateKeyFromComponents((byte[])G.toByteArray(), (byte[])P.toByteArray(), (byte[])privateKeyBytes);
        return new PrivateKeyDH(dhPrivateKey);
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof DHPublicKeySpec) {
                DHPublicKeySpec spec = (DHPublicKeySpec)keySpec;
                CL3 dhPublicKey = CL3.dhGetPublicKeyFromComponents((byte[])spec.getG().toByteArray(), (byte[])spec.getP().toByteArray(), (byte[])spec.getY().toByteArray());
                return new PublicKeyDH(dhPublicKey);
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                byte[] keyEncoding = ((X509EncodedKeySpec)keySpec).getEncoded();
                try {
                    return this.dhPublicKeyFromSPKI(keyEncoding);
                }
                catch (RuntimeException runtimeException) {
                    throw new InvalidKeySpecException();
                }
            }
        }
        catch (CL3Exception e) {
            throw new InvalidKeySpecException(e.getMessage());
        }
        catch (ASN1Exception e) {
            throw new InvalidKeySpecException(e.getMessage());
        }
        throw new InvalidKeySpecException();
    }

    private PublicKey dhPublicKeyFromSPKI(byte[] keyEncoding) throws ASN1Exception {
        Object[] subjectPublicKeyInfo = (Object[])ASN1Decoder.getDecoded((byte[])keyEncoding);
        Object[] spkiAlgorithm = (Object[])subjectPublicKeyInfo[0];
        Object[] parameters = (Object[])spkiAlgorithm[1];
        BigInteger P = (BigInteger)parameters[0];
        BigInteger G = (BigInteger)parameters[1];
        byte[] spkiPublicKey = ((ASN1Decoder.BitString)subjectPublicKeyInfo[1]).data;
        CL3 dhPublicKey = CL3.dhGetPublicKeyFromComponents((byte[])G.toByteArray(), (byte[])P.toByteArray(), (byte[])spkiPublicKey);
        return new PublicKeyDH(dhPublicKey);
    }

    protected KeySpec engineGetKeySpec(Key key, Class keySpec) throws InvalidKeySpecException {
        if (key instanceof DHPublicKey) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("javax.crypto.spec.DHPublicKeySpec");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (keySpec == clazz) {
                DHPublicKey pubKey = (DHPublicKey)key;
                DHParameterSpec params = pubKey.getParams();
                return new DHPublicKeySpec(pubKey.getY(), params.getP(), params.getG());
            }
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.security.spec.X509EncodedKeySpec");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (keySpec == clazz2) {
                DHPublicKey pubKey = (DHPublicKey)key;
                return new X509EncodedKeySpec(pubKey.getEncoded());
            }
            throw new InvalidKeySpecException();
        }
        if (key instanceof DHPrivateKey) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("javax.crypto.spec.DHPrivateKeySpec");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (keySpec == clazz) {
                DHPrivateKey privKey = (DHPrivateKey)key;
                DHParameterSpec params = privKey.getParams();
                return new DHPrivateKeySpec(privKey.getX(), params.getP(), params.getG());
            }
            Class<?> clazz3 = class$3;
            if (clazz3 == null) {
                try {
                    clazz3 = class$3 = Class.forName("java.security.spec.PKCS8EncodedKeySpec");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (keySpec == clazz3) {
                DHPrivateKey privKey = (DHPrivateKey)key;
                return new PKCS8EncodedKeySpec(privKey.getEncoded());
            }
            throw new InvalidKeySpecException();
        }
        throw new InvalidKeySpecException();
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        try {
            if (key instanceof DHPublicKey) {
                DHPublicKey pubKey = (DHPublicKey)key;
                DHParameterSpec params = pubKey.getParams();
                CL3 pubKeyCL3 = CL3.dhGetPublicKeyFromComponents((byte[])params.getG().toByteArray(), (byte[])params.getP().toByteArray(), (byte[])pubKey.getY().toByteArray());
                return new PublicKeyDH(pubKeyCL3);
            }
            if (key instanceof DHPrivateKey) {
                DHPrivateKey privKey = (DHPrivateKey)key;
                DHParameterSpec params = privKey.getParams();
                CL3 privKeyCL3 = CL3.dhGetPrivateKeyFromComponents((byte[])params.getG().toByteArray(), (byte[])params.getP().toByteArray(), (byte[])privKey.getX().toByteArray());
                return new PrivateKeyDH(privKeyCL3);
            }
        }
        catch (CL3Exception e) {
            throw new InvalidKeyException(e.getMessage());
        }
        throw new InvalidKeyException();
    }
}

