/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.jce.provider;

import com.ibm.j9.jce.provider.Msg;
import com.ibm.j9.jce.provider.SecretKeyAES;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;

public class KeyGeneratorAES
extends KeyGeneratorSpi {
    private static final int DEFAULT_KEY_LEN_BYTES = 16;
    private SecureRandom secureRandom = null;
    private int keyLengthBytes = 16;

    protected SecretKey engineGenerateKey() {
        if (this.secureRandom == null) {
            this.secureRandom = new SecureRandom();
        }
        byte[] keyMaterial = new byte[this.keyLengthBytes];
        this.secureRandom.nextBytes(keyMaterial);
        return new SecretKeyAES(keyMaterial);
    }

    protected void engineInit(AlgorithmParameterSpec parameters, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException(Msg.getString("JCP004"));
    }

    protected void engineInit(int keylen, SecureRandom secureRandom) {
        switch (keylen) {
            case 128: 
            case 192: 
            case 256: {
                this.keyLengthBytes = keylen / 8;
                break;
            }
            default: {
                throw new InvalidParameterException();
            }
        }
        if (secureRandom == null) {
            throw new IllegalArgumentException();
        }
        this.secureRandom = secureRandom;
    }

    protected void engineInit(SecureRandom secureRandom) {
        this.secureRandom = secureRandom == null ? new SecureRandom() : secureRandom;
    }
}

