/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.jce.provider;

import com.ibm.j9.jce.provider.Msg;
import com.ibm.j9.jce.provider.SecretKeyBlowfish;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;

public final class KeyGeneratorBlowfish
extends KeyGeneratorSpi {
    private final int MIN_KEY_LEN_BITS = 32;
    private final int MAX_KEYLEN_SIZE_BYTES = 56;
    private final int DEFAULT_KEYLEN_SIZE_BYTES = 16;
    private final int BYTE_BIT_LEN = 8;
    private SecureRandom random;
    private int keyLengthBytes = 16;

    protected void engineInit(SecureRandom random) {
        this.random = random == null ? new SecureRandom() : random;
    }

    protected void engineInit(AlgorithmParameterSpec parameters, SecureRandom random) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException(Msg.getString("JCP017"));
    }

    protected void engineInit(int keylen, SecureRandom random) throws InvalidParameterException {
        if (random == null) {
            throw new NullPointerException();
        }
        this.random = random;
        if (keylen < 32) {
            throw new InvalidParameterException(Msg.getString("JCP019"));
        }
        if (keylen % 8 != 0) {
            throw new InvalidParameterException(Msg.getString("JCP018"));
        }
        int keyLenBytes = keylen / 8;
        if (keyLenBytes < 0 || keyLenBytes > 56) {
            throw new InvalidParameterException(Msg.getString("JCP019"));
        }
        this.keyLengthBytes = keyLenBytes;
    }

    protected SecretKey engineGenerateKey() {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        byte[] keyMaterial = new byte[this.keyLengthBytes];
        this.random.nextBytes(keyMaterial);
        return new SecretKeyBlowfish(keyMaterial);
    }
}

