/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.jce.provider;

import com.ibm.j9.bluez.crypto.CL3;
import com.ibm.j9.jce.provider.Msg;
import com.ibm.j9.jce.provider.PrivateKeyDH;
import com.ibm.j9.jce.provider.PublicKeyDH;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Random;
import javax.crypto.spec.DHParameterSpec;

public final class KeyPairGeneratorDH
extends KeyPairGeneratorSpi {
    private static final int DEFAULT_EXPONENT_SIZE_BITS = 160;
    private static final int DEFAULT_PRIME_SIZE_BITS = 512;
    private CL3 dhParams = null;
    private int exponentSize = 160;
    private int primeSize = 512;
    private SecureRandom random = null;

    public KeyPair generateKeyPair() {
        int primeSizeCL3 = KeyPairGeneratorDH.getCL3PrimeSizeRepresentation(this.primeSize);
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        if (this.exponentSize == 0) {
            this.exponentSize = 160;
        }
        CL3 CL3privateKey = CL3.dhKeyGen((CL3)this.dhParams, (int)primeSizeCL3, (int)this.exponentSize, (Random)this.random);
        PrivateKeyDH privateKey = new PrivateKeyDH(CL3privateKey);
        PublicKeyDH publicKey = new PublicKeyDH(CL3privateKey);
        return new KeyPair(publicKey, privateKey);
    }

    public void initialize(int keySize, SecureRandom random) {
        this.random = random;
        this.primeSize = keySize;
        this.validate();
    }

    private void validate() {
        if (this.primeSize % 64 != 0) {
            throw new InvalidParameterException(Msg.getString("K01ec"));
        }
        if (this.primeSize < 512) {
            throw new InvalidParameterException(Msg.getString("K01ed"));
        }
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(params instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException();
        }
        DHParameterSpec spec = (DHParameterSpec)params;
        this.exponentSize = spec.getL();
        this.dhParams = CL3.dhImportParams((byte[])spec.getP().toByteArray(), (byte[])spec.getG().toByteArray());
    }

    private static int getCL3PrimeSizeRepresentation(int primeSize) {
        int primeSizeCL3 = primeSize;
        switch (primeSize) {
            case 512: {
                primeSizeCL3 = -1;
                break;
            }
            case 1024: {
                primeSizeCL3 = -2;
                break;
            }
            case 2048: {
                primeSizeCL3 = -3;
            }
        }
        return primeSizeCL3;
    }
}

