/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.jce.provider;

import com.ibm.j9.bluez.crypto.CL3State;
import com.ibm.j9.bluez.crypto.HMAC;
import com.ibm.j9.jce.provider.Msg;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;

public abstract class MacCL3
extends MacSpi {
    byte[] keyMaterial;
    CL3State CL3handle;

    protected int engineGetMacLength() {
        return this.getMacLength();
    }

    protected void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException();
        }
        this.keyMaterial = key.getEncoded();
        if (this.keyMaterial == null) {
            throw new InvalidKeyException(Msg.getString("JCP021"));
        }
        this.CL3handle = this.initMacAlgorithm(this.keyMaterial, 0, this.keyMaterial.length);
    }

    protected void engineUpdate(byte aByte) {
        byte[] data = new byte[]{aByte};
        this.engineUpdate(data, 0, 1);
    }

    protected void engineUpdate(byte[] input, int offset, int len) {
        HMAC.hmac((CL3State)this.CL3handle, (byte[])input, (int)offset, (int)len, null, (int)0);
    }

    protected byte[] engineDoFinal() {
        byte[] result = new byte[this.engineGetMacLength()];
        HMAC.hmac((CL3State)this.CL3handle, null, (int)0, (int)0, (byte[])result, (int)0);
        this.engineReset();
        return result;
    }

    protected void engineReset() {
        this.CL3handle = this.initMacAlgorithm(this.keyMaterial, 0, this.keyMaterial.length);
    }

    protected abstract CL3State initMacAlgorithm(byte[] var1, int var2, int var3);

    protected abstract int getMacLength();
}

