/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.jce.provider.pkcs;

import com.ibm.j9.jce.provider.Msg;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class PKCS5 {
    public static final int SALT_LENGTH = 8;
    public static final int DEFAULT_ITERATION_COUNT = 1024;

    public static byte[] PKCS5_PBKDF1(String mdAlgorithm, char[] password, byte[] salt, int iterCount, int derivedKeyLen) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance(mdAlgorithm);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
        if (derivedKeyLen > md.getDigestLength()) {
            throw new IllegalArgumentException(Msg.getString("JCP026"));
        }
        if (salt.length != 8) {
            throw new IllegalArgumentException(Msg.getString("JCP027"));
        }
        try {
            byte[] pwdBytes;
            String pwdStr = new String(password);
            try {
                pwdBytes = pwdStr.getBytes("ISO8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                pwdBytes = pwdStr.getBytes();
            }
            md.update(pwdBytes);
            md.update(salt);
            byte[] T1 = md.digest();
            md.reset();
            byte[] digest = T1;
            int i = 2;
            while (i <= iterCount) {
                digest = md.digest(digest);
                ++i;
            }
            byte[] result = new byte[derivedKeyLen];
            System.arraycopy(digest, 0, result, 0, derivedKeyLen);
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static byte[] PKCS5_PBKDF2(String macAlgorithm, char[] password, byte[] salt, int iterCount, int derivedKeyLen) {
        try {
            byte[] pwdBytes;
            Mac mac = Mac.getInstance(macAlgorithm);
            String pwdStr = new String(password);
            try {
                pwdBytes = pwdStr.getBytes("ISO8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                pwdBytes = pwdStr.getBytes();
            }
            SecretKeySpec sks = new SecretKeySpec(pwdBytes, mac.getAlgorithm());
            mac.init(sks);
            int hLen = mac.getMacLength();
            int l = derivedKeyLen / hLen;
            int r = derivedKeyLen % hLen;
            if (r != 0) {
                ++l;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int blockCount = 1;
            while (blockCount <= l) {
                baos.write(PKCS5.F(mac, password, salt, iterCount, blockCount));
                ++blockCount;
            }
            byte[] T = baos.toByteArray();
            byte[] result = new byte[derivedKeyLen];
            System.arraycopy(T, 0, result, 0, derivedKeyLen);
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static byte[] F(Mac mac, char[] password, byte[] salt, int iterationCount, int i) {
        byte[][] U = new byte[iterationCount + 1][];
        byte[] iInt = PKCS5.bytesForInt(i);
        byte[] U1Material = new byte[salt.length + 4];
        System.arraycopy(salt, 0, U1Material, 0, salt.length);
        System.arraycopy(iInt, 0, U1Material, salt.length, 4);
        U[1] = mac.doFinal(U1Material);
        int iter = 2;
        while (iter <= iterationCount) {
            U[iter] = mac.doFinal(U[iter - 1]);
            ++iter;
        }
        byte[] accumulatedResult = U[1];
        int iter2 = 2;
        while (iter2 <= iterationCount) {
            accumulatedResult = PKCS5.xor(accumulatedResult, U[iter2]);
            ++iter2;
        }
        return accumulatedResult;
    }

    private static byte[] bytesForInt(int i) {
        byte[] result = new byte[4];
        int j = 0;
        while (j < 4) {
            result[j] = (byte)(i >>> 8 * (3 - j) & 0xF);
            ++j;
        }
        return result;
    }

    private static byte[] xor(byte[] arr1, byte[] arr2) {
        byte[] result = new byte[arr1.length];
        int i = 0;
        while (i < arr1.length) {
            result[i] = (byte)(arr1[i] ^ arr2[i]);
            ++i;
        }
        return result;
    }
}

