/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.jsse;

import com.ibm.oti.security.provider.X500Principal;
import java.net.Socket;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import javax.net.ssl.X509KeyManager;

public class J9X509KeyManager
implements X509KeyManager {
    private KeyStore keyStore;
    private char[] keyStorePassword;

    J9X509KeyManager(KeyStore keyStore, char[] keyStorePassword) {
        this.keyStore = keyStore;
        this.keyStorePassword = keyStorePassword;
    }

    public String[] getClientAliases(String keyAlgorithmName, Principal[] trustedIssuers) {
        Vector candidateAliases = null;
        try {
            candidateAliases = J9X509KeyManager.getCandidateAliases(this.keyStore, keyAlgorithmName, trustedIssuers);
        }
        catch (KeyStoreException keyStoreException) {
            return null;
        }
        int resultSize = candidateAliases.size();
        if (resultSize != 0) {
            String[] result = new String[resultSize];
            candidateAliases.toArray(result);
            return result;
        }
        return null;
    }

    private static Vector getCandidateAliases(KeyStore keyStore, String keyAlgorithmName, Principal[] trustedIssuers) throws KeyStoreException {
        Vector<String> candidateAliases = new Vector<String>();
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!J9X509KeyManager.isEntryCandidate(alias, keyStore, keyAlgorithmName, trustedIssuers)) continue;
            candidateAliases.add(alias);
        }
        return candidateAliases;
    }

    private static boolean isEntryCandidate(String alias, KeyStore keyStore, String keyAlgorithmName, Principal[] trustedIssuers) throws KeyStoreException {
        if (keyStore.isKeyEntry(alias)) {
            X500Principal certSubject = null;
            X500Principal certIssuer = null;
            X500Principal[] x500TrustedIssuers = null;
            if (trustedIssuers != null) {
                x500TrustedIssuers = new X500Principal[trustedIssuers.length];
                int i = 0;
                while (i != trustedIssuers.length) {
                    x500TrustedIssuers[i] = new X500Principal(trustedIssuers[i].getName());
                    ++i;
                }
            }
            Certificate[] certs = keyStore.getCertificateChain(alias);
            int j = 0;
            while (j != certs.length) {
                X509Certificate x509Cert;
                if (certs[j] instanceof X509Certificate && (x509Cert = (X509Certificate)certs[j]).getPublicKey().getAlgorithm().equals(keyAlgorithmName)) {
                    if (trustedIssuers == null) {
                        return true;
                    }
                    certSubject = new X500Principal(x509Cert.getSubjectDN().getName());
                    if (certIssuer != null && !certSubject.equals(certIssuer)) {
                        return false;
                    }
                    certIssuer = new X500Principal(x509Cert.getIssuerDN().getName());
                    int i = 0;
                    while (i != x500TrustedIssuers.length) {
                        if (x500TrustedIssuers[i].equals((Object)certIssuer) || x500TrustedIssuers[i].equals((Object)certSubject)) {
                            return true;
                        }
                        ++i;
                    }
                }
                ++j;
            }
        }
        return false;
    }

    private static Vector buildTrustedIssuerList(Principal[] trustedIssuers) {
        if (trustedIssuers == null) {
            return null;
        }
        Vector<String> result = new Vector<String>(trustedIssuers.length);
        int i = 0;
        while (i < trustedIssuers.length) {
            result.add(trustedIssuers[i].getName());
            ++i;
        }
        return result;
    }

    public String chooseClientAlias(String[] keyAlgorithmNames, Principal[] trustedIssuers, Socket socket) {
        if (keyAlgorithmNames == null) {
            return null;
        }
        int i = 0;
        while (i < keyAlgorithmNames.length) {
            String[] aliases = this.getClientAliases(keyAlgorithmNames[i], trustedIssuers);
            if (aliases != null) {
                return aliases[0];
            }
            ++i;
        }
        return null;
    }

    private boolean isValidAlgorithmName(String name) {
        return name.equals("RSA") || name.equals("DSS");
    }

    public String[] getServerAliases(String keyAlgorithmName, Principal[] trustedIssuers) {
        if (keyAlgorithmName == null) {
            return null;
        }
        if (trustedIssuers == null && !this.isValidAlgorithmName(keyAlgorithmName)) {
            return null;
        }
        Vector candidateAliases = null;
        try {
            candidateAliases = J9X509KeyManager.getCandidateAliases(this.keyStore, keyAlgorithmName, trustedIssuers);
        }
        catch (KeyStoreException keyStoreException) {
            return null;
        }
        int resultSize = candidateAliases.size();
        if (resultSize != 0) {
            String[] result = new String[resultSize];
            candidateAliases.toArray(result);
            return result;
        }
        return null;
    }

    public String chooseServerAlias(String keyAlgorithmName, Principal[] trustedIssuers, Socket socket) {
        String[] aliases = this.getServerAliases(keyAlgorithmName, trustedIssuers);
        if (aliases != null) {
            return aliases[0];
        }
        return null;
    }

    public X509Certificate[] getCertificateChain(String certChainAlias) {
        if (certChainAlias == null) {
            return null;
        }
        try {
            Certificate[] certChain = this.keyStore.getCertificateChain(certChainAlias);
            if (certChain != null) {
                X509Certificate[] result = new X509Certificate[certChain.length];
                int i = 0;
                while (i < certChain.length) {
                    result[i] = (X509Certificate)certChain[i];
                    ++i;
                }
                return result;
            }
            return null;
        }
        catch (KeyStoreException keyStoreException) {
            return null;
        }
    }

    public PrivateKey getPrivateKey(String keyAlias) {
        if (keyAlias == null) {
            return null;
        }
        try {
            Key result = this.keyStore.getKey(keyAlias, this.keyStorePassword);
            if (result instanceof PrivateKey) {
                return (PrivateKey)result;
            }
            return null;
        }
        catch (KeyStoreException keyStoreException) {
            return null;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            return null;
        }
    }
}

