/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.jsse;

import com.ibm.oti.net.www.protocol.http.AuthCredential;
import com.ibm.oti.net.www.protocol.http.BasicRequestHeader;
import com.ibm.oti.net.www.protocol.http.ConnectionInfo;
import com.ibm.oti.net.www.protocol.http.DigestRequestHeader;
import com.ibm.oti.net.www.protocol.http.Header;
import com.ibm.oti.net.www.protocol.https.HttpsURLConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SSLProxySocketFactory
extends SSLSocketFactory {
    private String proxyHost;
    private int proxyPort;
    private SSLSocketFactory sslSocketFactory;
    private String agent;

    public SSLProxySocketFactory(String proxyHost, int proxyPort, SSLSocketFactory sslSocketFactory, String agent) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.sslSocketFactory = sslSocketFactory;
        this.agent = agent;
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.createSocket(null, host, port, true);
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        return this.createSocket(null, host, port, true);
    }

    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.createSocket(null, host.getHostName(), port, true);
    }

    public Socket createSocket(InetAddress address, int port, InetAddress clientAddress, int clientPort) throws IOException {
        return this.createSocket(null, address.getHostName(), port, true);
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        Socket tunnel = socket == null ? new Socket(this.proxyHost, this.proxyPort) : socket;
        tunnel = this.proxyHandshake(tunnel, host, port);
        SSLSocket sslSocket = (SSLSocket)this.sslSocketFactory.createSocket(tunnel, host, port, autoClose);
        return sslSocket;
    }

    private Socket proxyHandshake(Socket tunnel, String host, int port) throws IOException {
        byte[] buffer;
        OutputStream out = tunnel.getOutputStream();
        String message = "CONNECT " + host + ":" + port + " HTTP/1.0\rUser-Agent: " + this.agent + "\r\n";
        try {
            buffer = (String.valueOf(message) + "\r\n").getBytes("ASCII7");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            buffer = (String.valueOf(message) + "\r\n").getBytes();
        }
        out.write(buffer);
        out.flush();
        InputStream in = tunnel.getInputStream();
        String result = this.readln(in);
        int responseCode = this.getResponseCode(result);
        switch (responseCode) {
            case 200: {
                result = this.readln(in);
                while (result.length() > 0) {
                    result = this.readln(in);
                }
                return tunnel;
            }
            case 407: {
                ConnectionInfo connectionInfo = new ConnectionInfo(this.proxyHost, this.proxyPort, "http", "CONNECT", String.valueOf(host) + ":" + port);
                Header header = this.readHeaders(in);
                String challenge = header.get("Proxy-Authenticate");
                int type = 2;
                if (challenge == null) {
                    return tunnel;
                }
                int idx = challenge.indexOf(32);
                String scheme = challenge.substring(0, idx);
                while (true) {
                    AuthCredential credential;
                    if (scheme.equals("Digest")) {
                        credential = this.getCredential((AuthCredential)new DigestRequestHeader(type, challenge, connectionInfo));
                    } else if (scheme.equals("Basic")) {
                        credential = this.getCredential((AuthCredential)new BasicRequestHeader(type, challenge, connectionInfo));
                    } else {
                        return tunnel;
                    }
                    if (credential == null) {
                        return tunnel;
                    }
                    String newMessage = String.valueOf(message) + "Host: " + host + "\r\n" + credential.getDirective() + ": " + credential.getAuthorizationResponse() + "\r\n";
                    try {
                        buffer = (String.valueOf(newMessage) + "\r\n").getBytes("ASCII7");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        buffer = (String.valueOf(newMessage) + "\r\n").getBytes();
                    }
                    tunnel.close();
                    Socket newTunnel = new Socket(this.proxyHost, this.proxyPort);
                    out = newTunnel.getOutputStream();
                    in = newTunnel.getInputStream();
                    out.write(buffer);
                    out.flush();
                    result = this.readln(in);
                    responseCode = this.getResponseCode(result);
                    if (responseCode == 200) {
                        HttpsURLConnection.authenticationCache.put(credential);
                        result = this.readln(in);
                        while (result.length() > 0) {
                            result = this.readln(in);
                        }
                        return newTunnel;
                    }
                    newTunnel.close();
                }
            }
        }
        throw new IOException("Proxy Error: " + result);
    }

    public String[] getDefaultCipherSuites() {
        return ((SSLSocketFactory)SSLProxySocketFactory.getDefault()).getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return ((SSLSocketFactory)SSLProxySocketFactory.getDefault()).getSupportedCipherSuites();
    }

    private int getResponseCode(String response) {
        int responseCode = -1;
        if (response == null || !response.startsWith("HTTP/")) {
            return -1;
        }
        response.trim();
        int mark = response.indexOf(" ") + 1;
        if (mark == 0) {
            return -1;
        }
        int last = mark + 3;
        if (last > response.length()) {
            last = response.length();
        }
        responseCode = Integer.parseInt(response.substring(mark, last));
        return responseCode;
    }

    /*
     * Unable to fully structure code
     */
    String readln(InputStream is) throws IOException {
        lastCr = false;
        result = new StringBuffer(80);
        c = is.read();
        if (c >= 0) ** GOTO lbl17
        return null;
lbl-1000:
        // 1 sources

        {
            if (lastCr) {
                result.append('\r');
                lastCr = false;
            }
            if (c == 13) {
                lastCr = true;
            } else {
                result.append((char)c);
            }
            c = is.read();
            if (c < 0) break;
lbl17:
            // 2 sources

            ** while (c != 10)
        }
lbl18:
        // 2 sources

        return result.toString();
    }

    Header readHeaders(InputStream is) throws IOException {
        String line;
        Header resHeader = new Header();
        while ((line = this.readln(is)) != null && line.length() > 1) {
            int idx = line.indexOf(":");
            if (idx < 0) {
                resHeader.add("", line.trim());
                continue;
            }
            resHeader.add(line.substring(0, idx), line.substring(idx + 1).trim());
        }
        return resHeader;
    }

    public Socket createSocket(String host, int port, int timeout) throws IOException {
        Socket tunnel = new Socket();
        tunnel.connect(new InetSocketAddress(this.proxyHost, this.proxyPort), timeout);
        return this.createSocket(tunnel, host, port, true);
    }

    private AuthCredential getCredential(AuthCredential localCredential) throws IOException {
        AuthCredential cachedCredential = HttpsURLConnection.authenticationCache.get(localCredential);
        if (cachedCredential != null) {
            return cachedCredential;
        }
        return localCredential;
    }
}

