/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.jsse;

import com.ibm.j9.jsse.SSLSocketImpl;
import com.ibm.j9.jsse.support.Msg;
import com.ibm.j9.ssl.CipherSpec;
import com.ibm.j9.ssl.J9SSLContext;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLServerSocket;

public class SSLServerSocketImpl
extends SSLServerSocket {
    J9SSLContext context;
    private String[] enabledCipherSuites = new String[0];
    private String[] enabledProtocols;
    private boolean needClientAuth;
    private boolean useClientMode;
    private boolean wantClientAuth;

    protected SSLServerSocketImpl() throws IOException {
    }

    public SSLServerSocketImpl(int localPort, J9SSLContext context, String[] defaultCipherSuites) throws IOException {
        super(localPort);
        this.context = context;
        this.setEnabledCipherSuites(defaultCipherSuites);
    }

    public SSLServerSocketImpl(int localPort, J9SSLContext context, String[] defaultCipherSuites, int connectionBackLog) throws IOException {
        super(localPort, connectionBackLog);
        this.context = context;
        this.setEnabledCipherSuites(defaultCipherSuites);
    }

    public SSLServerSocketImpl(int localPort, J9SSLContext context, String[] defaultCipherSuites, int connectionBackLog, InetAddress localAddress) throws IOException {
        super(localPort, connectionBackLog, localAddress);
        this.context = context;
        this.setEnabledCipherSuites(defaultCipherSuites);
    }

    public SSLServerSocketImpl(J9SSLContext context, String[] defaultCipherSuites) throws IOException {
        this.context = context;
        this.setEnabledCipherSuites(defaultCipherSuites);
    }

    public boolean getEnableSessionCreation() {
        return this.context.getSessionCreationEnabled();
    }

    public String[] getEnabledCipherSuites() {
        return (String[])this.enabledCipherSuites.clone();
    }

    public String[] getEnabledProtocols() {
        if (this.enabledProtocols == null) {
            this.enabledProtocols = this.getSupportedProtocols();
        }
        return (String[])this.enabledProtocols.clone();
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public String[] getSupportedCipherSuites() {
        return (String[])CipherSpec.SUPPORTED_SPEC_IDS.clone();
    }

    public String[] getSupportedProtocols() {
        return new String[]{"SSLv3", "TLSv1"};
    }

    public boolean getUseClientMode() {
        return this.useClientMode;
    }

    public boolean getWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setEnableSessionCreation(boolean enableSessionCreation) {
        this.context.setEnableSessionCreation(enableSessionCreation);
    }

    public void setEnabledCipherSuites(String[] enabledCipherSuites) {
        if (enabledCipherSuites == null) {
            throw new IllegalArgumentException(Msg.getString("K03ad"));
        }
        int i = 0;
        while (i < enabledCipherSuites.length) {
            if (!this.isCipherSuiteSupported(enabledCipherSuites[i])) {
                throw new IllegalArgumentException(Msg.getString("K01e6", enabledCipherSuites[i]));
            }
            ++i;
        }
        this.enabledCipherSuites = enabledCipherSuites;
    }

    public void setEnabledProtocols(String[] enabledProtocols) {
        if (enabledProtocols == null) {
            throw new IllegalArgumentException(Msg.getString("K03bd"));
        }
        int i = 0;
        while (i < enabledProtocols.length) {
            if (!this.isProtocolSupported(enabledProtocols[i])) {
                throw new IllegalArgumentException(Msg.getString("K00b3", enabledProtocols[i]));
            }
            ++i;
        }
        this.enabledProtocols = enabledProtocols;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
        if (needClientAuth) {
            this.wantClientAuth = needClientAuth;
        }
    }

    public void setUseClientMode(boolean useClientMode) {
        this.useClientMode = useClientMode;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    private boolean isCipherSuiteSupported(String cipherSuite) {
        if (cipherSuite == null) {
            throw new IllegalArgumentException(Msg.getString("K03ad"));
        }
        int i = 0;
        while (i < this.getSupportedCipherSuites().length) {
            if (this.getSupportedCipherSuites()[i].equals(cipherSuite)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isProtocolSupported(String protocol) {
        int i = 0;
        while (i < this.getSupportedProtocols().length) {
            if (this.getSupportedProtocols()[i].equals(protocol)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Socket accept() throws IOException {
        Socket baseSocket = super.accept();
        return new SSLSocketImpl(baseSocket, this);
    }
}

