/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.security.cert.Certificate;
import java.util.EventObject;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.cert.X509Certificate;

public class HandshakeCompletedEvent
extends EventObject {
    private transient SSLSession session;
    private transient SSLSocket socket;

    public HandshakeCompletedEvent(SSLSocket socket, SSLSession session) {
        super(socket);
        this.session = session;
        this.socket = socket;
    }

    public SSLSession getSession() {
        return this.session;
    }

    public String getCipherSuite() {
        return this.session.getCipherSuite();
    }

    public Certificate[] getLocalCertificates() {
        return this.session.getLocalCertificates();
    }

    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        return this.session.getPeerCertificates();
    }

    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        return this.session.getPeerCertificateChain();
    }

    public SSLSocket getSocket() {
        return this.socket;
    }
}

