/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import com.ibm.j9.jsse.support.Msg;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;

public class KeyManagerFactory {
    private final KeyManagerFactorySpi implementation;
    private final Provider provider;
    private final String factoryAlgorithm;
    private static final String KEYMANAGERFACTORY_PREFIX = "KeyManagerFactory.";
    private static final String KEYMANAGERFACTORY_DEFAULT_ALGORITHM_NAME = "IBMJ9X509";
    private static final String configuredDefaultAlgorithmName = (String)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return System.getProperty("ssl.KeyManagerFactory.algorithm", KeyManagerFactory.KEYMANAGERFACTORY_DEFAULT_ALGORITHM_NAME);
        }
    });

    protected KeyManagerFactory(KeyManagerFactorySpi implementation, Provider factoryProvider, String factoryAlgorithm) {
        this.implementation = implementation;
        this.provider = factoryProvider;
        this.factoryAlgorithm = factoryAlgorithm;
    }

    public static final String getDefaultAlgorithm() {
        return configuredDefaultAlgorithmName;
    }

    public final String getAlgorithm() {
        return this.factoryAlgorithm;
    }

    public static final KeyManagerFactory getInstance(String factoryAlgorithm) throws NoSuchAlgorithmException {
        Provider[] providers;
        if (factoryAlgorithm == null) {
            throw new NoSuchAlgorithmException(Msg.getString("K03bd"));
        }
        try {
            providers = Security.getProviders(KEYMANAGERFACTORY_PREFIX + factoryAlgorithm);
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new NoSuchAlgorithmException(Msg.getString("K03b5", factoryAlgorithm));
        }
        if (providers == null) {
            throw new NoSuchAlgorithmException(Msg.getString("K03b5", factoryAlgorithm));
        }
        return KeyManagerFactory.getInstance(factoryAlgorithm, providers[0]);
    }

    public static final KeyManagerFactory getInstance(String factoryAlgorithm, String factoryProvider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (factoryProvider == null || factoryProvider.length() == 0) {
            throw new IllegalArgumentException(Msg.getString("K03b6"));
        }
        Provider p = Security.getProvider(factoryProvider);
        if (p == null) {
            throw new NoSuchProviderException(Msg.getString("K03b7", factoryProvider));
        }
        return KeyManagerFactory.getInstance(factoryAlgorithm, p);
    }

    public static final KeyManagerFactory getInstance(String factoryAlgorithm, Provider factoryProvider) throws NoSuchAlgorithmException {
        if (factoryProvider == null) {
            throw new IllegalArgumentException(Msg.getString("K03b3"));
        }
        if (factoryAlgorithm == null) {
            throw new NoSuchAlgorithmException(Msg.getString("K03c4"));
        }
        String className = factoryProvider.getProperty(KEYMANAGERFACTORY_PREFIX + factoryAlgorithm);
        if (className == null) {
            throw new NoSuchAlgorithmException(Msg.getString("K03b5", factoryAlgorithm));
        }
        Class<?> generatorClass = null;
        try {
            generatorClass = Class.forName(className, true, factoryProvider.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new NoSuchAlgorithmException(e.getMessage());
        }
        KeyManagerFactorySpi implementationClass = null;
        try {
            implementationClass = (KeyManagerFactorySpi)generatorClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new NoSuchAlgorithmException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new NoSuchAlgorithmException(e.getMessage());
        }
        return new KeyManagerFactory(implementationClass, factoryProvider, factoryAlgorithm);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(KeyStore keyStore, char[] keyStorePassword) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        this.implementation.engineInit(keyStore, keyStorePassword);
    }

    public final void init(ManagerFactoryParameters factoryParams) throws InvalidAlgorithmParameterException {
        this.implementation.engineInit(factoryParams);
    }

    public final KeyManager[] getKeyManagers() {
        return this.implementation.engineGetKeyManagers();
    }
}

