/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.io.IOException;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.net.SocketFactory;

public abstract class SSLSocketFactory
extends SocketFactory {
    public static SocketFactory getDefault() {
        SocketFactory sf = (SocketFactory)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String defaultFactoryClass = System.getProperty("ssl.SocketFactory.provider");
                if (defaultFactoryClass != null) {
                    try {
                        Class<?> factoryClass = Class.forName(defaultFactoryClass, true, ClassLoader.getSystemClassLoader());
                        SocketFactory sf = (SocketFactory)factoryClass.newInstance();
                        return sf;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        return null;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        return null;
                    }
                    catch (InstantiationException instantiationException) {
                        return null;
                    }
                }
                return null;
            }
        });
        if (sf != null) {
            return sf;
        }
        return new com.ibm.j9.jsse.SSLSocketFactory();
    }

    public abstract String[] getDefaultCipherSuites();

    public abstract String[] getSupportedCipherSuites();

    public abstract Socket createSocket(Socket var1, String var2, int var3, boolean var4) throws IOException;
}

