/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.cabinet;

import java.util.Map;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoHasChildrenException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.commonmo.metadata.MoMetaData;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.genericmo.MaoFactory;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.crbs.supsys.supportsystemconfiguration.helper.CabinetHelper;
import se.ericsson.crbs.supsys.supportsystemconfiguration.helper.CabinetParametersHelper;
import se.ericsson.crbs.supsys.supportsystemconfiguration.helper.EquipmentSupportFunctionHelper;

public class CabinetMaoImpl
extends GenericMao {
    private static final String moType = "Cabinet";
    public static final String ATTRIBUTE_CABINET_PARAMETERS = "cabinetParameters";
    public static final String ATTRIBUTE_CABINET_PARAMETERS_PROFILE_STANDARD = "cabinetParametersProfileStandard";
    public static final String ATTRIBUTE_CABINET_PARAMETERS_PROFILE_EXTENDED = "cabinetParametersProfileExtended";
    public static final String ATTRIBUTE_CLIMATE_REGULATION_SYSTEM = "climateRegulationSystem";
    public static final int NA_CLIMATE_REGULATION = 0;
    public static final int DAC_CLIMATE_REGULATION = 1;
    public static final int TS_CLIMATE_REGULATION = 2;
    public static final int HEX_CLIMATE_REGULATION = 3;
    public static final String ATTRIBUTE_CLIMATE_SYSTEM = "climateSystem";
    public static final String ATTRIBUTE_PRODUCT_DATA = "productData";
    public static final String ATTRIBUTE_PRODUCTION_DATE = "productionDate";
    public static final String ATTRIBUTE_PRODUCT_NAME = "productName";
    public static final String ATTRIBUTE_PRODUCT_NUMBER = "productNumber";
    public static final String ATTRIBUTE_PRODUCT_REVISION = "productRevision";
    public static final String ATTRIBUTE_SERIAL_NUMBER = "serialNumber";
    public static final int CLIMATE_PRODUCT_NAME_MAX_LENGTH = 12;
    public static final int STANDARD_CLIMATE_SYSTEM = 0;
    public static final int EXTENDED_CLIMATE_SYSTEM = 1;
    protected static final String ATTRIBUTE_SUPPORT_SYSTEM_CONTROL = "supportSystemControl";
    protected static final String ATTRIBUTE_CLIMATE_CONTROL_MODE = "climateControlMode";
    private static final int TRANSACTION_TIMEOUT = 120;
    private static final Class THIS_CLASS = CabinetMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected static final String MO_TYPE = "Cabinet";
    public static final String XML_FILE_NAME = "RbsCabinetParametersLm.xml";
    private boolean validateInPreSet = true;

    public CabinetMaoImpl(ManagedObject managedObject, AttrList attrList, String string, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, attrList, string, "Cabinet", genericMaoContext, n, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "Constructor used at create");
        logger.traceReturn(THIS_CLASS, "Constructor used at create");
    }

    public CabinetMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "Constructor used at restore");
        logger.traceReturn(THIS_CLASS, "Constructor used at restore");
    }

    public void parameterChanged(String string, Object object) {
        super.parameterChanged(string, object);
        logger.traceEnter(THIS_CLASS, "parameterChanged()");
        logger.traceGeneral(THIS_CLASS, "Changed parameter: " + string);
        if (ATTRIBUTE_CLIMATE_SYSTEM.equals(string)) {
            this.parameterChangedClimateSystem((Integer)object);
        } else if (ATTRIBUTE_PRODUCT_DATA.equals(string)) {
            this.parameterChangedProductData();
        } else if (ATTRIBUTE_CLIMATE_REGULATION_SYSTEM.equals(string)) {
            this.parameterChangedClimateRegulationSystem((Integer)object);
        }
        logger.traceReturn(THIS_CLASS, "parameterChanged()");
    }

    private void parameterChangedProductData() {
        logger.traceEnter(THIS_CLASS, "parameterChangedProductData()");
        try {
            Control control = this.genericMaoContext.getTransactionServicesFactory().getCppTransactionFactory().create(120);
            try {
                this.updateCabinetParametersProfilesAndCabinetParameters(control.getCoordinator());
                control.getTerminator().commit();
            }
            catch (MoAccessException moAccessException) {
                control.getTerminator().rollback();
                logger.traceError(THIS_CLASS, "Unable to update CabinetParameters according to changed ProductData attribute, exception caught: " + ExceptionHelper.getExceptionMessage((Throwable)moAccessException));
            }
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            logger.traceError(THIS_CLASS, "Unable to update CabinetParameters according to changed ProductData attribute. TransactionRolledBack exception: " + ExceptionHelper.getExceptionMessage((Throwable)transactionRolledBackException));
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            logger.traceError(THIS_CLASS, "Unable to update CabinetParameters according to changed ProductData attribute. TransactionRolledBack exception: " + ExceptionHelper.getExceptionMessage((Throwable)inactiveTransactionException));
        }
        logger.traceReturn(THIS_CLASS, "parameterChangedProductData()");
    }

    private void parameterChangedClimateSystem(Integer n) {
        logger.traceEnter(THIS_CLASS, "parameterChangedClimateSystem()");
        try {
            Control control = this.genericMaoContext.getTransactionServicesFactory().getCppTransactionFactory().create(120);
            try {
                Integer n2 = (Integer)this.getAttribute(ATTRIBUTE_CLIMATE_SYSTEM, control.getCoordinator());
                if (n.equals(n2)) {
                    logger.traceGeneral(THIS_CLASS, "No change in attribute value of climateSystem: " + n);
                } else {
                    logger.traceGeneral(THIS_CLASS, "Change in attribute value of climateSystem from: " + n2 + " to: " + n);
                    this.setAttributeWithoutValidationInPreSet(ATTRIBUTE_CLIMATE_SYSTEM, n, control.getCoordinator());
                }
                control.getTerminator().commit();
            }
            catch (MoAccessException moAccessException) {
                control.getTerminator().rollback();
                logger.traceError(THIS_CLASS, "Unable to update CabinetParameters according to changed ClimateSystem attribute, exception caught: " + ExceptionHelper.getExceptionMessage((Throwable)moAccessException));
            }
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            logger.traceError(THIS_CLASS, "Unable to update CabinetParameters according to changed ClimateSystem attribute. TransactionRolledBack exception: " + ExceptionHelper.getExceptionMessage((Throwable)transactionRolledBackException));
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            logger.traceError(THIS_CLASS, "Unable to update CabinetParameters according to changed ClimateSystem attribute. TransactionRolledBack exception: " + ExceptionHelper.getExceptionMessage((Throwable)inactiveTransactionException));
        }
        logger.traceReturn(THIS_CLASS, "parameterChangedClimateSystem()");
    }

    private void parameterChangedClimateRegulationSystem(Integer n) {
        logger.traceEnter(THIS_CLASS, "parameterChangedClimateRegulationSystem()");
        try {
            Control control = this.genericMaoContext.getTransactionServicesFactory().getCppTransactionFactory().create(120);
            try {
                Integer n2 = (Integer)this.getAttribute(ATTRIBUTE_CLIMATE_REGULATION_SYSTEM, control.getCoordinator());
                if (n.equals(n2)) {
                    logger.traceGeneral(THIS_CLASS, "No change in attribute value of climateRegulationSystem: " + n);
                } else {
                    logger.traceGeneral(THIS_CLASS, "Change in attribute value of climateRegulationSystem from: " + n2 + " to: " + n);
                    this.setAttributeWithoutValidationInPreSet(ATTRIBUTE_CLIMATE_REGULATION_SYSTEM, n, control.getCoordinator());
                }
                control.getTerminator().commit();
            }
            catch (MoAccessException moAccessException) {
                control.getTerminator().rollback();
                logger.traceError(THIS_CLASS, "Unable to update CabinetParameters according to changed ClimateRegulationSystem attribute, exception caught: " + ExceptionHelper.getExceptionMessage((Throwable)moAccessException));
            }
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            logger.traceError(THIS_CLASS, "Unable to update CabinetParameters according to changed ClimateRegulationSystem attribute. TransactionRolledBack exception: " + ExceptionHelper.getExceptionMessage((Throwable)transactionRolledBackException));
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            logger.traceError(THIS_CLASS, "Unable to update CabinetParameters according to changed ClimateRegulationSystem attribute. TransactionRolledBack exception: " + ExceptionHelper.getExceptionMessage((Throwable)inactiveTransactionException));
        }
        logger.traceReturn(THIS_CLASS, "parameterChangedClimateRegulationSystem()");
    }

    public void postCreate(AttrList attrList, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(((Object)((Object)this)).getClass(), "postCreate()");
        super.postCreate(attrList, coordinator);
        int n = 0;
        int n2 = attrList.indexOf(ATTRIBUTE_CLIMATE_SYSTEM);
        if (n2 >= 0) {
            n = (Integer)attrList.getValue(n2);
        }
        this.updateCabinetParametersProfilesAndCabinetParameters(n, coordinator);
        logger.traceReturn(((Object)((Object)this)).getClass(), "postCreate()");
    }

    public Object preSet(String string, Map map, Object object, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "preSet() -- parameter: " + string);
        if (string.equalsIgnoreCase(ATTRIBUTE_CLIMATE_SYSTEM)) {
            this.preSetClimateSystem(coordinator);
        } else if (string.equalsIgnoreCase(ATTRIBUTE_CLIMATE_CONTROL_MODE)) {
            this.preSetClimateControlMode(coordinator);
        } else if (string.equalsIgnoreCase(ATTRIBUTE_PRODUCT_DATA)) {
            this.preSetProductData((Struct)object, coordinator);
        } else if (string.equalsIgnoreCase(ATTRIBUTE_CLIMATE_REGULATION_SYSTEM)) {
            this.preSetClimateRegulationSystem(coordinator);
        }
        logger.traceReturn(THIS_CLASS, "preSet()");
        return object;
    }

    private void setAttributeWithoutValidationInPreSet(String string, Object object, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setAttributeWithoutValidationInPreSet() -- attrName: " + string);
        this.validateInPreSet = false;
        this.setAttribute(string, object, coordinator);
        this.validateInPreSet = true;
        logger.traceReturn(THIS_CLASS, "setAttributeWithoutValidationInPreSet()");
    }

    public void postSet(String string, Object object, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "postSet() -- parameter: " + string);
        if (string.equalsIgnoreCase(ATTRIBUTE_CABINET_PARAMETERS)) {
            this.postSetCabinetParameters(object, coordinator);
        } else if (string.equalsIgnoreCase(ATTRIBUTE_CLIMATE_SYSTEM)) {
            this.postSetClimateSystem((Integer)object, coordinator);
        } else if (string.equalsIgnoreCase(ATTRIBUTE_CLIMATE_CONTROL_MODE)) {
            this.postSetClimateControlMode((Integer)object, coordinator);
        } else if (string.equalsIgnoreCase(ATTRIBUTE_PRODUCT_DATA)) {
            this.postSetProductData(coordinator);
        } else if (string.equalsIgnoreCase(ATTRIBUTE_CLIMATE_REGULATION_SYSTEM)) {
            this.postSetClimateRegulationSystem((Integer)object, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "postSet()");
    }

    public void delete(Coordinator coordinator) throws MoAccessException, ProcessingFailureException {
        int n = this.getChildren().size();
        this.deleteFanGroups(0, n, coordinator);
        super.delete(coordinator);
    }

    private void deleteFanGroups(int n, int n2, Coordinator coordinator) throws MoHasChildrenException, MoAccessException {
        logger.traceEnter(((Object)((Object)this)).getClass(), "deleteFanGroups() - Wanted noOfGroups: " + n);
        block0: for (int i = n2; i > n; --i) {
            MoIterator moIterator = this.getChildren();
            while (moIterator.hasMoreElements()) {
                ManagedObject managedObject = moIterator.nextMo();
                if (!new String("FanGroup=" + i).equalsIgnoreCase(managedObject.getRelativeDistinguishedName())) continue;
                managedObject.delete(coordinator);
                continue block0;
            }
        }
        if (n != this.getChildren().size()) {
            while (this.getChildren().size() > n) {
                this.getChildren().nextMo().delete(coordinator);
            }
        }
        logger.traceReturn(THIS_CLASS, "deleteFanGroups()");
    }

    private void createFanGroups(int n, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(((Object)((Object)this)).getClass(), "createFanGroups() - Wanted noOfGroups: " + n);
        MoMetaData moMetaData = this.genericMaoContext.getMoMetaDataFinder().getMoData("FanGroup");
        MaoFactory maoFactory = this.genericMaoContext.getMaoFactoryFactory().getMoFactory(moMetaData);
        AttrListImpl attrListImpl = new AttrListImpl(this.genericMaoContext.getMoRepositoryWrapper());
        int n2 = 1;
        while (this.getChildren().size() < n) {
            ManagedObject managedObject = this.genericMaoContext.getMoRepositoryWrapper().lookup(this.getLocalDistinguishedName() + ",FanGroup=" + n2);
            if (managedObject == null) {
                maoFactory.createMo((ManagedObject)this, (AttrList)attrListImpl, Integer.toString(n2), null, coordinator);
            }
            ++n2;
        }
        logger.traceReturn(THIS_CLASS, "createFanGroups()");
    }

    private void preSetClimateSystem(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "preSetClimateSystem()");
        if (this.validateInPreSet) {
            logger.traceGeneral(THIS_CLASS, "Attribute will be validated");
            if (!EquipmentSupportFunctionHelper.isSupportSystemControl(this.genericMaoContext, coordinator)) {
                throw new ValueOutOfRangeException(ATTRIBUTE_CLIMATE_SYSTEM, "Cabinet", "Attribute climateSystem cannot be set in a Secondary Node.");
            }
        } else {
            logger.traceGeneral(THIS_CLASS, "Attribute validation skipped.");
        }
        logger.traceReturn(THIS_CLASS, "preSetClimateSystem()");
    }

    private void preSetClimateControlMode(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "preSetClimateControlMode()");
        if (this.validateInPreSet) {
            logger.traceGeneral(THIS_CLASS, "Attribute will be validated");
            if (!EquipmentSupportFunctionHelper.isSupportSystemControl(this.genericMaoContext, coordinator)) {
                throw new ValueOutOfRangeException(ATTRIBUTE_CLIMATE_CONTROL_MODE, "Cabinet", "Attribute climateControlMode cannot be set in a Secondary Node.");
            }
        } else {
            logger.traceGeneral(THIS_CLASS, "Attribute validation skipped.");
        }
        logger.traceReturn(THIS_CLASS, "preSetClimateControlMode()");
    }

    private void preSetProductData(Struct struct, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "preSetProductData() -- productData: " + struct);
        String string = (String)struct.getValue(ATTRIBUTE_PRODUCT_NAME);
        if (this.validateInPreSet) {
            logger.traceGeneral(THIS_CLASS, "Attribute will be validated");
            if (!EquipmentSupportFunctionHelper.isSupportSystemControl(this.genericMaoContext, coordinator)) {
                throw new ValueOutOfRangeException(ATTRIBUTE_PRODUCT_DATA, "Cabinet", "Attribute productData cannot be set in a Secondary Node.");
            }
            if (string.trim().equals("")) {
                throw new ValueOutOfRangeException(ATTRIBUTE_PRODUCT_DATA, "Cabinet", "Attribute productData cannot contain an empty productName.");
            }
            if (string.trim().length() > 12) {
                String string2 = "Length of attribute productName from MO Cabinet is limited to " + Integer.toString(12) + " characters.";
                throw new ValueOutOfRangeException(ATTRIBUTE_PRODUCT_DATA, "Cabinet", string2);
            }
            if (!CabinetParametersHelper.isValidProductName(string, this.genericMaoContext)) {
                String string3 = "The productName [" + string + "] in attribute productData is not supported.";
                throw new ValueOutOfRangeException(ATTRIBUTE_PRODUCT_DATA, "Cabinet", string3);
            }
        } else {
            logger.traceGeneral(THIS_CLASS, "Attribute validation skipped.");
        }
        logger.traceReturn(THIS_CLASS, "preSetProductData()");
    }

    private void preSetClimateRegulationSystem(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "preSetClimateRegulationSystem()");
        if (this.validateInPreSet) {
            logger.traceGeneral(THIS_CLASS, "Attribute will be validated");
            if (!EquipmentSupportFunctionHelper.isSupportSystemControl(this.genericMaoContext, coordinator)) {
                throw new ValueOutOfRangeException(ATTRIBUTE_CLIMATE_REGULATION_SYSTEM, "Attribute climateRegulationSystem cannot be set in a Secondary Node.");
            }
        } else {
            logger.traceGeneral(THIS_CLASS, "Attribute validation skipped.");
        }
        logger.traceReturn(THIS_CLASS, "preSetClimateRegulationSystem()");
    }

    private void postSetCabinetParameters(Object object, Coordinator coordinator) throws MoAccessException, MoHasChildrenException {
        logger.traceEnter(((Object)((Object)this)).getClass(), "postSetCabinetParameters()");
        if (EquipmentSupportFunctionHelper.isSupportSystemControl(this.genericMaoContext, coordinator)) {
            int n;
            int n2 = object instanceof Integer[] ? ((Integer[])object)[1] : ((int[])object)[1];
            if (n2 > (n = this.getChildren().size())) {
                this.createFanGroups(n2, coordinator);
            } else if (n2 < n) {
                this.deleteFanGroups(n2, n, coordinator);
            }
        }
        logger.traceReturn(THIS_CLASS, "postSetCabinetParameters()");
    }

    private void postSetClimateSystem(Integer n, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "postSetClimateSystem()");
        this.updateCabinetParameters(n, coordinator);
        logger.traceReturn(THIS_CLASS, "postSetClimateSystem()");
    }

    private void postSetClimateControlMode(Integer n, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "postSetClimateControlMode()");
        this.mirrorClimateControlModeToClimate(n, coordinator);
        logger.traceReturn(THIS_CLASS, "postSetClimateControlMode()");
    }

    private void postSetProductData(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "postSetProductData()");
        this.updateCabinetParametersProfilesAndCabinetParameters(coordinator);
        logger.traceReturn(THIS_CLASS, "postSetProductData()");
    }

    private void postSetClimateRegulationSystem(Integer n, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(((Object)((Object)this)).getClass(), "postSetClimateRegulationSystem()");
        this.updateCabinetParametersProfilesAndCabinetParameters(n, coordinator);
        logger.traceReturn(THIS_CLASS, "postSetClimateRegulationSystem()");
    }

    private void mirrorClimateControlModeToClimate(Integer n, Coordinator coordinator) throws MoAccessException {
        Integer n2;
        CabinetHelper cabinetHelper = new CabinetHelper(this.genericMaoContext);
        ManagedObject managedObject = cabinetHelper.getClimateForCabinet((ManagedObject)this, coordinator);
        if (managedObject != null && !(n2 = (Integer)managedObject.getAttribute(ATTRIBUTE_CLIMATE_CONTROL_MODE, coordinator)).equals(n)) {
            managedObject.setAttribute(ATTRIBUTE_CLIMATE_CONTROL_MODE, (Object)n, coordinator);
        }
    }

    private void updateCabinetParametersProfilesAndCabinetParameters(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(((Object)((Object)this)).getClass(), "updateCabinetParametersAndCabinetParametersProfiles()");
        String string = this.getProductNameForCabinetParametersSelection(coordinator);
        int n = this.getClimateSystem(coordinator);
        String string2 = this.getClimateRegulationSystem(coordinator);
        this.updateCabinetParametersProfilesAndCabinetParameters(n, string2, string, coordinator);
        logger.traceReturn(THIS_CLASS, "updateCabinetParametersAndCabinetParametersProfiles()");
    }

    private void updateCabinetParametersProfilesAndCabinetParameters(int n, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(((Object)((Object)this)).getClass(), "updateCabinetParametersAndCabinetParametersProfiles()");
        String string = this.getProductNameForCabinetParametersSelection(coordinator);
        String string2 = this.getClimateRegulationSystem(coordinator);
        this.updateCabinetParametersProfilesAndCabinetParameters(n, string2, string, coordinator);
        logger.traceReturn(THIS_CLASS, "updateCabinetParametersAndCabinetParametersProfiles()");
    }

    private void updateCabinetParametersProfilesAndCabinetParameters(String string, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(((Object)((Object)this)).getClass(), "updateCabinetParametersAndCabinetParametersProfiles()");
        int n = this.getClimateSystem(coordinator);
        String string2 = this.getClimateRegulationSystem(coordinator);
        this.updateCabinetParametersProfilesAndCabinetParameters(n, string2, string, coordinator);
        logger.traceReturn(THIS_CLASS, "updateCabinetParametersAndCabinetParametersProfiles()");
    }

    private void updateCabinetParametersProfilesAndCabinetParameters(Integer n, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(((Object)((Object)this)).getClass(), "updateCabinetParametersAndCabinetParametersProfiles()");
        int n2 = this.getClimateSystem(coordinator);
        String string = this.getProductNameForCabinetParametersSelection(coordinator);
        String string2 = n.toString();
        this.updateCabinetParametersProfilesAndCabinetParameters(n2, string2, string, coordinator);
        logger.traceReturn(THIS_CLASS, "updateCabinetParametersAndCabinetParametersProfiles()");
    }

    private void updateCabinetParametersProfilesAndCabinetParameters(int n, String string, String string2, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(((Object)((Object)this)).getClass(), "updateCabinetParametersAndCabinetParametersProfiles()");
        this.updateCabinetParametersProfiles(string2, string, coordinator);
        this.updateCabinetParameters(n, coordinator);
        logger.traceReturn(THIS_CLASS, "updateCabinetParametersAndCabinetParametersProfiles()");
    }

    private void updateCabinetParameters(int n, Coordinator coordinator) throws MoAccessException {
        Integer[] integerArray;
        logger.traceEnter(((Object)((Object)this)).getClass(), "updateCabinetParameters()");
        if (n == 1) {
            logger.traceGeneral(THIS_CLASS, "Selecting cabinetParameters from cabinetParametersProfileExtended.");
            integerArray = (Integer[])this.getAttribute(ATTRIBUTE_CABINET_PARAMETERS_PROFILE_EXTENDED, coordinator);
        } else {
            logger.traceGeneral(THIS_CLASS, "Selecting cabinetParameters from cabinetParametersProfileStandard.");
            integerArray = (Integer[])this.getAttribute(ATTRIBUTE_CABINET_PARAMETERS_PROFILE_STANDARD, coordinator);
        }
        this.setAttribute(ATTRIBUTE_CABINET_PARAMETERS, integerArray, coordinator);
        logger.traceReturn(THIS_CLASS, "updateCabinetParameters()");
    }

    private void updateCabinetParametersProfiles(String string, String string2, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(((Object)((Object)this)).getClass(), "updateCabinetParametersProfiles()");
        Integer[] integerArray = CabinetParametersHelper.getCabinetParametersProfileStandard(string, string2, this.genericMaoContext, coordinator);
        Integer[] integerArray2 = CabinetParametersHelper.getCabinetParametersProfileExtended(string, string2, this.genericMaoContext, coordinator);
        this.setAttribute(ATTRIBUTE_CABINET_PARAMETERS_PROFILE_STANDARD, integerArray, coordinator);
        this.setAttribute(ATTRIBUTE_CABINET_PARAMETERS_PROFILE_EXTENDED, integerArray2, coordinator);
        logger.traceReturn(THIS_CLASS, "updateCabinetParametersProfiles()");
    }

    private String getProductNameForCabinetParametersSelection(Coordinator coordinator) throws MoAccessException {
        Struct struct = (Struct)this.getAttribute(ATTRIBUTE_PRODUCT_DATA, coordinator);
        String string = (String)struct.getValue(ATTRIBUTE_PRODUCT_NAME);
        String string2 = "";
        string2 = CabinetParametersHelper.isValidProductName(string, this.genericMaoContext) ? string : CabinetParametersHelper.getProductNameFromManagedElementMO(this.genericMaoContext, coordinator);
        return string2;
    }

    private int getClimateSystem(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute(ATTRIBUTE_CLIMATE_SYSTEM, coordinator);
    }

    private String getClimateRegulationSystem(Coordinator coordinator) throws MoAccessException {
        return ((Integer)this.getAttribute(ATTRIBUTE_CLIMATE_REGULATION_SYSTEM, coordinator)).toString();
    }
}

