/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure;

import java.io.IOException;
import java.util.ArrayList;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.CabinetData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.ClimateSystemData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.EcBusData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.EcPortConnectionData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.ExternalAlarmsData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.ExternalNodeData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.HwUnitData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.PlugInUnitData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.PowerSystemData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.RadioEquipmentData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.SupportSystemMultiCabinetData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.SupportSystemSingleCabinetData;

public class SupportSystemData {
    public final transient PowerSystemData powerSystems;
    public final transient HwUnitData[] hwUnits;
    public final transient PlugInUnitData[] plugInUnits;
    public final transient ExternalNodeData[] externalNodes;
    public final transient int climateSystem;
    public final transient int climateRegulationSystem;
    public final transient int climateControlMode;
    public final transient boolean supportSystemControl;
    public final transient String cabinetType;
    public final transient EcPortConnectionData[] ecPortConnectionData;
    public final transient ExternalAlarmsData[] externalAlarmsData;
    public final transient int noOfExternalNodes;
    public final transient int xmlVersion;
    public transient RadioEquipmentData[] radioEquipments;
    public final transient boolean smokeDetector;
    public final transient CabinetData[] cabinetDataList;
    public final transient EcBusData[] ecBusDataList;
    public final transient PowerSystemData[] powerSystemDataList;
    public final transient ClimateSystemData[] climateSystemDataList;
    public final transient boolean isMultiCab;
    public final transient boolean isCascadingOrder;

    public SupportSystemData(PowerSystemData powerSystemData, HwUnitData[] hwUnitDataArray, PlugInUnitData[] plugInUnitDataArray, ExternalNodeData[] externalNodeDataArray, String string, String string2, String string3, boolean bl, String string4, boolean bl2, EcPortConnectionData[] ecPortConnectionDataArray, ExternalAlarmsData[] externalAlarmsDataArray, int n, int n2) throws IOException {
        this.powerSystems = powerSystemData;
        this.hwUnits = hwUnitDataArray;
        this.plugInUnits = plugInUnitDataArray;
        this.externalNodes = externalNodeDataArray;
        this.climateSystem = this.convertClimateSystem(string);
        this.climateRegulationSystem = this.convertClimateRegulationSystem(string2);
        this.climateControlMode = this.convertClimateControlMode(string3);
        this.supportSystemControl = bl;
        this.smokeDetector = bl2;
        this.cabinetType = string4;
        this.ecPortConnectionData = ecPortConnectionDataArray;
        this.externalAlarmsData = externalAlarmsDataArray;
        this.noOfExternalNodes = n;
        this.xmlVersion = n2;
        this.cabinetDataList = null;
        this.ecBusDataList = null;
        this.powerSystemDataList = null;
        this.climateSystemDataList = null;
        this.isMultiCab = false;
        this.isCascadingOrder = this.hwUnits == null ? false : this.hwUnits.length > 0 && this.hwUnits[0].ecPortConnections != null && this.hwUnits[0].ecPortConnections.length > 0 && this.hwUnits[0].ecPortConnections[0].cascadingOrder != null && !this.hwUnits[0].ecPortConnections[0].cascadingOrder.equalsIgnoreCase("0");
    }

    public SupportSystemData(SupportSystemSingleCabinetData supportSystemSingleCabinetData, SupportSystemMultiCabinetData supportSystemMultiCabinetData) throws IOException {
        this.powerSystems = supportSystemSingleCabinetData.powerSystems;
        this.hwUnits = supportSystemSingleCabinetData.hwUnits;
        this.plugInUnits = supportSystemSingleCabinetData.plugInUnits;
        this.externalNodes = supportSystemSingleCabinetData.externalNodes;
        this.climateSystem = this.convertClimateSystem(supportSystemSingleCabinetData.climateSystem);
        this.climateRegulationSystem = this.convertClimateRegulationSystem(supportSystemSingleCabinetData.climateRegulationSystem);
        this.climateControlMode = this.convertClimateControlMode(supportSystemSingleCabinetData.climateControlMode);
        this.supportSystemControl = supportSystemSingleCabinetData.supportSystemControl;
        this.smokeDetector = supportSystemSingleCabinetData.smokeDetector;
        this.cabinetType = supportSystemSingleCabinetData.cabinetType;
        this.ecPortConnectionData = supportSystemSingleCabinetData.ecPortConnectionData;
        this.externalAlarmsData = supportSystemSingleCabinetData.externalAlarmsData;
        this.noOfExternalNodes = supportSystemSingleCabinetData.noOfExternalNodes;
        this.xmlVersion = supportSystemSingleCabinetData.xmlVersion;
        this.cabinetDataList = supportSystemMultiCabinetData.cabinetDataList;
        this.ecBusDataList = supportSystemMultiCabinetData.ecBusDataList;
        this.powerSystemDataList = supportSystemMultiCabinetData.powerSystemDataList;
        this.climateSystemDataList = supportSystemMultiCabinetData.climateSystemDataList;
        this.isMultiCab = this.cabinetDataList == null ? false : (this.cabinetDataList.length > 1 ? true : this.climateSystemDataList != null);
        this.isCascadingOrder = this.hwUnits == null ? false : this.hwUnits.length > 0 && this.hwUnits[0].ecPortConnections != null && this.hwUnits[0].ecPortConnections.length > 0 && this.hwUnits[0].ecPortConnections[0].cascadingOrder != null && !this.hwUnits[0].ecPortConnections[0].cascadingOrder.equalsIgnoreCase("0");
    }

    protected final int convertClimateControlMode(String string) throws IOException {
        int n;
        if ("NORMAL".equalsIgnoreCase(string)) {
            n = 0;
        } else if ("BATTERY_LIFE_EXTENSION".equalsIgnoreCase(string)) {
            n = 1;
        } else {
            String string2 = "Invalid format for climateControlMode: " + string;
            throw new IOException(string2);
        }
        return n;
    }

    protected final int convertClimateSystem(String string) throws IOException {
        int n;
        if ("STANDARD".equalsIgnoreCase(string)) {
            n = 0;
        } else if ("EXTENDED".equalsIgnoreCase(string)) {
            n = 1;
        } else {
            String string2 = "Invalid format for climateSystem: " + string;
            throw new IOException(string2);
        }
        return n;
    }

    protected final int convertClimateRegulationSystem(String string) throws IOException {
        int n;
        if ("NOT_APPLICABLE".equalsIgnoreCase(string)) {
            n = 0;
        } else if ("DAC".equalsIgnoreCase(string)) {
            n = 1;
        } else if ("TS".equalsIgnoreCase(string)) {
            n = 2;
        } else if ("HEX".equalsIgnoreCase(string)) {
            n = 3;
        } else {
            String string2 = "Invalid format for climateRegulationSystem: " + string;
            throw new IOException(string2);
        }
        return n;
    }

    public final void append(RadioEquipmentData[] radioEquipmentDataArray) {
        this.radioEquipments = this.concatenateRadioEquipmentArrays(this.radioEquipments, radioEquipmentDataArray);
    }

    private final RadioEquipmentData[] concatenateRadioEquipmentArrays(RadioEquipmentData[] radioEquipmentDataArray, RadioEquipmentData[] radioEquipmentDataArray2) {
        int n;
        RadioEquipmentData[] radioEquipmentDataArray3 = null;
        ArrayList<RadioEquipmentData> arrayList = new ArrayList<RadioEquipmentData>();
        if (radioEquipmentDataArray != null) {
            for (n = 0; n < radioEquipmentDataArray.length; ++n) {
                arrayList.add(radioEquipmentDataArray[n]);
            }
        }
        if (radioEquipmentDataArray2 != null) {
            for (n = 0; n < radioEquipmentDataArray2.length; ++n) {
                arrayList.add(radioEquipmentDataArray2[n]);
            }
        }
        if (!arrayList.isEmpty()) {
            radioEquipmentDataArray3 = new RadioEquipmentData[arrayList.size()];
            radioEquipmentDataArray3 = arrayList.toArray(radioEquipmentDataArray3);
        }
        return radioEquipmentDataArray3;
    }

    private String hwUnitsToString() {
        String string = System.getProperty("line.separator");
        String string2 = "hwUnits[]: " + string;
        if (this.hwUnits == null) {
            string2 = string2 + "null";
        } else {
            for (int i = 0; i < this.hwUnits.length; ++i) {
                string2 = string2 + this.hwUnits[i].toString() + string;
            }
        }
        return string2;
    }

    private String plugInUnitsToString() {
        String string = System.getProperty("line.separator");
        String string2 = "plugInUnits[]: " + string;
        if (this.plugInUnits == null) {
            string2 = string2 + "null";
        } else {
            for (int i = 0; i < this.plugInUnits.length; ++i) {
                string2 = string2 + this.plugInUnits[i].toString() + string;
            }
        }
        return string2;
    }

    private String externalNodesToString() {
        String string = System.getProperty("line.separator");
        String string2 = "ExternalNodeData[]: " + string;
        if (this.externalNodes == null) {
            string2 = string2 + "null";
        } else {
            for (int i = 0; i < this.externalNodes.length; ++i) {
                string2 = string2 + this.externalNodes[i].toString() + string;
            }
        }
        return string2;
    }

    private String ecPortConnectionToString() {
        String string = System.getProperty("line.separator");
        String string2 = "EcPortConnectionData[]: //only valid for XML earlier than K" + string;
        if (this.ecPortConnectionData == null) {
            string2 = string2 + "null" + string;
        } else {
            for (int i = 0; i < this.ecPortConnectionData.length; ++i) {
                string2 = string2 + this.ecPortConnectionData[i].toString() + string;
            }
        }
        return string2;
    }

    private String externalAlarmsToString() {
        String string = System.getProperty("line.separator");
        String string2 = "ExternalAlarmsData[]: " + string;
        if (this.externalAlarmsData == null) {
            string2 = string2 + "null";
        } else {
            for (int i = 0; i < this.externalAlarmsData.length; ++i) {
                string2 = string2 + this.externalAlarmsData[i].toString() + string;
            }
        }
        return string2;
    }

    private String radioEquipmentToString() {
        String string = System.getProperty("line.separator");
        String string2 = "RadioEquipmentData[]: " + string;
        if (this.radioEquipments == null) {
            string2 = string2 + "null";
        } else {
            for (int i = 0; i < this.radioEquipments.length; ++i) {
                string2 = string2 + this.radioEquipments[i].toString() + string;
            }
        }
        return string2;
    }

    private String cabinetDataToString() {
        String string = System.getProperty("line.separator");
        String string2 = "CabinetData[]: " + string;
        if (this.cabinetDataList == null) {
            string2 = string2 + "null";
        } else {
            for (int i = 0; i < this.cabinetDataList.length; ++i) {
                string2 = string2 + this.cabinetDataList[i].toString() + string;
            }
        }
        return string2;
    }

    private String ecBusToString() {
        String string = System.getProperty("line.separator");
        String string2 = "EcBusData[]: " + string;
        if (this.ecBusDataList == null) {
            string2 = string2 + "null";
        } else {
            for (int i = 0; i < this.ecBusDataList.length; ++i) {
                string2 = string2 + this.ecBusDataList[i].toString() + string;
            }
        }
        return string2;
    }

    private String powerSystemToString() {
        String string = System.getProperty("line.separator");
        String string2 = "PowerSystemData[]: " + string;
        if (this.powerSystemDataList == null) {
            string2 = string2 + "null";
        } else {
            for (int i = 0; i < this.powerSystemDataList.length; ++i) {
                string2 = string2 + this.powerSystemDataList[i].toString() + string;
            }
        }
        return string2;
    }

    private String climateSystemToString() {
        String string = System.getProperty("line.separator");
        String string2 = "ClimateSystemData[]: " + string;
        if (this.climateSystemDataList == null) {
            string2 = string2 + "null";
        } else {
            for (int i = 0; i < this.climateSystemDataList.length; ++i) {
                string2 = string2 + this.climateSystemDataList[i].toString() + string;
            }
        }
        return string2;
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        String string2 = "SupportSystemData: " + string;
        string2 = string2 + "powerSystems: " + string + this.powerSystems + string;
        string2 = string2 + this.hwUnitsToString();
        string2 = string2 + this.plugInUnitsToString();
        string2 = string2 + this.externalNodesToString();
        string2 = string2 + "climateSystem = " + this.climateSystem + string;
        string2 = string2 + "climateRegulationSystem = " + this.climateRegulationSystem + string;
        string2 = string2 + "climateControlMode = " + this.climateControlMode + string;
        string2 = string2 + "supportSystemControl = " + this.supportSystemControl + string;
        string2 = string2 + "cabinetType = " + this.cabinetType + string;
        string2 = string2 + "smokeDetector = " + this.smokeDetector + string;
        string2 = string2 + this.ecPortConnectionToString();
        string2 = string2 + this.externalAlarmsToString();
        string2 = string2 + "noOfExternalNodes = " + this.noOfExternalNodes + string;
        string2 = string2 + "xmlVersion = " + this.xmlVersion + string;
        string2 = string2 + this.radioEquipmentToString();
        string2 = string2 + "smokeDetector = " + this.smokeDetector + string;
        string2 = string2 + this.cabinetDataToString();
        string2 = string2 + this.ecBusToString();
        string2 = string2 + this.powerSystemToString();
        string2 = string2 + this.climateSystemToString();
        string2 = string2 + "-----------------------------------------";
        return string2;
    }
}

