/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.supportsystemconfiguration.helper;

import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoHasChildrenException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.supsys.supportsystemconfiguration.SupportSystemConfigurationFailedException;
import se.ericsson.crbs.supsys.supportsystemconfiguration.helper.CabinetParametersHelper;

public class ExternalNodeHelper {
    private static final Class THIS_CLASS = ExternalNodeHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String EXTERNAL_NODE = "ExternalNode";
    private static final String ATTRIBUTE_INFORMATION_ONLY = "informationOnly";
    private static final String EQUIPMENT = "Equipment";
    private static Boolean supportSystemControl = null;

    public static boolean supportSystemControlChanged(boolean bl, GenericMaoContext genericMaoContext, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "supportSystemControlChanged()");
        boolean bl2 = false;
        if (bl && (supportSystemControl == null || !supportSystemControl.booleanValue())) {
            ExternalNodeHelper.deleteAllExternalNodesWithInformationOnlyTrue(genericMaoContext, coordinator);
            supportSystemControl = Boolean.TRUE;
            bl2 = true;
        } else if (!bl && (supportSystemControl == null || supportSystemControl.booleanValue())) {
            ExternalNodeHelper.createDefaultNumberOfExternalNodes(genericMaoContext, coordinator);
            supportSystemControl = Boolean.FALSE;
            bl2 = true;
        }
        logger.traceReturn(THIS_CLASS, "supportSystemControlChanged()");
        return bl2;
    }

    private static void deleteAllExternalNodesWithInformationOnlyTrue(GenericMaoContext genericMaoContext, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "deleteAllExternalNodesWithInformationOnlyTrue()");
        MoIterator moIterator = genericMaoContext.getMoRepositoryWrapper().lookupType(EXTERNAL_NODE);
        while (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            boolean bl = (Boolean)managedObject.getAttribute(ATTRIBUTE_INFORMATION_ONLY, coordinator);
            if (bl) {
                ExternalNodeHelper.deleteExternalNode(managedObject, bl, coordinator);
                continue;
            }
            logger.traceDebug(THIS_CLASS, "ExternalNode " + (bl ? "" : "not") + " deleted, informationOnly:" + bl + ", ldn: " + managedObject.getLocalDistinguishedName());
        }
        logger.traceReturn(THIS_CLASS, "deleteAllExternalNodesWithInformationOnlyTrue()");
    }

    private static void createDefaultNumberOfExternalNodes(GenericMaoContext genericMaoContext, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "createDefaultNumberOfExternalNodes()");
        MoIterator moIterator = genericMaoContext.getMoRepositoryWrapper().lookupType(EXTERNAL_NODE);
        while (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            boolean bl = (Boolean)managedObject.getAttribute(ATTRIBUTE_INFORMATION_ONLY, coordinator);
            ExternalNodeHelper.deleteExternalNode(managedObject, bl, coordinator);
            logger.traceDebug(THIS_CLASS, "ExternalNode deleted, informationOnly:" + bl + ",ldn: " + managedObject.getLocalDistinguishedName());
        }
        int n = CabinetParametersHelper.getDefaultNumberExternalNodes(genericMaoContext, coordinator);
        logger.traceDebug(THIS_CLASS, "defaultNumberExternalNodes:" + n);
        MoFactory moFactory = genericMaoContext.getMoFactoryMgrWrapper().lookup(EXTERNAL_NODE);
        AttrListImpl attrListImpl = new AttrListImpl();
        attrListImpl.addElement(ATTRIBUTE_INFORMATION_ONLY, (Object)Boolean.TRUE);
        for (int i = 1; i <= n; ++i) {
            moFactory.createMo(ExternalNodeHelper.parent(genericMaoContext), (AttrList)attrListImpl, String.valueOf(i), null, coordinator);
            logger.traceDebug(THIS_CLASS, "ExternalNode created with informationOnly set to true");
        }
        logger.traceReturn(THIS_CLASS, "createDefaultNumberOfExternalNodes()");
    }

    private static void deleteExternalNode(ManagedObject managedObject, boolean bl, Coordinator coordinator) throws MoHasChildrenException, MoAccessException {
        MoIterator moIterator = managedObject.getChildren();
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject2 = (ManagedObject)moIterator.nextElement();
            managedObject2.delete(coordinator);
        }
        managedObject.delete(coordinator);
        logger.traceDebug(THIS_CLASS, "ExternalNode deleted, informationOnly:" + bl + ",ldn: " + managedObject.getLocalDistinguishedName());
    }

    private static ManagedObject parent(GenericMaoContext genericMaoContext) throws MoAccessException {
        MoIterator moIterator = genericMaoContext.getMoRepositoryWrapper().lookupType(EQUIPMENT);
        if (moIterator == null || !moIterator.hasMoreElements()) {
            throw new SupportSystemConfigurationFailedException("Can't find MO Equipment");
        }
        return moIterator.nextMo();
    }

    public static void _reset_onlyForTest(GenericMaoContext genericMaoContext, Coordinator coordinator) throws MoAccessException {
        supportSystemControl = null;
        MoIterator moIterator = genericMaoContext.getMoRepositoryWrapper().lookupType(EXTERNAL_NODE);
        while (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            managedObject.delete(coordinator);
        }
    }
}

