/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.supportsystemconfiguration.helper;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.equipment.intma.PiuTypeAccess;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;
import se.ericsson.crbs.supsys.supportsystemconfiguration.SupportSystemConfigurationDefinitions;
import se.ericsson.crbs.supsys.supportsystemconfiguration.SupportSystemConfigurationFailedException;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.AlarmPortData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.EcPortConnectionData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.ExternalAlarmsData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.ExternalNodeData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.HwUnitData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.PlugInUnitData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.PowerSystemData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.RadioEquipmentData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.RadioUnitData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure.SupportSystemData;
import se.ericsson.crbs.supsys.supportsystemconfiguration.helper.EcBusHelper;
import se.ericsson.crbs.supsys.supportsystemconfiguration.helper.PiuTypeFinder;
import se.ericsson.crbs.supsys.supportsystemconfiguration.helper.ReportLoggerHelper;

public class PowerSystemHelper {
    private static final Class THIS_CLASS = PowerSystemHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String factoryNotFoundSlogan = "MO factory not found";
    private static final String moCreateFailedSlogan = "Failed to create MO";
    private final transient MoRepositoryWrapper aMoRepository;
    private final transient MoFactoryMgrWrapper aFactoryMgr;
    private final transient GenericMaoContext mGenericMaoContext;
    private ManagedObject equipmentMo;
    private ManagedObject equipmentSupportFunctionMo;
    private MoFactory hwunitFactory;
    private MoFactory externalNodeFactory;
    private final AttrListImpl emptyAttrList = new AttrListImpl();
    private final List createdMos = new LinkedList();

    public PowerSystemHelper(GenericMaoContext genericMaoContext) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "PowerSystemHelper() - Constructor");
        this.aMoRepository = genericMaoContext.getMoRepositoryWrapper();
        this.aFactoryMgr = genericMaoContext.getMoFactoryMgrWrapper();
        this.mGenericMaoContext = genericMaoContext;
        logger.traceReturn(THIS_CLASS, "PowerSystemHelper() - Constructor");
    }

    private boolean checkSAU(ExternalAlarmsData[] externalAlarmsDataArray) {
        boolean bl = false;
        for (int i = 0; externalAlarmsDataArray != null && i < externalAlarmsDataArray.length && !bl; ++i) {
            if (!externalAlarmsDataArray[i].unitId.equalsIgnoreCase("SAU")) continue;
            bl = true;
        }
        return bl;
    }

    public void createAndConfigurePowerSystem(HwUnitData[] hwUnitDataArray, PowerSystemData powerSystemData, int n, boolean bl, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createAndConfigurePowerSystem()");
        this.equipmentSupportFunctionMo = this.aMoRepository.lookup("ManagedElement=1,EquipmentSupportFunction=1");
        if (this.equipmentSupportFunctionMo == null) {
            MoFactory moFactory = this.aFactoryMgr.lookup("EquipmentSupportFunction");
            ManagedObject managedObject = this.aMoRepository.lookup("ManagedElement=1");
            try {
                this.equipmentSupportFunctionMo = moFactory.createMo(managedObject, (AttrList)new AttrListImpl(), "1", null, coordinator);
            }
            catch (MoAccessException moAccessException) {
                throw new SupportSystemConfigurationFailedException(moCreateFailedSlogan, "Could not create the + EquipmentSupportFunction MO.", (Exception)((Object)moAccessException));
            }
        }
        this.equipmentMo = this.aMoRepository.lookup("ManagedElement=1,Equipment=1");
        if (this.equipmentMo == null) {
            throw new SupportSystemConfigurationFailedException("Parent not found", "Unable to find the parent for HwUnit.");
        }
        try {
            this.createRequiredPowerSystemMos(hwUnitDataArray, powerSystemData, n, bl, coordinator);
        }
        catch (SupportSystemConfigurationFailedException supportSystemConfigurationFailedException) {
            throw new SupportSystemConfigurationFailedException("PowerSystem configuration failed", "Failed to configure the PowerSystem.", (Exception)((Object)supportSystemConfigurationFailedException));
        }
        logger.traceReturn(THIS_CLASS, "createAndConfigurePowerSystem()");
    }

    private void createRequiredPowerSystemMos(HwUnitData[] hwUnitDataArray, PowerSystemData powerSystemData, int n, boolean bl, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createRequiredPowerSystemMos()");
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (n > 2 && hwUnitDataArray != null && bl) {
            logger.traceDebug(THIS_CLASS, "createRequiredPowerSystemMos() - for version > 2");
            for (int i = 0; i < hwUnitDataArray.length; ++i) {
                if (hwUnitDataArray[i].positionRef == null) {
                    throw new SupportSystemConfigurationFailedException("HwUnit MO.", "For Multi Cabinet configuration positionRef is mandatory.");
                }
                if (powerSystemData.controlDomainRef == null) {
                    throw new SupportSystemConfigurationFailedException("No controlDomainRef for PowerSystem.", "For Multi Cabinet configuration controlDomainRef is mandatory.");
                }
                if (!hwUnitDataArray[i].positionRef.equals(powerSystemData.controlDomainRef)) continue;
                String string = hwUnitDataArray[i].unitType;
                if (string.startsWith("PSU")) {
                    bl2 = true;
                    continue;
                }
                if (string.startsWith("PDU")) {
                    bl4 = true;
                    bl2 = true;
                    continue;
                }
                if (!string.startsWith("BFU")) continue;
                bl3 = true;
                bl4 = true;
            }
            if (bl2) {
                logger.traceEnter(THIS_CLASS, "createRequiredPowerSystemMos -> createPowerSupplyMultiCabinet");
                this.createPowerSupplyMultiCabinet(powerSystemData, coordinator);
            }
            if (bl3) {
                logger.traceEnter(THIS_CLASS, "createRequiredPowerSystemMos -> createBatteryBackupMultiCabinet");
                this.createBatteryBackupMultiCabinet(powerSystemData, coordinator);
            }
            if (bl4) {
                logger.traceEnter(THIS_CLASS, "createRequiredPowerSystemMos -> createPowerDistributionMultiCabinet");
                this.createPowerDistributionMultiCabinet(powerSystemData, coordinator);
            }
        } else {
            if (n > 1 && hwUnitDataArray != null) {
                for (int i = 0; i < hwUnitDataArray.length; ++i) {
                    String string = hwUnitDataArray[i].unitType;
                    if (string.startsWith("PSU")) {
                        bl2 = true;
                        continue;
                    }
                    if (string.startsWith("PDU")) {
                        bl4 = true;
                        bl2 = true;
                        continue;
                    }
                    if (!string.startsWith("BFU")) continue;
                    bl3 = true;
                    bl4 = true;
                }
            }
            if (n < 2 && powerSystemData != null) {
                if (powerSystemData.noOfPsu > 0) {
                    bl2 = true;
                }
                if (powerSystemData.noOfPdu > 0) {
                    bl4 = true;
                    bl2 = true;
                }
                if (powerSystemData.noOfBfu > 0) {
                    bl3 = true;
                    bl4 = true;
                }
            }
            if (bl2) {
                this.createPowerSupply(powerSystemData, coordinator);
            }
            if (bl3) {
                this.createBatteryBackup(powerSystemData, coordinator);
            }
            if (bl4) {
                this.createPowerDistribution(coordinator);
            }
        }
        logger.traceReturn(THIS_CLASS, "createRequiredPowerSystemMos()");
    }

    protected void createPowerSupply(PowerSystemData powerSystemData, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createPowerSupply()");
        if (!this.doesParentHaveChild(this.equipmentSupportFunctionMo, "PowerSupply")) {
            MoFactory moFactory = this.aFactoryMgr.lookup("PowerSupply");
            if (moFactory == null) {
                throw new SupportSystemConfigurationFailedException(factoryNotFoundSlogan, "Could not find MO factory for PowerSupply.");
            }
            try {
                AttrListImpl attrListImpl = new AttrListImpl();
                if (powerSystemData != null) {
                    attrListImpl.addElement("multiplePowerSystem", (Object)powerSystemData.multiplePowerSystem);
                }
                moFactory.createMo(this.equipmentSupportFunctionMo, (AttrList)attrListImpl, "1", null, coordinator);
                ReportLoggerHelper.getInstance().logAction("PowerSupply", "create", "LDN", "ManagedElement=1,EquipmentSupportFunction=1,PowerSupply=1");
            }
            catch (MoAccessException moAccessException) {
                throw new SupportSystemConfigurationFailedException(moCreateFailedSlogan, "PowerSupply could not be created.", (Exception)((Object)moAccessException));
            }
        }
        logger.traceReturn(THIS_CLASS, "createPowerSupply()");
    }

    protected void createPowerSupplyMultiCabinet(PowerSystemData powerSystemData, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createPowerSupplyMultiCabinet()");
        MoFactory moFactory = this.aFactoryMgr.lookup("PowerSupply");
        if (moFactory == null) {
            throw new SupportSystemConfigurationFailedException(factoryNotFoundSlogan, "Could not find MO factory for PowerSupply.");
        }
        ManagedObject managedObject = this.aMoRepository.lookup("ManagedElement=1,Equipment=1,Cabinet=" + this.makeId(powerSystemData.controlDomainRef));
        if (managedObject == null) {
            String string = "Unable to find a cabinet with id = " + powerSystemData.controlDomainRef + " for PSU";
            throw new SupportSystemConfigurationFailedException("Cabinet not found", string);
        }
        try {
            AttrListImpl attrListImpl = new AttrListImpl();
            if (powerSystemData != null) {
                attrListImpl.addElement("multiplePowerSystem", (Object)powerSystemData.multiplePowerSystem);
                logger.traceDebug(THIS_CLASS, "AttrListImpl.addElement(ATTR_CONTROL_DOMAIN_REF_POWER_SUPPLY)");
                attrListImpl.addElement("controlDomainRef", (Object)new ManagedObject[]{managedObject});
            }
            moFactory.createMo(this.equipmentSupportFunctionMo, (AttrList)attrListImpl, this.makeId(powerSystemData.controlDomainRef), null, coordinator);
            ReportLoggerHelper.getInstance().logAction("PowerSupply", "create", "LDN", "ManagedElement=1,EquipmentSupportFunction=1,PowerSupply=1");
        }
        catch (MoAccessException moAccessException) {
            throw new SupportSystemConfigurationFailedException(moCreateFailedSlogan, "PowerSupply could not be created.", (Exception)((Object)moAccessException));
        }
        logger.traceReturn(THIS_CLASS, "createPowerSupplyMultiCabinet()");
    }

    protected void createBatteryBackup(PowerSystemData powerSystemData, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createBatteryBackup()");
        if (!this.doesParentHaveChild(this.equipmentSupportFunctionMo, "BatteryBackup")) {
            MoFactory moFactory = this.aFactoryMgr.lookup("BatteryBackup");
            if (moFactory == null) {
                throw new SupportSystemConfigurationFailedException(factoryNotFoundSlogan, "Could not find MO factory for BatteryBackup.");
            }
            try {
                AttrListImpl attrListImpl = new AttrListImpl();
                if (powerSystemData != null) {
                    attrListImpl.addElement("batteryInstallationDate", (Object)powerSystemData.batteryInstallationDate);
                    attrListImpl.addElement("batteryType", (Object)new Integer(powerSystemData.batteryType));
                    attrListImpl.addElement("minimumBackupTime", (Object)new Integer(powerSystemData.minimumBackupTime));
                    attrListImpl.addElement("minimumStateOfHealth", (Object)new Integer(powerSystemData.minimumStateOfHealth));
                    attrListImpl.addElement("testMode", (Object)new Integer(powerSystemData.testMode));
                    attrListImpl.addElement("testStartDay", (Object)new Integer(powerSystemData.testStartDay));
                    attrListImpl.addElement("testStartTime", (Object)powerSystemData.testStartTime);
                    attrListImpl.addElement("testStartMonths", (Object)powerSystemData.testStartMonths);
                    attrListImpl.addElement("sharedBattery", (Object)powerSystemData.sharedBattery);
                }
                moFactory.createMo(this.equipmentSupportFunctionMo, (AttrList)attrListImpl, "1", null, coordinator);
                ReportLoggerHelper.getInstance().logAction("BatteryBackup", "create", "LDN", "ManagedElement=1,EquipmentSupportFunction=1,BatteryBackup=1");
            }
            catch (MoAccessException moAccessException) {
                throw new SupportSystemConfigurationFailedException(moCreateFailedSlogan, "BatteryBackup could not be created.", (Exception)((Object)moAccessException));
            }
        }
        logger.traceReturn(THIS_CLASS, "createBatteryBackup()");
    }

    protected void createBatteryBackupMultiCabinet(PowerSystemData powerSystemData, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createBatteryBackupMultiCabinet()");
        MoFactory moFactory = this.aFactoryMgr.lookup("BatteryBackup");
        if (moFactory == null) {
            throw new SupportSystemConfigurationFailedException(factoryNotFoundSlogan, "Could not find MO factory for BatteryBackup.");
        }
        ManagedObject managedObject = this.aMoRepository.lookup("ManagedElement=1,Equipment=1,Cabinet=" + this.makeId(powerSystemData.controlDomainRef));
        if (managedObject == null) {
            String string = "Unable to find a cabinet with id = " + powerSystemData.controlDomainRef;
            throw new SupportSystemConfigurationFailedException("Cabinet not found", string);
        }
        try {
            AttrListImpl attrListImpl = new AttrListImpl();
            if (powerSystemData != null) {
                attrListImpl.addElement("batteryInstallationDate", (Object)powerSystemData.batteryInstallationDate);
                attrListImpl.addElement("batteryType", (Object)new Integer(powerSystemData.batteryType));
                attrListImpl.addElement("minimumBackupTime", (Object)new Integer(powerSystemData.minimumBackupTime));
                attrListImpl.addElement("minimumStateOfHealth", (Object)new Integer(powerSystemData.minimumStateOfHealth));
                attrListImpl.addElement("testMode", (Object)new Integer(powerSystemData.testMode));
                attrListImpl.addElement("testStartDay", (Object)new Integer(powerSystemData.testStartDay));
                attrListImpl.addElement("testStartTime", (Object)powerSystemData.testStartTime);
                attrListImpl.addElement("testStartMonths", (Object)powerSystemData.testStartMonths);
                attrListImpl.addElement("sharedBattery", (Object)powerSystemData.sharedBattery);
                logger.traceDebug(THIS_CLASS, "AttrListImpl.addElement(ATTR_CONTROL_DOMAIN_REF_BATTERY_BACKUP)");
                attrListImpl.addElement("controlDomainRef", (Object)new ManagedObject[]{managedObject});
            }
            moFactory.createMo(this.equipmentSupportFunctionMo, (AttrList)attrListImpl, this.makeId(powerSystemData.controlDomainRef), null, coordinator);
            ReportLoggerHelper.getInstance().logAction("BatteryBackup", "create", "LDN", "ManagedElement=1,EquipmentSupportFunction=1,BatteryBackup=1");
        }
        catch (MoAccessException moAccessException) {
            throw new SupportSystemConfigurationFailedException(moCreateFailedSlogan, "BatteryBackup could not be created.", (Exception)((Object)moAccessException));
        }
        logger.traceReturn(THIS_CLASS, "createBatteryBackupMultiCabinet()");
    }

    protected void createPowerDistribution(Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createPowerDistribution()");
        if (!this.doesParentHaveChild(this.equipmentSupportFunctionMo, "PowerDistribution")) {
            MoFactory moFactory = this.aFactoryMgr.lookup("PowerDistribution");
            if (moFactory == null) {
                throw new SupportSystemConfigurationFailedException(factoryNotFoundSlogan, "Could not find MO factory for PowerDistribution.");
            }
            try {
                moFactory.createMo(this.equipmentSupportFunctionMo, (AttrList)this.emptyAttrList, "1", null, coordinator);
                ReportLoggerHelper.getInstance().logAction("PowerDistribution", "create", "LDN", "ManagedElement=1,EquipmentSupportFunction=1,PowerDistribution=1");
            }
            catch (MoAccessException moAccessException) {
                throw new SupportSystemConfigurationFailedException(moCreateFailedSlogan, "", (Exception)((Object)moAccessException));
            }
        }
        logger.traceReturn(THIS_CLASS, "createPowerDistribution()");
    }

    protected void createPowerDistributionMultiCabinet(PowerSystemData powerSystemData, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createPowerDistributionMultiCabinet()");
        MoFactory moFactory = this.aFactoryMgr.lookup("PowerDistribution");
        if (moFactory == null) {
            throw new SupportSystemConfigurationFailedException(factoryNotFoundSlogan, "Could not find MO factory for PowerDistribution.");
        }
        ManagedObject managedObject = this.aMoRepository.lookup("ManagedElement=1,Equipment=1,Cabinet=" + this.makeId(powerSystemData.controlDomainRef));
        if (managedObject == null) {
            String string = "Unable to find a cabinet with id = " + powerSystemData.controlDomainRef + " for PDU";
            throw new SupportSystemConfigurationFailedException("Cabinet not found", string);
        }
        try {
            AttrListImpl attrListImpl = new AttrListImpl();
            logger.traceDebug(THIS_CLASS, "AttrListImpl.addElement(ATTR_CONTROL_DOMAIN_REF_POWER_DISTRIBUTION)");
            attrListImpl.addElement("controlDomainRef", (Object)new ManagedObject[]{managedObject});
            moFactory.createMo(this.equipmentSupportFunctionMo, (AttrList)attrListImpl, this.makeId(powerSystemData.controlDomainRef), null, coordinator);
            ReportLoggerHelper.getInstance().logAction("PowerDistribution", "create", "LDN", "ManagedElement=1,EquipmentSupportFunction=1,PowerDistribution=1");
        }
        catch (MoAccessException moAccessException) {
            throw new SupportSystemConfigurationFailedException(moCreateFailedSlogan, "", (Exception)((Object)moAccessException));
        }
        logger.traceReturn(THIS_CLASS, "createPowerDistributionMultiCabinet()");
    }

    public void createExternalNodesXsd(ExternalNodeData[] externalNodeDataArray, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createExternalNodes()");
        this.externalNodeFactory = this.aFactoryMgr.lookup("ExternalNode");
        if (this.externalNodeFactory == null) {
            throw new SupportSystemConfigurationFailedException(factoryNotFoundSlogan, "Unable to find the MO factory for ExternalNode.");
        }
        if (externalNodeDataArray != null) {
            for (int i = 0; i < externalNodeDataArray.length; ++i) {
                String string = externalNodeDataArray[i].externalNodeId;
                String string2 = "ManagedElement=1,Equipment=1,ExternalNode=" + string;
                this.createExternalNode(string2, string, coordinator);
                EcPortConnectionData[] ecPortConnectionDataArray = externalNodeDataArray[i].ecPortConnections;
                if (ecPortConnectionDataArray == null) continue;
                for (int j = 0; j < ecPortConnectionDataArray.length; ++j) {
                    String string3 = ecPortConnectionDataArray[j].unitRef;
                    this.createEcPortXsd(string3, string2, ecPortConnectionDataArray[j].hubPosition, ecPortConnectionDataArray[j].cascadingOrder, coordinator);
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "createExternalNodes()");
    }

    public void createExternalNodesXsdMultiCabinet(ExternalNodeData[] externalNodeDataArray, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createExternalNodesXsdMultiCabinet()");
        this.externalNodeFactory = this.aFactoryMgr.lookup("ExternalNode");
        if (this.externalNodeFactory == null) {
            throw new SupportSystemConfigurationFailedException(factoryNotFoundSlogan, "Unable to find the MO factory for ExternalNode.");
        }
        if (externalNodeDataArray != null) {
            for (int i = 0; i < externalNodeDataArray.length; ++i) {
                String string = externalNodeDataArray[i].externalNodeId;
                String string2 = "ManagedElement=1,Equipment=1,ExternalNode=" + string;
                this.createExternalNode(string2, string, coordinator);
                EcPortConnectionData[] ecPortConnectionDataArray = externalNodeDataArray[i].ecPortConnections;
                if (ecPortConnectionDataArray == null) continue;
                for (int j = 0; j < ecPortConnectionDataArray.length; ++j) {
                    String string3 = ecPortConnectionDataArray[j].unitRef;
                    this.createEcPortXsdMultiCabinet(string3, string2, ecPortConnectionDataArray[j].hubPosition, ecPortConnectionDataArray[j].cascadingOrder, externalNodeDataArray[i].ecPortConnections[j].ecBusRef, coordinator);
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "createExternalNodesXsdMultiCabinet()");
    }

    public void createExternalNodesDtd(int n, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createExternalNodes()");
        this.externalNodeFactory = this.aFactoryMgr.lookup("ExternalNode");
        if (this.externalNodeFactory == null) {
            throw new SupportSystemConfigurationFailedException(factoryNotFoundSlogan, "Unable to find the MO factory for ExternalNode.");
        }
        for (int i = 1; i <= n; ++i) {
            String string = "ManagedElement=1,Equipment=1,ExternalNode=" + i;
            String string2 = Integer.toString(i);
            this.createExternalNode(string, string2, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "createExternalNodesDtd()");
    }

    protected void createExternalNode(String string, String string2, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createExternalNode() - Amount: " + string);
        ManagedObject managedObject = this.aMoRepository.lookup(string);
        if (managedObject == null) {
            try {
                managedObject = this.externalNodeFactory.createMo(this.equipmentMo, (AttrList)this.emptyAttrList, string2, null, coordinator);
                ReportLoggerHelper.getInstance().logAction("ExternalNode", "create", "LDN", managedObject.getLocalDistinguishedName());
            }
            catch (MoAccessException moAccessException) {
                String string3 = "Failed to create ExternalNode with LDN: " + string + ".";
                throw new SupportSystemConfigurationFailedException(moCreateFailedSlogan, string3, (Exception)((Object)moAccessException));
            }
        }
        logger.traceReturn(THIS_CLASS, "createExternalNode()");
    }

    public void createAndConfigureHwUnits(HwUnitData[] hwUnitDataArray, SupportSystemData supportSystemData, ExternalAlarmsData[] externalAlarmsDataArray, int n, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createAndConfigureHwUnits()");
        this.equipmentMo = this.aMoRepository.lookup("ManagedElement=1,Equipment=1");
        if (this.equipmentMo == null) {
            throw new SupportSystemConfigurationFailedException("Parent not found", "Unable to find the parent for HwUnit.");
        }
        this.equipmentSupportFunctionMo = this.aMoRepository.lookup("ManagedElement=1,EquipmentSupportFunction=1");
        if (this.equipmentSupportFunctionMo == null) {
            throw new SupportSystemConfigurationFailedException("Parent not found", "Unable to find the EquipmentSupportFunction.");
        }
        this.hwunitFactory = this.aFactoryMgr.lookup("HwUnit");
        if (this.hwunitFactory == null) {
            throw new SupportSystemConfigurationFailedException(factoryNotFoundSlogan, "Unable to find the MO factory for HwUnit.");
        }
        try {
            if (n > 1 && hwUnitDataArray != null) {
                if (n > 2 && supportSystemData.isMultiCab) {
                    logger.traceDebug(THIS_CLASS, "createHwUnitsAndChildrenMultiCabinet()");
                    this.createHwUnitsAndChildrenMultiCabinet(hwUnitDataArray, coordinator);
                } else {
                    this.createHwUnitsAndChildren(hwUnitDataArray, coordinator);
                }
            } else if (n < 2) {
                if (supportSystemData.powerSystems == null) {
                    throw new SupportSystemConfigurationFailedException("PowerSystem configuration failed.", "PowerSystem was not defined in configuration xml file.");
                }
                this.createPsus(supportSystemData.powerSystems.noOfPsu, coordinator);
                this.createPdus(supportSystemData.powerSystems.noOfPdu, coordinator);
                this.createBfus(supportSystemData.powerSystems.noOfBfu, coordinator);
                this.createScu(coordinator);
                if (this.checkSAU(externalAlarmsDataArray)) {
                    this.createSau(coordinator);
                }
            }
            this.unlockHwUnits(coordinator);
        }
        catch (SupportSystemConfigurationFailedException supportSystemConfigurationFailedException) {
            SupportSystemConfigurationFailedException supportSystemConfigurationFailedException2 = new SupportSystemConfigurationFailedException("HwUnit configuration failed", "Failed to create the hardware units for PSU, PDU, BFU, SCU and SAU", (Exception)((Object)supportSystemConfigurationFailedException));
            supportSystemConfigurationFailedException2.setStackTrace(supportSystemConfigurationFailedException.getStackTrace());
            throw supportSystemConfigurationFailedException2;
        }
        logger.traceReturn(THIS_CLASS, "createAndConfigureHwUnits()");
    }

    public void createHwUnitsAndChildren(HwUnitData[] hwUnitDataArray, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createHwUnits()");
        for (int i = 0; i < hwUnitDataArray.length; ++i) {
            String string = hwUnitDataArray[i].unitType;
            String string2 = "ManagedElement=1,Equipment=1,HwUnit=" + string;
            String string3 = this.getHwUnitType(string);
            this.createHwUnit(string, string2, string3, coordinator);
            EcPortConnectionData[] ecPortConnectionDataArray = hwUnitDataArray[i].ecPortConnections;
            if (ecPortConnectionDataArray != null) {
                for (int j = 0; j < ecPortConnectionDataArray.length; ++j) {
                    String string4 = ecPortConnectionDataArray[j].unitRef;
                    this.createEcPortXsd(string4, string2, ecPortConnectionDataArray[j].hubPosition, ecPortConnectionDataArray[j].cascadingOrder, coordinator);
                }
            } else {
                this.createEcPortXsd("1", string2, "NA", "0", coordinator);
            }
            AlarmPortData[] alarmPortDataArray = hwUnitDataArray[i].alarmPorts;
            if (alarmPortDataArray == null) continue;
            for (int j = 0; j < alarmPortDataArray.length; ++j) {
                this.createAlarmPort(alarmPortDataArray[j], string2, coordinator);
            }
        }
        logger.traceReturn(THIS_CLASS, "createHwUnits()");
    }

    public void createHwUnitsAndChildrenMultiCabinet(HwUnitData[] hwUnitDataArray, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createHwUnitsAndChildrenMultiCabinet()");
        for (int i = 0; i < hwUnitDataArray.length; ++i) {
            String string = hwUnitDataArray[i].unitType;
            String string2 = "ManagedElement=1,Equipment=1,HwUnit=" + string;
            String string3 = this.getHwUnitType(string);
            String string4 = hwUnitDataArray[i].positionRef;
            logger.traceDebug(THIS_CLASS, "createHwUnitMultiCabinet(hwUnitId, hwUnitLdn, hwUnitType, postionRef, coordinator)");
            this.createHwUnitMultiCabinet(string, string2, string3, string4, coordinator);
            EcPortConnectionData[] ecPortConnectionDataArray = hwUnitDataArray[i].ecPortConnections;
            if (ecPortConnectionDataArray != null) {
                for (int j = 0; j < ecPortConnectionDataArray.length; ++j) {
                    String string5 = ecPortConnectionDataArray[j].unitRef;
                    if (ecPortConnectionDataArray[j].ecBusRef == null) {
                        throw new SupportSystemConfigurationFailedException("No ecBusRef for ecPort.", "EcBusRef is mandatory attribute for multicabinet configuration.");
                    }
                    this.createEcPortsForHwUnits(string5, string2, ecPortConnectionDataArray[j].hubPosition, ecPortConnectionDataArray[j].cascadingOrder, ecPortConnectionDataArray[j].ecBusRef, coordinator);
                }
            } else {
                throw new SupportSystemConfigurationFailedException("EcPorts create failed", "EcPorts are required for multi cabinet configuration.");
            }
            AlarmPortData[] alarmPortDataArray = hwUnitDataArray[i].alarmPorts;
            if (alarmPortDataArray == null) continue;
            for (int j = 0; j < alarmPortDataArray.length; ++j) {
                this.createAlarmPort(alarmPortDataArray[j], string2, coordinator);
            }
        }
        logger.traceReturn(THIS_CLASS, "createHwUnitsAndChildrenMultiCabinet()");
    }

    private ManagedObject createAlarmPort(AlarmPortData alarmPortData, String string, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createAlarmPort()");
        ManagedObject managedObject = this.aMoRepository.lookup(string);
        ManagedObject managedObject2 = null;
        String string2 = alarmPortData.alarmPortId;
        if (managedObject == null) {
            String string3 = "Unable to find the parent for " + string + "," + "AlarmPort" + "=" + string2 + ".";
            throw new SupportSystemConfigurationFailedException("Parent not found", string3);
        }
        managedObject2 = this.aMoRepository.lookup(string + "," + "AlarmPort" + "=" + string2);
        if (managedObject2 == null) {
            MoFactory moFactory = this.aFactoryMgr.lookup("AlarmPort");
            try {
                AttrListImpl attrListImpl = this.createAlarmportAttrList(alarmPortData);
                managedObject2 = moFactory.createMo(managedObject, (AttrList)attrListImpl, string2, null, coordinator);
                this.createdMos.add(managedObject2);
                ReportLoggerHelper.getInstance().logAction("AlarmPort", "create", new String[]{"LDN", "alarmSlogan", "normallyOpen", "perceivedSeverity", "probableCause"}, new Object[]{managedObject2.getLocalDistinguishedName(), alarmPortData.alarmSlogan, alarmPortData.normallyOpen, new Integer(alarmPortData.perceivedSeverity), new Integer(alarmPortData.probableCause)});
            }
            catch (MoAccessException moAccessException) {
                String string4 = "AlarmPort with id " + string2 + " under " + string;
                SupportSystemConfigurationFailedException supportSystemConfigurationFailedException = new SupportSystemConfigurationFailedException("MO create failed", string4, (Exception)((Object)moAccessException));
                supportSystemConfigurationFailedException.setStackTrace(moAccessException.getStackTrace());
                throw supportSystemConfigurationFailedException;
            }
        }
        String[] stringArray = new String[]{"alarmSlogan", "normallyOpen", "perceivedSeverity", "probableCause"};
        Object[] objectArray = new Object[]{alarmPortData.alarmSlogan, alarmPortData.normallyOpen, new Integer(alarmPortData.perceivedSeverity), new Integer(alarmPortData.probableCause)};
        try {
            managedObject2.setAttributes(stringArray, objectArray, coordinator);
        }
        catch (MoAccessException moAccessException) {
            String string5 = "AlarmPort with id " + string2 + " under " + string;
            throw new SupportSystemConfigurationFailedException("MO create failed", string5, (Exception)((Object)moAccessException));
        }
        logger.traceReturn(THIS_CLASS, "createAlarmPort()");
        return null;
    }

    private AttrListImpl createAlarmportAttrList(AlarmPortData alarmPortData) {
        logger.traceEnter(THIS_CLASS, "createAlarmportAttrList()");
        AttrListImpl attrListImpl = new AttrListImpl();
        attrListImpl.addElement("alarmSlogan", (Object)alarmPortData.alarmSlogan);
        attrListImpl.addElement("normallyOpen", (Object)alarmPortData.normallyOpen);
        attrListImpl.addElement("perceivedSeverity", (Object)new Integer(alarmPortData.perceivedSeverity));
        attrListImpl.addElement("probableCause", (Object)new Integer(alarmPortData.probableCause));
        logger.traceReturn(THIS_CLASS, "createAlarmportAttrList()");
        return attrListImpl;
    }

    private void createEcPortsForHwUnits(String string, String string2, String string3, String string4, String string5, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createEcPortsForHwUnits()");
        ManagedObject managedObject = this.aMoRepository.lookup(string2);
        if (managedObject == null) {
            String string6 = "Unable to find the parent for " + string2 + "," + "EcPort" + "=" + string + ".";
            throw new SupportSystemConfigurationFailedException("Parent not found", string6);
        }
        MoFactory moFactory = this.aFactoryMgr.lookup("EcPort");
        AttrListImpl attrListImpl = new AttrListImpl();
        ManagedObject managedObject2 = this.aMoRepository.lookup("ManagedElement=1,Equipment=1,EcBus=" + this.makeId(string5));
        if (null == managedObject2) {
            logger.traceEnter(THIS_CLASS, "ecBusRef: " + string5);
            String string7 = "Unable to find the EcBus with id '" + this.makeId(string5) + "' ecBusRef: '" + string5 + "' for " + string2 + "," + "EcPort" + "=" + string + ".";
            throw new SupportSystemConfigurationFailedException("EcBus not found.", string7);
        }
        attrListImpl.addElement("ecBusRef", (Object)managedObject2);
        if (null != string3) {
            attrListImpl.addElement("hubPosition", (Object)string3);
        }
        if (null != string4) {
            attrListImpl.addElement("cascadingOrder", (Object)new Integer(Integer.parseInt(string4)));
        }
        try {
            moFactory.createMo(managedObject, (AttrList)attrListImpl, string, null, coordinator);
        }
        catch (MoAccessException moAccessException) {
            String string8 = "EcPort with id " + string + " under " + string2;
            logger.traceDebug(THIS_CLASS, "ecPortMo create failed: " + string8);
            throw new SupportSystemConfigurationFailedException("MO create failed", string8, (Exception)((Object)moAccessException));
        }
        logger.traceReturn(THIS_CLASS, "createEcPortsForHwUnits()");
    }

    private void createEcPortXsdMultiCabinet(String string, String string2, String string3, String string4, String string5, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        String string6;
        ManagedObject managedObject;
        logger.traceEnter(THIS_CLASS, "createEcPortXsdMultiCabinet()");
        ManagedObject managedObject2 = null;
        MoIterator moIterator = this.aMoRepository.lookupType("EcPort");
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                managedObject = moIterator.nextMo();
                string6 = managedObject.getLocalDistinguishedName();
                if (!string6.startsWith(string2)) continue;
                managedObject2 = managedObject;
            }
        }
        if (string2.indexOf("ExternalNode") != -1) {
            managedObject2 = this.aMoRepository.lookup(string2 + "," + "EcPort" + "=" + string);
        }
        if (managedObject2 == null) {
            managedObject = this.aMoRepository.lookup(string2);
            if (string5 == null) {
                throw new SupportSystemConfigurationFailedException("EcPort MO.", "For Multi Cabinet configuration ecBusRef is mandatory.");
            }
            string6 = this.aMoRepository.lookup("ManagedElement=1,Equipment=1,EcBus=" + this.makeId(string5));
            if (string6 == null) {
                String string7 = "Could not get EcBus with LDN ManagedElement=1,Equipment=1,EcBus=" + this.makeId(string5);
                throw new SupportSystemConfigurationFailedException("Looking up EcBus failed.", string7);
            }
            MoFactory moFactory = this.aFactoryMgr.lookup("EcPort");
            AttrListImpl attrListImpl = new AttrListImpl();
            if (null != string3) {
                attrListImpl.addElement("hubPosition", (Object)string3);
            }
            if (null != string4) {
                attrListImpl.addElement("cascadingOrder", (Object)new Integer(Integer.parseInt(string4)));
            }
            attrListImpl.addElement("ecBusRef", (Object)string6);
            try {
                managedObject2 = moFactory.createMo(managedObject, (AttrList)attrListImpl, string, null, coordinator);
                ReportLoggerHelper.getInstance().logAction("EcPort", "create", new String[]{"LDN", "hubPosition", "cascadingOrder"}, new Object[]{managedObject2.getLocalDistinguishedName(), null == string3 ? "null" : string3, null == string4 ? "null" : string4});
            }
            catch (MoAccessException moAccessException) {
                String string8 = "EcPort with id " + string + " under " + string2;
                logger.traceDebug(THIS_CLASS, "ecPortMo create failed: " + string8);
                throw new SupportSystemConfigurationFailedException("MO create failed", string8, (Exception)((Object)moAccessException));
            }
            catch (Exception exception) {
                String string9 = "EcPort with id " + string + " under " + string2;
                logger.traceDebug(THIS_CLASS, "ecPortMo create failed: " + exception.getMessage() + " exception, " + string9);
                throw new SupportSystemConfigurationFailedException("MO create failed", string9, exception);
            }
        }
        try {
            if (null != string3) {
                managedObject2.setAttribute("hubPosition", (Object)string3, coordinator);
            }
            if (null != string4) {
                managedObject2.setAttribute("cascadingOrder", (Object)new Integer(Integer.parseInt(string4)), coordinator);
            }
            ReportLoggerHelper.getInstance().logAttributes("EcPort", new String[]{"LDN", "hubPosition", "cascadingOrder"}, new Object[]{managedObject2.getLocalDistinguishedName(), null == string3 ? "null" : string3, null == string4 ? "null" : string4});
        }
        catch (MoAccessException moAccessException) {
            logger.traceDebug(THIS_CLASS, "Not able to set attribute hubPosition(" + string3 + ") or cascadingOrder(" + string4 + ") on unitRef: " + string2);
        }
        logger.traceReturn(THIS_CLASS, "createEcPortXsdMultiCabinet()");
    }

    private void createEcPortXsdMultiCabinetForPlugInUnit(String string, String string2, String string3, String string4, String string5, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        String string6;
        ManagedObject managedObject;
        logger.traceEnter(THIS_CLASS, "createEcPortXsdMultiCabinetForPlugInUnit()");
        ManagedObject managedObject2 = null;
        MoIterator moIterator = this.aMoRepository.lookupType("EcPort");
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                managedObject = moIterator.nextMo();
                string6 = managedObject.getLocalDistinguishedName();
                if (!string6.startsWith(string2)) continue;
                managedObject2 = managedObject;
            }
        }
        if (string2.indexOf("ExternalNode") != -1) {
            managedObject2 = this.aMoRepository.lookup(string2 + "," + "EcPort" + "=" + string);
        }
        if (managedObject2 == null) {
            managedObject = this.getPlugInUnitById(string2);
            if (managedObject == null) {
                String string7 = "Could not get PlugInUnit with id = " + string2;
                throw new SupportSystemConfigurationFailedException("Could not get PlugInUnit.", string7);
            }
            if (string5 == null) {
                throw new SupportSystemConfigurationFailedException("EcPort MO.", "For Multi Cabinet configuration ecBusRef is mandatory");
            }
            string6 = this.aMoRepository.lookup("ManagedElement=1,Equipment=1,EcBus=" + this.makeId(string5));
            if (string6 == null) {
                String string8 = "Could not get EcBus with LDN ManagedElement=1,Equipment=1,EcBus=" + this.makeId(string5);
                throw new SupportSystemConfigurationFailedException("Looking up EcBus failed.", string8);
            }
            MoFactory moFactory = this.aFactoryMgr.lookup("EcPort");
            AttrListImpl attrListImpl = new AttrListImpl();
            if (null != string3) {
                attrListImpl.addElement("hubPosition", (Object)string3);
            }
            if (null != string4) {
                attrListImpl.addElement("cascadingOrder", (Object)new Integer(Integer.parseInt(string4)));
            }
            attrListImpl.addElement("ecBusRef", (Object)string6);
            try {
                managedObject2 = moFactory.createMo(managedObject, (AttrList)attrListImpl, string, null, coordinator);
                ReportLoggerHelper.getInstance().logAction("EcPort", "create", new String[]{"LDN", "hubPosition", "cascadingOrder"}, new Object[]{managedObject2.getLocalDistinguishedName(), null == string3 ? "null" : string3, null == string4 ? "null" : string4});
            }
            catch (MoAccessException moAccessException) {
                String string9 = "EcPort with id " + string + " under " + string2;
                logger.traceDebug(THIS_CLASS, "ecPortMo create failed: " + string9);
                throw new SupportSystemConfigurationFailedException("MO create failed", string9, (Exception)((Object)moAccessException));
            }
            catch (Exception exception) {
                String string10 = "EcPort with id " + string + " under " + string2;
                logger.traceDebug(THIS_CLASS, "ecPortMo create failed: " + exception.getMessage() + " exception, " + string10);
                throw new SupportSystemConfigurationFailedException("MO create failed", string10, exception);
            }
        }
        try {
            if (null != string3) {
                managedObject2.setAttribute("hubPosition", (Object)string3, coordinator);
            }
            if (null != string4) {
                managedObject2.setAttribute("cascadingOrder", (Object)new Integer(Integer.parseInt(string4)), coordinator);
            }
            ReportLoggerHelper.getInstance().logAttributes("EcPort", new String[]{"LDN", "hubPosition", "cascadingOrder"}, new Object[]{managedObject2.getLocalDistinguishedName(), null == string3 ? "null" : string3, null == string4 ? "null" : string4});
        }
        catch (MoAccessException moAccessException) {
            logger.traceDebug(THIS_CLASS, "Not able to set attribute hubPosition(" + string3 + ") or cascadingOrder(" + string4 + ") on unitRef: " + string2);
        }
        logger.traceReturn(THIS_CLASS, "createEcPortXsdMultiCabinetForPlugInUnit()");
    }

    private void createEcPortXsd(String string, String string2, String string3, String string4, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        String string5;
        ManagedObject managedObject;
        logger.traceEnter(THIS_CLASS, "createEcPortXsd()");
        EcBusHelper ecBusHelper = new EcBusHelper(this.mGenericMaoContext);
        ManagedObject managedObject2 = null;
        MoIterator moIterator = this.aMoRepository.lookupType("EcPort");
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                managedObject = moIterator.nextMo();
                string5 = managedObject.getLocalDistinguishedName();
                if (!string5.startsWith(string2)) continue;
                managedObject2 = managedObject;
            }
        }
        if (string2.indexOf("ExternalNode") != -1) {
            managedObject2 = this.aMoRepository.lookup(string2 + "," + "EcPort" + "=" + string);
        }
        if (managedObject2 == null) {
            ManagedObject managedObject3;
            managedObject = this.aMoRepository.lookup(string2);
            string5 = this.aFactoryMgr.lookup("EcPort");
            AttrListImpl attrListImpl = new AttrListImpl();
            if (null != string3) {
                attrListImpl.addElement("hubPosition", (Object)string3);
            }
            if (null != string4) {
                attrListImpl.addElement("cascadingOrder", (Object)new Integer(Integer.parseInt(string4)));
            }
            if ((managedObject3 = ecBusHelper.getEcBus(coordinator)) == null) {
                throw new SupportSystemConfigurationFailedException("Looking up EcBus failed.", "Could not get EcBus for EcBus with LDN ManagedElement=1,Equipment=1,EcBus=");
            }
            attrListImpl.addElement("ecBusRef", (Object)managedObject3);
            try {
                managedObject2 = string5.createMo(managedObject, (AttrList)attrListImpl, string, null, coordinator);
                ReportLoggerHelper.getInstance().logAction("EcPort", "create", new String[]{"LDN", "hubPosition", "cascadingOrder"}, new Object[]{managedObject2.getLocalDistinguishedName(), null == string3 ? "null" : string3, null == string4 ? "null" : string4});
            }
            catch (MoAccessException moAccessException) {
                String string6 = "EcPort with id " + string + " under " + string2;
                logger.traceDebug(THIS_CLASS, "ecPortMo create failed: " + string6);
                throw new SupportSystemConfigurationFailedException("MO create failed", string6, (Exception)((Object)moAccessException));
            }
            catch (Exception exception) {
                String string7 = "EcPort with id " + string + " under " + string2;
                logger.traceDebug(THIS_CLASS, "ecPortMo create failed: " + exception.getMessage() + " exception, " + string7);
                throw new SupportSystemConfigurationFailedException("MO create failed", string7, exception);
            }
        }
        try {
            if (null != string3) {
                managedObject2.setAttribute("hubPosition", (Object)string3, coordinator);
            }
            if (null != string4) {
                managedObject2.setAttribute("cascadingOrder", (Object)new Integer(Integer.parseInt(string4)), coordinator);
            }
            ReportLoggerHelper.getInstance().logAttributes("EcPort", new String[]{"LDN", "hubPosition", "cascadingOrder"}, new Object[]{managedObject2.getLocalDistinguishedName(), null == string3 ? "null" : string3, null == string4 ? "null" : string4});
        }
        catch (MoAccessException moAccessException) {
            logger.traceDebug(THIS_CLASS, "Not able to set attribute hubPosition(" + string3 + ") or cascadingOrder(" + string4 + ") on unitRef: " + string2);
        }
        logger.traceReturn(THIS_CLASS, "createEcPortXsd()");
    }

    private ManagedObject createHwUnit(String string, String string2, String string3, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createHwUnit()");
        PiuTypeAccess piuTypeAccess = PiuTypeFinder.findPiuType(string3, this.aMoRepository, coordinator);
        if (piuTypeAccess == null) {
            String string4 = "Unable to find a PiuType that matches the productname " + string3;
            throw new SupportSystemConfigurationFailedException("PiuType not found", string4);
        }
        ManagedObject managedObject = this.aMoRepository.lookup(string2);
        if (managedObject == null) {
            AttrListImpl attrListImpl = new AttrListImpl();
            attrListImpl.addElement("piuType", (Object)piuTypeAccess);
            try {
                managedObject = this.hwunitFactory.createMo(this.equipmentMo, (AttrList)attrListImpl, string, null, coordinator);
                this.createdMos.add(managedObject);
                ReportLoggerHelper.getInstance().logAction("HwUnit", "create", new String[]{"LDN", "PiuType"}, new Object[]{managedObject.getLocalDistinguishedName(), piuTypeAccess.getLocalDistinguishedName()});
            }
            catch (MoAccessException moAccessException) {
                String string5 = "Unable to create the HwUnit MO. Type: PSU - ID: " + string;
                throw new SupportSystemConfigurationFailedException(moCreateFailedSlogan, string5, (Exception)((Object)moAccessException));
            }
        }
        logger.traceReturn(THIS_CLASS, "createHwUnit()");
        return managedObject;
    }

    private ManagedObject createHwUnitMultiCabinet(String string, String string2, String string3, String string4, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createHwUnitMultiCabinet()");
        PiuTypeAccess piuTypeAccess = PiuTypeFinder.findPiuType(string3, this.aMoRepository, coordinator);
        if (piuTypeAccess == null) {
            String string5 = "Unable to find a PiuType that matches the productname " + string3;
            throw new SupportSystemConfigurationFailedException("PiuType not found", string5);
        }
        ManagedObject managedObject = this.aMoRepository.lookup(string2);
        if (managedObject == null) {
            ManagedObject managedObject2 = this.aMoRepository.lookup("ManagedElement=1,Equipment=1,Cabinet=" + this.makeId(string4));
            if (managedObject2 == null) {
                String string6 = "Unable to find a cabinet with id = " + string4;
                throw new SupportSystemConfigurationFailedException("Cabinet not found", string6);
            }
            AttrListImpl attrListImpl = new AttrListImpl();
            attrListImpl.addElement("piuType", (Object)piuTypeAccess);
            logger.traceDebug(THIS_CLASS, "AttrListImpl.addElement(ATTR_POSITION_REF_HW_UNIT)");
            attrListImpl.addElement("positionRef", (Object)managedObject2);
            try {
                managedObject = this.hwunitFactory.createMo(this.equipmentMo, (AttrList)attrListImpl, string, null, coordinator);
                this.createdMos.add(managedObject);
                ReportLoggerHelper.getInstance().logAction("HwUnit", "create", new String[]{"LDN", "PiuType"}, new Object[]{managedObject.getLocalDistinguishedName(), piuTypeAccess.getLocalDistinguishedName()});
            }
            catch (MoAccessException moAccessException) {
                String string7 = "Unable to create the HwUnit MO. Type: PSU - ID: " + string;
                throw new SupportSystemConfigurationFailedException(moCreateFailedSlogan, string7, (Exception)((Object)moAccessException));
            }
        }
        logger.traceReturn(THIS_CLASS, "createHwUnitMultiCabinet()");
        return managedObject;
    }

    private String getHwUnitType(String string) throws SupportSystemConfigurationFailedException {
        String string2 = null;
        if (string.startsWith("PSU")) {
            string2 = "PSU";
        } else if (string.startsWith("PDU")) {
            string2 = "PDU";
        } else if (string.startsWith("BFU")) {
            string2 = "BFU";
        } else if (string.startsWith("SUP")) {
            string2 = "SUP";
        } else if (string.startsWith("SAU")) {
            string2 = "SAU";
        } else if (string.startsWith("SCU")) {
            string2 = "SCU";
        } else if (string.startsWith("EMU")) {
            string2 = "EMU";
        } else {
            String string3 = "Unable to create the HwUnit MO. Type: Unknown - ID(UnitType): " + string;
            throw new SupportSystemConfigurationFailedException(moCreateFailedSlogan, string3);
        }
        return string2;
    }

    protected void createPsus(int n, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createPsus() - Amount: " + n);
        for (int i = 1; i <= n; ++i) {
            String string = "PSU-" + i;
            String string2 = "ManagedElement=1,Equipment=1,HwUnit=" + string;
            PiuTypeAccess piuTypeAccess = PiuTypeFinder.findPiuType("PSU", this.aMoRepository, coordinator);
            if (piuTypeAccess == null) {
                throw new SupportSystemConfigurationFailedException("PiuType not found", "Unable to find a PiuType that matches the productname PSU");
            }
            ManagedObject managedObject = this.aMoRepository.lookup(string2);
            if (managedObject != null) continue;
            AttrListImpl attrListImpl = new AttrListImpl();
            attrListImpl.addElement("piuType", (Object)piuTypeAccess);
            try {
                managedObject = this.hwunitFactory.createMo(this.equipmentMo, (AttrList)attrListImpl, string, null, coordinator);
                this.createdMos.add(managedObject);
                this.createEcPortXsd("1", managedObject.getLocalDistinguishedName(), "NA", "0", coordinator);
                ReportLoggerHelper.getInstance().logAction("HwUnit", "create", new String[]{"LDN", "PiuType"}, new Object[]{managedObject.getLocalDistinguishedName(), piuTypeAccess.getLocalDistinguishedName()});
                continue;
            }
            catch (MoAccessException moAccessException) {
                String string3 = "Unable to create the HwUnit MO. Type: PSU - ID: " + string;
                throw new SupportSystemConfigurationFailedException(moCreateFailedSlogan, string3, (Exception)((Object)moAccessException));
            }
        }
        logger.traceReturn(THIS_CLASS, "createPsus()");
    }

    protected void createPdus(int n, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createPdus() - Amount: " + n);
        for (int i = 1; i <= n; ++i) {
            String string = "PDU-" + i;
            String string2 = "ManagedElement=1,Equipment=1,HwUnit=" + string;
            PiuTypeAccess piuTypeAccess = PiuTypeFinder.findPiuType("PDU", this.aMoRepository, coordinator);
            if (piuTypeAccess == null) {
                throw new SupportSystemConfigurationFailedException("PiuType not found", "Unable to find a PiuType that matches the productname PDU");
            }
            ManagedObject managedObject = this.aMoRepository.lookup(string2);
            if (managedObject != null) continue;
            AttrListImpl attrListImpl = new AttrListImpl();
            attrListImpl.addElement("piuType", (Object)piuTypeAccess);
            try {
                managedObject = this.hwunitFactory.createMo(this.equipmentMo, (AttrList)attrListImpl, string, null, coordinator);
                this.createdMos.add(managedObject);
                this.createEcPortXsd("1", managedObject.getLocalDistinguishedName(), "NA", "0", coordinator);
                ReportLoggerHelper.getInstance().logAction("HwUnit", "create", new String[]{"LDN", "PiuType"}, new Object[]{managedObject.getLocalDistinguishedName(), piuTypeAccess.getLocalDistinguishedName()});
                continue;
            }
            catch (MoAccessException moAccessException) {
                String string3 = "Unable to create the HwUnitMO. Type: PDU - ID: " + string;
                throw new SupportSystemConfigurationFailedException(moCreateFailedSlogan, string3, (Exception)((Object)moAccessException));
            }
        }
        logger.traceReturn(THIS_CLASS, "createPdus()");
    }

    protected void createBfus(int n, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createBfus() - Amount: " + n);
        for (int i = 1; i <= n; ++i) {
            String string = "BFU-" + i;
            String string2 = "ManagedElement=1,Equipment=1,HwUnit=" + string;
            PiuTypeAccess piuTypeAccess = PiuTypeFinder.findPiuType("BFU", this.aMoRepository, coordinator);
            if (piuTypeAccess == null) {
                throw new SupportSystemConfigurationFailedException("PiuType not found", "Unable to find a PiuType that matches the productname BFU");
            }
            ManagedObject managedObject = this.aMoRepository.lookup(string2);
            if (managedObject != null) continue;
            AttrListImpl attrListImpl = new AttrListImpl();
            attrListImpl.addElement("piuType", (Object)piuTypeAccess);
            try {
                managedObject = this.hwunitFactory.createMo(this.equipmentMo, (AttrList)attrListImpl, string, null, coordinator);
                this.createdMos.add(managedObject);
                this.createEcPortXsd("1", managedObject.getLocalDistinguishedName(), "NA", "0", coordinator);
                ReportLoggerHelper.getInstance().logAction("HwUnit", "create", new String[]{"LDN", "PiuType"}, new Object[]{managedObject.getLocalDistinguishedName(), piuTypeAccess.getLocalDistinguishedName()});
                continue;
            }
            catch (MoAccessException moAccessException) {
                String string3 = "Unable to create the HwUnitMO. Type: BFU - ID: " + string;
                throw new SupportSystemConfigurationFailedException(moCreateFailedSlogan, string3, (Exception)((Object)moAccessException));
            }
        }
        logger.traceReturn(THIS_CLASS, "createBfus()");
    }

    protected void createScu(Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createScu()");
        ManagedObject managedObject = this.aMoRepository.lookup("ManagedElement=1,Equipment=1,HwUnit=SCU");
        if (managedObject == null) {
            PiuTypeAccess piuTypeAccess = PiuTypeFinder.findPiuType("SCU", this.aMoRepository, coordinator);
            if (piuTypeAccess == null) {
                throw new SupportSystemConfigurationFailedException("PiuType not found", "Unable to find a PiuType that matches the productname SCU.");
            }
            AttrListImpl attrListImpl = new AttrListImpl();
            attrListImpl.addElement("piuType", (Object)piuTypeAccess);
            try {
                ManagedObject managedObject2 = this.hwunitFactory.createMo(this.equipmentMo, (AttrList)attrListImpl, "SCU", null, coordinator);
                this.createdMos.add(managedObject2);
                this.createEcPortXsd("1", "ManagedElement=1,Equipment=1,HwUnit=SCU", "NA", "0", coordinator);
                ReportLoggerHelper.getInstance().logAction("HwUnit", "create", new String[]{"LDN", "PiuType"}, new Object[]{"ManagedElement=1,Equipment=1,HwUnit=SCU", piuTypeAccess.getLocalDistinguishedName()});
            }
            catch (MoAccessException moAccessException) {
                throw new SupportSystemConfigurationFailedException(moCreateFailedSlogan, "Unable to create MO with LDN: ManagedElement=1,Equipment=1,HwUnit=SCU.", (Exception)((Object)moAccessException));
            }
        }
        logger.traceReturn(THIS_CLASS, "createScu() ManagedElement=1,Equipment=1,HwUnit=SCU");
    }

    protected void createSau(Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createSau()");
        ManagedObject managedObject = this.aMoRepository.lookup("ManagedElement=1,Equipment=1,HwUnit=SAU");
        if (managedObject == null) {
            PiuTypeAccess piuTypeAccess = PiuTypeFinder.findPiuType("SAU", this.aMoRepository, coordinator);
            if (piuTypeAccess == null) {
                throw new SupportSystemConfigurationFailedException("PiuType not found", "Unable to find a PiuType that matches the productname SAU.");
            }
            AttrListImpl attrListImpl = new AttrListImpl();
            attrListImpl.addElement("piuType", (Object)piuTypeAccess);
            try {
                ManagedObject managedObject2 = this.hwunitFactory.createMo(this.equipmentMo, (AttrList)attrListImpl, "SAU", null, coordinator);
                this.createdMos.add(managedObject2);
                this.createEcPortXsd("1", "ManagedElement=1,Equipment=1,HwUnit=SAU", "NA", "0", coordinator);
                ReportLoggerHelper.getInstance().logAction("HwUnit", "create", new String[]{"LDN", "PiuType"}, new Object[]{"ManagedElement=1,Equipment=1,HwUnit=SAU", piuTypeAccess.getLocalDistinguishedName()});
            }
            catch (MoAccessException moAccessException) {
                throw new SupportSystemConfigurationFailedException(moCreateFailedSlogan, "Unable to create MO with LDN: ManagedElement=1,Equipment=1,HwUnit=SAU.", (Exception)((Object)moAccessException));
            }
        }
        logger.traceReturn(THIS_CLASS, "createSau() ManagedElement=1,Equipment=1,HwUnit=SAU");
    }

    private void unlockHwUnits(Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "unlockHwUnits()");
        Iterator iterator = this.createdMos.iterator();
        while (iterator.hasNext()) {
            ManagedObject managedObject = (ManagedObject)iterator.next();
            try {
                managedObject.setAttribute("administrativeState", (Object)SupportSystemConfigurationDefinitions.ADMINISTRATIVE_STATE_UNLOCKED, coordinator);
                ReportLoggerHelper.getInstance().logAttribute(managedObject.getRelativeDistinguishedName(), "administrativeState", "UNLOCKED");
            }
            catch (MoAccessException moAccessException) {
                ReportLoggerHelper.getInstance().logFailure("Site Equipment", "Could not unlock the MO : " + managedObject.getLocalDistinguishedName() + ". Please unlock this manually later!");
            }
        }
        this.createdMos.clear();
        logger.traceReturn(THIS_CLASS, "unlockHwUnits()");
    }

    private boolean doesParentHaveChild(ManagedObject managedObject, String string) {
        logger.traceEnter(THIS_CLASS, "doesParentHaveChild() parent: " + managedObject.getLocalDistinguishedName() + " ChildType: " + string);
        boolean bl = false;
        MoIterator moIterator = managedObject.getChildren();
        while (moIterator.hasMoreElements()) {
            if (!string.equalsIgnoreCase(moIterator.nextMo().getType())) continue;
            bl = true;
            break;
        }
        logger.traceReturn(THIS_CLASS, "doesParentHaveChild() result: " + bl);
        return bl;
    }

    public void createEcPortsForPlugInUnits(PlugInUnitData[] plugInUnitDataArray, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createPlugInUnits()");
        for (int i = 0; i < plugInUnitDataArray.length; ++i) {
            EcPortConnectionData[] ecPortConnectionDataArray;
            String string = plugInUnitDataArray[i].unitId;
            String string2 = "ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1";
            if (string != null && string.endsWith("2")) {
                string2 = "ManagedElement=1,Equipment=1,Subrack=2,Slot=1,PlugInUnit=2";
            }
            if ((ecPortConnectionDataArray = plugInUnitDataArray[i].ecPortConnections) == null) continue;
            for (int j = 0; j < ecPortConnectionDataArray.length; ++j) {
                String string3 = ecPortConnectionDataArray[j].unitRef;
                this.createEcPortXsd(string3, string2, ecPortConnectionDataArray[j].hubPosition, ecPortConnectionDataArray[j].cascadingOrder, coordinator);
            }
        }
        logger.traceReturn(THIS_CLASS, "createPlugInUnits()");
    }

    public void createEcPortsForPlugInUnitsMultiCabinet(PlugInUnitData[] plugInUnitDataArray, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createEcPortsForPlugInUnitsMultiCabinet()");
        for (int i = 0; i < plugInUnitDataArray.length; ++i) {
            String string = plugInUnitDataArray[i].unitId;
            EcPortConnectionData[] ecPortConnectionDataArray = plugInUnitDataArray[i].ecPortConnections;
            if (ecPortConnectionDataArray == null) continue;
            for (int j = 0; j < ecPortConnectionDataArray.length; ++j) {
                String string2 = ecPortConnectionDataArray[j].unitRef;
                this.createEcPortXsdMultiCabinetForPlugInUnit(string2, string, ecPortConnectionDataArray[j].hubPosition, ecPortConnectionDataArray[j].cascadingOrder, ecPortConnectionDataArray[j].ecBusRef, coordinator);
            }
        }
        logger.traceReturn(THIS_CLASS, "createEcPortsForPlugInUnitsMultiCabinet()");
    }

    public void connectEcPorts(EcPortConnectionData[] ecPortConnectionDataArray, Coordinator coordinator, boolean bl) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "connectEcPorts()");
        if (ecPortConnectionDataArray != null) {
            for (int i = 0; i < ecPortConnectionDataArray.length; ++i) {
                this.connectEcPort(ecPortConnectionDataArray[i], coordinator, bl);
            }
        }
        logger.traceReturn(THIS_CLASS, "connectEcPorts()");
    }

    protected void connectEcPort(EcPortConnectionData ecPortConnectionData, Coordinator coordinator, boolean bl) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "connectEcPort() " + ecPortConnectionData.unitRef);
        String string = ecPortConnectionData.unitRef;
        ManagedObject managedObject = null;
        if ((string.startsWith("PSU") || string.startsWith("PDU") || string.startsWith("BFU")) && bl) {
            managedObject = this.aMoRepository.lookup("ManagedElement=1,Equipment=1,HwUnit=" + string + "," + "EcPort" + "=1");
        } else if (string.startsWith("DU")) {
            managedObject = this.findEcPortDu(string, coordinator);
        } else if (string.startsWith("EXT") && bl) {
            managedObject = this.connectEcPortExt(coordinator, string);
        }
        if (managedObject == null) {
            String string2 = "Unable to find EcPort for unitRef: " + string + ".";
            throw new SupportSystemConfigurationFailedException("MO not found", string2);
        }
        try {
            managedObject.setAttribute("hubPosition", (Object)ecPortConnectionData.hubPosition, coordinator);
            ReportLoggerHelper.getInstance().logAttributes("EcPort", new String[]{"LDN", "hubPosition"}, new Object[]{managedObject.getLocalDistinguishedName(), ecPortConnectionData.hubPosition});
        }
        catch (MoAccessException moAccessException) {
            logger.traceDebug(THIS_CLASS, "Not able to set attribute hubPosition(" + ecPortConnectionData.hubPosition + ") on unitRef: " + string);
        }
        logger.traceReturn(THIS_CLASS, "connectEcPort()" + managedObject.getLocalDistinguishedName());
    }

    protected ManagedObject findEcPortDu(String string, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "connectEcPortDu()");
        ManagedObject managedObject = null;
        if ("DU-1".equalsIgnoreCase(string)) {
            managedObject = this.aMoRepository.lookup("ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,EcPort=1");
            if (managedObject == null) {
                managedObject = this.createEcPort("1", "ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1", coordinator);
            }
        } else if ("DU-2".equalsIgnoreCase(string) && (managedObject = this.aMoRepository.lookup("ManagedElement=1,Equipment=1,Subrack=2,Slot=1,PlugInUnit=2,EcPort=1")) == null) {
            managedObject = this.createEcPort("1", "ManagedElement=1,Equipment=1,Subrack=2,Slot=1,PlugInUnit=2", coordinator);
        }
        logger.traceReturn(THIS_CLASS, "connectEcPortDu()");
        return managedObject;
    }

    protected ManagedObject createEcPort(String string, String string2, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createEcPort()");
        ManagedObject managedObject = null;
        MoFactory moFactory = this.aFactoryMgr.lookup("EcPort");
        ManagedObject managedObject2 = this.aMoRepository.lookup(string2);
        try {
            managedObject = moFactory.createMo(managedObject2, (AttrList)this.emptyAttrList, string, null, coordinator);
        }
        catch (MoAccessException moAccessException) {
            String string3 = "EcPort with id " + string + " under " + string2;
            throw new SupportSystemConfigurationFailedException("MO create failed", string3, (Exception)((Object)moAccessException));
        }
        logger.traceReturn(THIS_CLASS, "createEcPort()");
        return managedObject;
    }

    private ManagedObject connectEcPortExt(Coordinator coordinator, String string) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "connectEcPortExt()");
        ManagedObject managedObject = null;
        int n = string.indexOf(45);
        int n2 = string.lastIndexOf(45);
        String string2 = string.substring(n + 1, n2);
        String string3 = string.substring(n2 + 1);
        ManagedObject managedObject2 = this.aMoRepository.lookup("ManagedElement=1,Equipment=1,ExternalNode=" + string2);
        if (managedObject2 == null) {
            String string4 = "Unable to find ExternalNode with id: " + string2 + ".";
            throw new SupportSystemConfigurationFailedException("MO not found", string4);
        }
        MoFactory moFactory = this.aFactoryMgr.lookup("EcPort");
        managedObject = this.aMoRepository.lookup(managedObject2.getLocalDistinguishedName() + "," + "EcPort" + "=" + string3);
        if (managedObject == null) {
            try {
                managedObject = moFactory.createMo(managedObject2, (AttrList)this.emptyAttrList, string3, null, coordinator);
            }
            catch (MoAccessException moAccessException) {
                String string5 = "EcPort with id " + string3 + " under ExternalNode=" + string2 + " could not be created before setting hubPosition.";
                throw new SupportSystemConfigurationFailedException("MO create failed", string5, (Exception)((Object)moAccessException));
            }
        }
        logger.traceReturn(THIS_CLASS, "connectEcPortExt()");
        return managedObject;
    }

    public void connectExternalAlarmPorts(ExternalAlarmsData[] externalAlarmsDataArray, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "connectExternalAlarmPorts()");
        if (externalAlarmsDataArray != null) {
            for (int i = 0; i < externalAlarmsDataArray.length; ++i) {
                if (externalAlarmsDataArray[i].alarmPortData == null || externalAlarmsDataArray[i].unitId == null) continue;
                String string = "ManagedElement=1,Equipment=1,HwUnit=" + externalAlarmsDataArray[i].unitId;
                AlarmPortData[] alarmPortDataArray = externalAlarmsDataArray[i].alarmPortData;
                for (int j = 0; j < alarmPortDataArray.length; ++j) {
                    this.createAlarmPort(alarmPortDataArray[j], string, coordinator);
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "connectExternalAlarmPorts()");
    }

    public void connectRRUAlarmPorts(RadioEquipmentData[] radioEquipmentDataArray, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "connectRRUAlarmPorts()");
        if (radioEquipmentDataArray != null) {
            for (int i = 0; i < radioEquipmentDataArray.length; ++i) {
                if (radioEquipmentDataArray[i].radioUnits == null) continue;
                this.handleRadioUnits(radioEquipmentDataArray[i].radioUnits, coordinator);
            }
        } else {
            logger.traceDebug(THIS_CLASS, "No RadioEquipment found in XML file.");
        }
        logger.traceReturn(THIS_CLASS, "connectRRUAlarmPorts()");
    }

    public void handleRadioUnits(RadioUnitData[] radioUnitDataArray, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "handleRadioUnits()");
        if (radioUnitDataArray != null) {
            for (int i = 0; i < radioUnitDataArray.length; ++i) {
                ManagedObject managedObject;
                if (radioUnitDataArray[i].unitId == null || radioUnitDataArray[i].alarmPorts == null) continue;
                String string = "ManagedElement=1,Equipment=1,AuxPlugInUnit=" + radioUnitDataArray[i].unitId;
                String string2 = string + ",DeviceGroup=";
                String string3 = "";
                ManagedObject managedObject2 = this.aMoRepository.lookup(string);
                if (managedObject2 == null) {
                    managedObject = "Unable to find the AuxPlugInUnit" + string + ".";
                    throw new SupportSystemConfigurationFailedException("AuxPlugInUnit not found", (String)managedObject);
                }
                MoIterator moIterator = managedObject2.getChildren();
                if (moIterator == null) {
                    String string4 = "Unable to find child MOs under the AuxPlugInUnit" + string + ".";
                    throw new SupportSystemConfigurationFailedException("AuxPlugInUnit child MOs not found", string4);
                }
                while (moIterator.hasMoreElements()) {
                    managedObject = moIterator.nextMo();
                    String string5 = managedObject.getLocalDistinguishedName();
                    if (!string5.startsWith(string2)) continue;
                    string3 = string5;
                }
                if (string3 == "") {
                    String string6 = "Unable to find DeviceGroup MO under the AuxPlugInUnit" + string + ".";
                    throw new SupportSystemConfigurationFailedException("DeviceGroup MO not found", string6);
                }
                managedObject = radioUnitDataArray[i].alarmPorts;
                for (int j = 0; j < ((AlarmPortData[])managedObject).length; ++j) {
                    this.createAlarmPort(managedObject[j], string3, coordinator);
                }
            }
        } else {
            logger.traceDebug(THIS_CLASS, "No RadioUnit found in current RadioEquipment element in XML file.");
        }
        logger.traceReturn(THIS_CLASS, "handleRadioUnits()");
    }

    protected void setEquipmentSupportFunctionMo(ManagedObject managedObject) {
        this.equipmentSupportFunctionMo = managedObject;
    }

    private ManagedObject getPlugInUnitById(String string) throws SupportSystemConfigurationFailedException {
        String string2;
        PlugInUnitMo plugInUnitMo;
        MoIterator moIterator;
        logger.traceEnter(THIS_CLASS, "getPlugInUnitById()");
        PlugInUnitMo plugInUnitMo2 = null;
        if (string.startsWith("DU")) {
            moIterator = this.aMoRepository.lookupType("PlugInUnit");
            if (moIterator == null) {
                String string3 = "Failed to get DU: " + string;
                throw new SupportSystemConfigurationFailedException("Getting DU failure. ", string3);
            }
            while (moIterator.hasMoreElements()) {
                plugInUnitMo = (PlugInUnitMo)moIterator.nextMo();
                string2 = plugInUnitMo.getFullDistinguishedName();
                if (!this.makeId(string2).equalsIgnoreCase(this.makeId(string))) continue;
                plugInUnitMo2 = plugInUnitMo;
            }
        }
        if (string.startsWith("XMU")) {
            moIterator = this.aMoRepository.lookupType("AuxPlugInUnit");
            if (moIterator == null) {
                string2 = "Failed to get XMU: " + string;
                throw new SupportSystemConfigurationFailedException("Getting XMU failure. ", string2);
            }
            while (moIterator.hasMoreElements()) {
                plugInUnitMo = moIterator.nextMo();
                string2 = plugInUnitMo.getFullDistinguishedName();
                if (!this.makeId(string2).equalsIgnoreCase(this.makeId(string))) continue;
                plugInUnitMo2 = plugInUnitMo;
            }
        }
        logger.traceReturn(THIS_CLASS, "getPlugInUnitById()");
        return plugInUnitMo2;
    }

    private String makeId(String string) {
        return string.substring(string.length() - 1);
    }

    public void updateHwUnitsCabinetReference(String string, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "updateHwUnitsCabinetReference()");
        if (string == null) {
            throw new SupportSystemConfigurationFailedException("Cabinet MO. ", "Reference to cabinet is null.");
        }
        ManagedObject managedObject = this.aMoRepository.lookup("ManagedElement=1,Equipment=1,Cabinet=" + this.makeId(string));
        if (managedObject == null) {
            throw new SupportSystemConfigurationFailedException("Cabinet MO.", "Could not find cabinet MO.");
        }
        MoIterator moIterator = this.aMoRepository.lookupType("HwUnit");
        if (moIterator == null) {
            logger.traceDebug(THIS_CLASS, "hwUnits == null");
        } else {
            try {
                while (moIterator.hasMoreElements()) {
                    ManagedObject managedObject2 = moIterator.nextMo();
                    managedObject2.setAttribute("positionRef", (Object)managedObject, coordinator);
                }
            }
            catch (Exception exception) {
                throw new SupportSystemConfigurationFailedException("HwUnit MO.", "Failed to set positionRef attribute");
            }
        }
        logger.traceReturn(THIS_CLASS, "updateHwUnitsCabinetReference()");
    }

    public void updateHwUnitsCabinetReferenceWithCascadinOrder(SupportSystemData supportSystemData, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "updateHwUnitsCabinetReferenceWithCascadinOrder()");
        for (int i = 0; i < supportSystemData.hwUnits.length; ++i) {
            String string = supportSystemData.hwUnits[i].ecPortConnections[0].cascadingOrder;
            if (string == null || string.equalsIgnoreCase("0")) {
                throw new SupportSystemConfigurationFailedException("HwUnit MO. ", "Cascading order is null or 0.");
            }
            ManagedObject managedObject = this.aMoRepository.lookup("ManagedElement=1,Equipment=1,Cabinet=" + this.makeId(string));
            if (managedObject == null) {
                throw new SupportSystemConfigurationFailedException("Cabinet MO.", "Could not find cabinet MO.");
            }
            ManagedObject managedObject2 = this.aMoRepository.lookup("ManagedElement=1,Equipment=1,HwUnit=" + supportSystemData.hwUnits[i].unitType);
            if (managedObject2 == null) {
                throw new SupportSystemConfigurationFailedException("HwUnit MO.", "Could not find hwUnit MO.");
            }
            try {
                managedObject2.setAttribute("positionRef", (Object)managedObject, coordinator);
                continue;
            }
            catch (Exception exception) {
                throw new SupportSystemConfigurationFailedException("HwUnit MO.", "Failed to set positionRef attribute");
            }
        }
        logger.traceReturn(THIS_CLASS, "updateHwUnitsCabinetReferenceWithCascadinOrder()");
    }

    public void updatePowerSystemCabinetReference(String string, Coordinator coordinator) throws SupportSystemConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "updatePowerSystemCabinetReference()");
        if (string == null) {
            throw new SupportSystemConfigurationFailedException("Cabinet MO. ", "Reference to cabinet is null.");
        }
        ManagedObject managedObject = this.aMoRepository.lookup("ManagedElement=1,Equipment=1,Cabinet=" + this.makeId(string));
        if (managedObject == null) {
            throw new SupportSystemConfigurationFailedException("Cabinet MO.", "Could not find cabinet MO.");
        }
        ManagedObject managedObject2 = this.aMoRepository.lookup("ManagedElement=1,EquipmentSupportFunction=1,PowerSupply=1");
        if (managedObject2 == null) {
            logger.traceDebug(THIS_CLASS, "PowerSupply MO. Could not find powerSupply MO.");
        } else {
            try {
                managedObject2.setAttribute("controlDomainRef", (Object)new ManagedObject[]{managedObject}, coordinator);
            }
            catch (Exception exception) {
                throw new SupportSystemConfigurationFailedException("PowerSupply MO.", "Failed to set controlDomainRef attribute.");
            }
        }
        ManagedObject managedObject3 = this.aMoRepository.lookup("ManagedElement=1,EquipmentSupportFunction=1,PowerDistribution=1");
        if (managedObject3 == null) {
            logger.traceDebug(THIS_CLASS, "PowerDistribution MO. Could not find powerDistribution MO.");
        } else {
            try {
                managedObject3.setAttribute("controlDomainRef", (Object)new ManagedObject[]{managedObject}, coordinator);
            }
            catch (Exception exception) {
                throw new SupportSystemConfigurationFailedException("PowerSupply MO.", "Failed to set controlDomainRef attribute.");
            }
        }
        ManagedObject managedObject4 = this.aMoRepository.lookup("ManagedElement=1,EquipmentSupportFunction=1,BatteryBackup=1");
        if (managedObject4 == null) {
            logger.traceDebug(THIS_CLASS, "BatteryBackup MO. Could not find batteryBackup MO.");
        } else {
            try {
                managedObject4.setAttribute("controlDomainRef", (Object)new ManagedObject[]{managedObject}, coordinator);
            }
            catch (Exception exception) {
                throw new SupportSystemConfigurationFailedException("PowerSupply MO.", "Failed to set controlDomainRef attribute.");
            }
        }
        logger.traceReturn(THIS_CLASS, "updatePowerSystemCabinetReference()");
    }
}

