/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.extethswitch;

import se.ericsson.cello.extethswitch.ExtethswitchUtil;
import se.ericsson.cello.extethswitch.VlanMo;
import se.ericsson.cello.extethswitch.VlanMoGen;
import se.ericsson.cello.extethswitch.VlanPortMo;
import se.ericsson.cello.iptransport.VlanBuildIF;
import se.ericsson.cello.mao.AttrValueNotUniqueException;
import se.ericsson.cello.mao.ConcurrentTransactionHandler;
import se.ericsson.cello.mao.IdentityNotAllowedException;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.MoCanNotBeDeletedException;
import se.ericsson.cello.mao.MoNotPossibleToReserveException;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.mao.TransactionHandler;
import se.ericsson.cello.mao.TransactionalFroIdMap;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFilter;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMo;

public class VlanMoImpl
extends VlanMoGen
implements VlanBuildIF {
    private static TransactionalFroIdMap froIds = new TransactionalFroIdMap((TransactionHandler)new ConcurrentTransactionHandler());
    public static final String RESERVED_MOLDN = "ManagedElement=1,EthernetSwitchFabric=1,Vlan=BACKPLANE_PORT_SUPERVISION";

    public VlanMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, initialMaoContext, attrList);
        froIds.put(((IntegerAttribute)this.data.getAttribute("vlanFroId")).getValue(null), (ManagedObject)this);
    }

    public VlanMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy) throws MoNameAlreadyTakenException {
        super(moData, initialMaoContext, froProxy);
        froIds.put(((IntegerAttribute)this.data.getAttribute("vlanFroId")).getValue(null), (ManagedObject)this);
    }

    protected void onDelete(Coordinator coordinator) throws MoAccessException {
        if (this.getLocalDistinguishedName().equals(RESERVED_MOLDN)) {
            throw new MoCanNotBeDeletedException("Vlan=BACKPLANE_PORT_SUPERVISION cannot be deleted manually.");
        }
        froIds.remove(this.getFroId(coordinator), coordinator);
    }

    public static VlanMoImpl lookupInstance(int n, Coordinator coordinator) throws TransactionRequiredException {
        return (VlanMoImpl)froIds.get(n, coordinator);
    }

    protected void validateVid(int n, SetRequestContext setRequestContext) throws MoAccessException {
        int n2;
        super.validateVid(n, setRequestContext);
        if ((n == 1 || n == 4094) && (n2 = ExtethswitchUtil.isHSC_CMXB(this.getParent(), setRequestContext.getCoordinator())) == 0) {
            throw new IllegalAttributeValueException("vid", "Vlan MO with Vid  as 1 or 4094 on boards other than HSC is not allowed. ", "Vlan");
        }
        n2 = 0;
        try {
            if (setRequestContext.isIncludedInRequest("vlanType")) {
                n2 = (Integer)setRequestContext.getAttributeFromRequest("vlanType");
            }
        }
        catch (ClassCastException classCastException) {
            throw new WrongAttributeTypeException("vlanType", "Vlan");
        }
        if (n2 != 4) {
            MoFilter moFilter = new MoFilter(){

                public boolean accept(ManagedObject managedObject) {
                    return managedObject instanceof VlanMo || managedObject instanceof VlanPortMo;
                }
            };
            MoIterator moIterator = MoRepository.instance().select(MibMgr.instance().getMib().getRootMo(), -1, moFilter);
            this.checkIntUniqueness(n, "vid", moIterator, setRequestContext.getCoordinator());
        }
    }

    protected void onCreate(SetRequestContext setRequestContext) throws MoAccessException {
        int n = 0;
        if (setRequestContext.isIncludedInRequest("vlanType")) {
            n = (Integer)setRequestContext.getAttributeFromRequest("vlanType");
        }
        if (n == 4 && !this.getLocalDistinguishedName().equals(RESERVED_MOLDN)) {
            throw new MoCanNotBeCreatedException("Vlan MO with VlanType as BACKPLANE_PORT_SUPERVISION cannot be created manually.");
        }
        if (this.getLocalDistinguishedName().equals(RESERVED_MOLDN) && n != 4) {
            throw new MoCanNotBeCreatedException("Vlan=BACKPLANE_PORT_SUPERVISION must not be created with wrong vlanType .");
        }
    }

    protected void validateVlanType(int n, SetRequestContext setRequestContext) throws MoAccessException {
        super.validateVlanType(n, setRequestContext);
        if (n == 2 || n == 1) {
            MoIterator moIterator = MoRepository.instance().lookupType("Vlan");
            this.checkIntUniqueness(n, "vlanType", moIterator, setRequestContext.getCoordinator());
        }
    }

    private void checkIntUniqueness(int n, String string, MoIterator moIterator, Coordinator coordinator) throws MoAccessException {
        if (moIterator == null) {
            return;
        }
        while (moIterator.hasMoreElements()) {
            int n2;
            ManagedObject managedObject = moIterator.nextMo();
            if (managedObject == this || n != (n2 = ((Integer)managedObject.getAttribute(string, coordinator)).intValue())) continue;
            throw new AttrValueNotUniqueException(string + " has a duplicated value which is not allowed", "Vlan");
        }
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if (this.getLocalDistinguishedName().equals(RESERVED_MOLDN)) {
            throw new MoNotPossibleToReserveException("Vlan=BACKPLANE_PORT_SUPERVISION MO can not be reserved by other MOs.", this.getType());
        }
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public static ManagedObject checkBspVlanCreation(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy) throws MoAccessException {
        boolean bl = true;
        MoIterator moIterator = MoRepository.instance().lookupType("UpgradePackage");
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                UpgradePackageMo upgradePackageMo = (UpgradePackageMo)moIterator.nextElement();
                int n = upgradePackageMo.getState(coordinator);
                if (n != 7) continue;
                bl = false;
                break;
            }
        }
        if (bl) {
            return new VlanMoImpl(managedObject, attrList, string, coordinator, initialMaoContext, froProxy);
        }
        throw new IdentityNotAllowedException("Vlan=BACKPLANE_PORT_SUPERVISION cannot be created manually.");
    }
}

