/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.swe.view.gui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import se.ericsson.cello.emt.userpreferences.UserPreferencesI;
import se.ericsson.cello.swe.view.gui.TimeConverter;

public class ColumnHeaderListener
extends MouseAdapter {
    protected static final String COLUMNWIDTH_PREFERENCE_KEY = "cpp_swembed_columnwidth_";
    protected static final String COLUMNSORTINDEX_PREFERENCE_KEY = "cpp_swembed_sortColumn_index_";
    protected static final String COLUMNSORTASCDEC_PREFERENCE_KEY = "cpp_swembed_sortColumn_ascDec_";
    private TimeConverter myTimeConverter = new TimeConverter();
    private boolean ascending = true;
    private int columnIndex = 0;
    private UserPreferencesI userPrefs;

    public ColumnHeaderListener(UserPreferencesI userPreferences, JTable table) {
        this.userPrefs = userPreferences;
        this.ascending = Boolean.parseBoolean(this.userPrefs.getPreference(COLUMNSORTASCDEC_PREFERENCE_KEY + table.getName(), "true"));
        this.columnIndex = Integer.parseInt(this.userPrefs.getPreference(COLUMNSORTINDEX_PREFERENCE_KEY + table.getName(), "0"));
    }

    public void mouseReleased(MouseEvent event) {
        JTable table = ((JTableHeader)event.getSource()).getTable();
        this.saveColumnSizes(table);
    }

    public void mouseClicked(MouseEvent evt) {
        JTable table = ((JTableHeader)evt.getSource()).getTable();
        TableColumnModel colModel = table.getColumnModel();
        int vColIndex = colModel.getColumnIndexAtX(evt.getX());
        if (vColIndex == -1) {
            return;
        }
        this.columnIndex = vColIndex;
        this.ascending = !this.ascending;
        this.sortAllRowsBy((DefaultTableModel)table.getModel());
        this.userPrefs.setPreference(COLUMNSORTINDEX_PREFERENCE_KEY + table.getName(), String.valueOf(vColIndex));
        this.userPrefs.setPreference(COLUMNSORTASCDEC_PREFERENCE_KEY + table.getName(), String.valueOf(Boolean.valueOf(this.ascending).toString()));
    }

    public void sortAllRowsBy(DefaultTableModel model) {
        Collections.sort(model.getDataVector(), new ColumnSorter(this.columnIndex, this.ascending));
        model.fireTableStructureChanged();
    }

    private void saveColumnSizes(JTable table) {
        if (null != this.userPrefs) {
            int length = table.getColumnCount();
            for (int i = 0; i < length; ++i) {
                int width = table.getColumn(table.getColumnName(i)).getWidth();
                this.userPrefs.setPreference(COLUMNWIDTH_PREFERENCE_KEY + table.getName() + table.getColumnName(i) + "_", String.valueOf(width));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ColumnSorter
    implements Comparator<Object> {
        int colIndex;
        boolean ascending;

        ColumnSorter(int colIndex, boolean ascending) {
            this.colIndex = colIndex;
            this.ascending = ascending;
        }

        @Override
        public int compare(Object a, Object b) {
            Vector v1 = (Vector)a;
            Vector v2 = (Vector)b;
            Object o1 = v1.get(this.colIndex);
            Object o2 = v2.get(this.colIndex);
            if (o1 instanceof String && ((String)o1).length() == 0) {
                o1 = null;
            }
            if (o2 instanceof String && ((String)o2).length() == 0) {
                o2 = null;
            }
            Integer t1 = null;
            Integer t2 = null;
            if (o1 != null && o2 != null) {
                try {
                    t1 = new Integer(o1.toString());
                    t2 = new Integer(o2.toString());
                    o1 = t1;
                    o2 = t2;
                }
                catch (NumberFormatException e) {
                    t1 = null;
                    t2 = null;
                }
            }
            Date d1 = null;
            Date d2 = null;
            if (o1 != null && o2 != null && (t1 == null || t2 == null)) {
                d1 = ColumnHeaderListener.this.myTimeConverter.formatTime(o1.toString());
                d2 = ColumnHeaderListener.this.myTimeConverter.formatTime(o2.toString());
                if (d1 != null && d2 != null) {
                    o1 = d1;
                    o2 = d2;
                }
            }
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1 instanceof Comparable) {
                if (o1 instanceof String) {
                    o1 = o1.toString().toLowerCase();
                    o2 = o2.toString().toLowerCase();
                }
                if (this.ascending) {
                    return ((Comparable)o1).compareTo(o2);
                }
                return ((Comparable)o2).compareTo(o1);
            }
            if (this.ascending) {
                return o1.toString().compareTo(o2.toString());
            }
            return o2.toString().compareTo(o1.toString());
        }
    }
}

