/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.actions;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import se.ericsson.cello.neal.cm.CmService;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.ActionPropertyKeyTypes;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.Operable;

public abstract class CabinetViewerAction
extends AbstractAction
implements ActionPropertyKeyTypes {
    protected Operable operable = null;
    protected String viewableObjectName = null;
    protected String actionName = null;
    protected String actionPropertyName = null;
    protected String actionNameInMom = null;
    protected CmService cmService = null;
    protected JDialog dialog = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private ActionListener okListener = null;
    private ActionListener cancelListener = null;

    public CabinetViewerAction(Operable operable, String string, String string2) {
        super(string);
        this.actionName = string;
        this.actionPropertyName = string2;
        this.init(operable);
    }

    public CabinetViewerAction(String string, String string2) {
        super(string);
        this.actionName = string;
        this.actionPropertyName = string2;
    }

    public void setOperable(Operable operable) {
        this.init(operable);
    }

    public String getActionName() {
        return this.actionName;
    }

    protected String getActionNameInMom() {
        return this.actionNameInMom;
    }

    public void cleanUp() {
        if (this.okButton != null) {
            this.okButton.removeActionListener(this.okListener);
        }
        if (this.cancelButton != null) {
            this.cancelButton.removeActionListener(this.cancelListener);
        }
    }

    private void init(Operable operable) {
        this.operable = operable;
        this.viewableObjectName = operable.getViewableObjectName();
        this.cmService = operable.getCvSession().getNealManager().getCmService();
        Object object = operable.getMoPropertyValue(this.actionPropertyName);
        if (object != null && object instanceof List) {
            Object e = ((List)object).get(0);
            this.actionNameInMom = e.toString();
        }
    }

    protected Operable getOperable() {
        return this.operable;
    }

    protected String getViewableObjectName() {
        return this.viewableObjectName;
    }

    protected CmService getCmService() {
        return this.cmService;
    }

    protected abstract void performTheAction();

    protected abstract String getText();

    protected abstract void addOptions(JPanel var1, GridBagConstraints var2);

    protected void displayGui(String string) {
        this.dialog = new JDialog();
        this.dialog.setModal(true);
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setTitle(string);
        this.dialog.setResizable(false);
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.getContentPane().add((Component)this.assembleGui(), "Center");
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(null);
        this.dialog.setVisible(true);
    }

    protected JPanel assembleGui() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.addText(jPanel, gridBagConstraints);
        this.addOptions(jPanel, gridBagConstraints);
        this.addButtons(jPanel, gridBagConstraints);
        return jPanel;
    }

    protected void addText(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        JLabel jLabel = new JLabel(this.getText());
        jLabel.setForeground(Color.black);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)jLabel, gridBagConstraints);
    }

    protected void addButtons(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        this.okButton = new JButton("OK");
        this.cancelButton = new JButton("Cancel");
        Dimension dimension = new Dimension(80, 30);
        this.okButton.setPreferredSize(dimension);
        this.cancelButton.setPreferredSize(dimension);
        this.okListener = new OkListener();
        this.okButton.addActionListener(this.okListener);
        this.cancelListener = new CancelListener();
        this.cancelButton.addActionListener(this.cancelListener);
        jPanel2.add(this.okButton);
        jPanel2.add(this.cancelButton);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = -1;
        jPanel.add((Component)jPanel2, gridBagConstraints);
    }

    protected void showConnectionError(Exception exception) {
        Trace.error(this, this.getActionName() + " failed due to connection problems. " + exception);
        this.operable.getCvSession().getCvSessionController().showErrorDialog(this.getActionName() + " failed due to connection problems. ", exception);
    }

    protected void showOperationError(Exception exception) {
        Trace.error(this, this.getActionName() + " failed. " + exception);
        this.operable.getCvSession().getCvSessionController().showErrorDialog(this.getActionName() + " failed. ", exception);
    }

    protected void showError(String string, Exception exception) {
        Trace.error(this, string, exception);
        this.operable.getCvSession().getCvSessionController().showErrorDialog(string, exception);
    }

    protected String getTechnicianPresentMessage(String string) {
        return "Cannot perform " + string + " while field technician is present.\n" + "To " + string + " " + this.getViewableObjectName() + ", " + "technician present indication must first be cleared.\n" + "Please verify that field technician is not on RBS site.\n";
    }

    private boolean containsExactMatch(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            String string4 = string3.substring(0, string3.indexOf("="));
            if (!string4.equals(string2)) continue;
            return true;
        }
        return false;
    }

    protected boolean isConfirmTechnicianPresent(String string) {
        Mo[] moArray;
        if (!this.containsExactMatch(string, "PlugInUnit") && !this.containsExactMatch(string, "AuxPlugInUnit")) {
            return false;
        }
        CmService cmService = this.getCmService();
        Mo mo = cmService.getRootMo();
        for (Mo mo2 : moArray = mo.getChildren(null)) {
            if (!mo2.getType().equals("NodeBFunction")) continue;
            NameValue nameValue = mo2.getAttribute("supportSystemAvailable", null);
            if (!nameValue.getBooleanValue()) {
                return false;
            }
            NameValue nameValue2 = mo2.getAttribute("technicianPresent", null);
            return nameValue2.getBooleanValue();
        }
        return false;
    }

    protected void showErrorFromThread(final String string, final Exception exception) {
        try {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        CabinetViewerAction.this.showError(string, exception);
                    }
                });
            } else {
                this.showError(string, exception);
            }
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    protected boolean isStartWithoutGui() {
        return System.getProperty("START_CABV_WITHOUT_GUI") != null;
    }

    class CancelListener
    implements ActionListener {
        CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CabinetViewerAction.this.dialog.dispose();
        }
    }

    class OkListener
    implements ActionListener {
        OkListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = true;
            if (bl) {
                CabinetViewerAction.this.dialog.dispose();
                CabinetViewerAction.this.performTheAction();
            }
        }
    }
}

