/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.actions;

import java.awt.event.ActionEvent;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.CabinetViewerAction;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.Operable;
import se.ericsson.wcdma.rbs.cabinetviewer.mim.CabinetViewerMimModel;

public abstract class Restart
extends CabinetViewerAction {
    public static final String ACTION_DISPLAY_NAME_RESTART = "Restart";
    protected Mo mo = null;
    protected String ldn = null;

    public Restart(Operable operable) {
        super(operable, ACTION_DISPLAY_NAME_RESTART, "KEY_RESTARTABLE");
        this.init();
    }

    public Restart(Operable operable, String string) {
        super(operable, ACTION_DISPLAY_NAME_RESTART, "KEY_RESTARTABLE");
        this.ldn = string;
        this.mo = this.cmService.getMo(this.ldn);
    }

    public Restart() {
        super(ACTION_DISPLAY_NAME_RESTART, "KEY_RESTARTABLE");
    }

    @Override
    public void setOperable(Operable operable) {
        super.setOperable(operable);
        this.init();
    }

    private void init() {
        this.ldn = this.operable.getTargetMoLdnForRestart();
        if (this.ldn != null) {
            this.mo = this.cmService.getMo(this.ldn);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.displayGui(ACTION_DISPLAY_NAME_RESTART);
    }

    protected String getLdn() {
        return this.ldn;
    }

    protected Mo getMo() {
        return this.mo;
    }

    protected void refresh() {
        new RefreshThread().start();
    }

    private class RefreshThread
    extends Thread {
        private static final int MAX_CHECKS = 13;
        private static final int SLEEP_TIME = 2000;

        private RefreshThread() {
        }

        @Override
        public void run() {
            this.waitForRestart();
            Restart.this.operable.refresh();
        }

        private void waitForRestart() {
            NameValue nameValue = null;
            boolean bl = false;
            for (int i = 0; i < 13; ++i) {
                try {
                    CabinetViewerMimModel cabinetViewerMimModel = Restart.this.operable.getCvSession().getVibManager().getVimModel().getMimModel();
                    if (cabinetViewerMimModel.isAttributeExisting(Restart.this.mo.getType(), "redLed")) {
                        nameValue = Restart.this.mo.getAttribute("redLed", null);
                        if (nameValue.getIntValue() != 1) {
                            bl = true;
                        }
                    } else {
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    Trace.warning(this, "Wait for restart check produced: " + exception);
                }
                if (bl) {
                    Trace.observation(this, "Finished waiting for board ldn: " + Restart.this.ldn);
                    return;
                }
                try {
                    Trace.observation(this, "Waiting for board to restart: " + Restart.this.ldn);
                    Thread.sleep(2000L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Trace.warning(this, "Restart wait time-out. Ordering refresh: " + Restart.this.ldn);
        }
    }
}

