/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.NodeRefresh;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.StopRefresh;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.LedRepaintListener;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.LedRepaintThread;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.PhysicalViewController;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.StateOrLedPanel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VoView;
import se.ericsson.wcdma.rbs.cabinetviewer.guitestsupport.GuiTestEventTypes;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoData;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoDataListener;

public class PhysicalView
extends JPanel
implements VoDataListener {
    private Container contentPane;
    private Container sectorPane;
    private List sectorPaneList = new ArrayList();
    public boolean isProferSize = true;
    private final double SECTOR_CONTAINER_PROPERSIZE = 508.0;
    private int row = 0;
    private int cols = 0;
    private PhysicalViewController controller;
    final PhysicalViewMouseListener listener;
    final LedRepaintThread ledRepaintThread;

    public PhysicalView(PhysicalViewController physicalViewController) {
        this.controller = physicalViewController;
        this.buildView();
        this.listener = new PhysicalViewMouseListener();
        this.addMouseListener(this.listener);
        this.ledRepaintThread = new LedRepaintThread();
    }

    public void buildView() {
        this.setLayout(new BorderLayout());
        this.contentPane = new JPanel();
        this.contentPane.setBackground(Color.white);
        this.contentPane.setLayout(new GridBagLayout());
        this.sectorPane = new JPanel();
        this.sectorPane.setLayout(new GridBagLayout());
        this.sectorPane.setBackground(Color.white);
        super.add((Component)this.contentPane, "Center");
    }

    @Override
    public Component add(Component component) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = this.row++;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.contentPane.add(component, gridBagConstraints);
        return component;
    }

    @Override
    public void add(Component component, Object object) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = this.row++;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.contentPane.add(component, gridBagConstraints);
    }

    public void addSectorContainer(Component component, Object object, double d) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 10;
        gridBagConstraints.gridy = this.row;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.gridx = this.cols++;
        if (d > 508.0) {
            this.sectorPaneList.add(this.sectorPane);
            this.sectorPane = new JPanel();
            this.sectorPane.setLayout(new GridBagLayout());
            this.sectorPane.setBackground(Color.white);
            ++gridBagConstraints.gridy;
            this.row = gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            this.cols = 1;
            this.sectorPane.add(component, gridBagConstraints);
            this.isProferSize = false;
        } else {
            this.sectorPane.add(component, gridBagConstraints);
        }
    }

    public void showSectorContainer() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 10;
        gridBagConstraints.gridy = this.row;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.sectorPaneList.add(this.sectorPane);
        for (int i = 0; i < this.sectorPaneList.size(); ++i) {
            if (this.sectorPaneList.get(i) != null) {
                this.contentPane.add((Component)((Container)this.sectorPaneList.get(i)), gridBagConstraints);
            }
            gridBagConstraints.gridy = ++this.row;
        }
    }

    public PhysicalViewController getController() {
        return this.controller;
    }

    public void setStateViewActive() {
        List<VoView> list = this.getVoViews(this.contentPane);
        for (VoView voView : list) {
            voView.setStateViewActive();
        }
        this.ledRepaintThread.halt();
        if (System.getProperty("AUT_GUI_TESTS_RUNNING", "false").equals("true")) {
            this.controller.getTopVo().getCvSession().getCvSessionController().sendNotification(GuiTestEventTypes.STATE_VIEW_SELECTED, "State view is selected");
        }
    }

    public void setLedViewActive() {
        List<VoView> list = this.getVoViews(this.contentPane);
        for (VoView voView : list) {
            voView.setLedViewActive();
            VoData voData = voView.getVoData();
            if (voData == null || !(voView instanceof StateOrLedPanel)) continue;
            voData.addVoDataListener(this);
        }
        List<LedRepaintListener> list2 = this.getLeds(this.contentPane);
        this.ledRepaintThread.subscribeRepaintItem(list2);
        if (!this.ledRepaintThread.isAlive()) {
            this.ledRepaintThread.start();
        }
        this.ledRepaintThread.go();
        if (System.getProperty("AUT_GUI_TESTS_RUNNING", "false").equals("true")) {
            this.controller.getTopVo().getCvSession().getCvSessionController().sendNotification(GuiTestEventTypes.LED_VIEW_SELECTED, "LED view is selected");
        }
    }

    @Override
    public void voDataChanged(VoData voData, int n) {
        List<LedRepaintListener> list = this.getLeds(this.contentPane);
        this.ledRepaintThread.subscribeRepaintItem(list);
    }

    public List<VoView> getVoViews(Container container) {
        ArrayList<VoView> arrayList = new ArrayList<VoView>();
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] instanceof VoView) {
                arrayList.add((VoView)componentArray[i]);
                if (!(componentArray[i] instanceof Container)) continue;
                arrayList.addAll(this.getVoViews((Container)componentArray[i]));
                continue;
            }
            if (!(componentArray[i] instanceof Container)) continue;
            arrayList.addAll(this.getVoViews((Container)componentArray[i]));
        }
        return arrayList;
    }

    public void cleanUp() {
        this.controller = null;
        this.removeMouseListener(this.listener);
        Component[] componentArray = this.contentPane.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof VoView)) continue;
            VoView voView = (VoView)componentArray[i];
            voView.cleanUp();
        }
        this.ledRepaintThread.dispose();
    }

    public void setProferSizeFlag(boolean bl) {
        this.isProferSize = bl;
    }

    public boolean isProferSize() {
        return this.isProferSize;
    }

    private List<LedRepaintListener> getLeds(Container container) {
        ArrayList<LedRepaintListener> arrayList = new ArrayList<LedRepaintListener>();
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] instanceof LedRepaintListener) {
                arrayList.add((LedRepaintListener)((Object)componentArray[i]));
                continue;
            }
            if (!(componentArray[i] instanceof Container)) continue;
            arrayList.addAll(this.getLeds((Container)componentArray[i]));
        }
        return arrayList;
    }

    public void setStopRefreshEnabled(boolean bl) {
        this.listener.setNodeStopRefreshEnabled(bl);
    }

    class PhysicalViewMouseListener
    extends MouseAdapter {
        final JPopupMenu popUpMenu = new JPopupMenu();
        final StopRefresh stopRefresh;

        public PhysicalViewMouseListener() {
            this.popUpMenu.add(new NodeRefresh(PhysicalView.this));
            this.stopRefresh = new StopRefresh(PhysicalView.this.controller);
            this.popUpMenu.add(this.stopRefresh);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.isPopUpTrigger(mouseEvent)) {
                this.popUp(mouseEvent);
            }
        }

        public void setNodeStopRefreshEnabled(boolean bl) {
            this.stopRefresh.setEnabled(bl);
        }

        public boolean isPopUpTrigger(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                return true;
            }
            int n = mouseEvent.getModifiers();
            return n == 4;
        }

        public void popUp(MouseEvent mouseEvent) {
            this.popUpMenu.show(PhysicalView.this, mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

