/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.Selectable;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VoSelectionListener;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.VoSelectionManager;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.ViewableObject;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoData;

public class PhysicalViewController
implements VoSelectionManager {
    final Hashtable voToComponent = new Hashtable();
    final Hashtable componentToVo = new Hashtable();
    private VoData selectedVo = null;
    private Selectable selectedComponent;
    private ArrayList listerners = new ArrayList();
    private ViewableObject topVo = null;

    public void add(ViewableObject viewableObject, Selectable selectable) {
        if (this.topVo == null) {
            this.topVo = viewableObject;
        }
        this.voToComponent.put(viewableObject, selectable);
        this.componentToVo.put(selectable, viewableObject);
        selectable.setSelectionManager(this);
    }

    public ViewableObject getTopVo() {
        return this.topVo;
    }

    public void fireSelectionChanged(Selectable selectable, VoData voData) {
        for (VoSelectionListener voSelectionListener : this.listerners) {
            voSelectionListener.selectionChanged(voData);
        }
    }

    @Override
    public boolean isSelected(VoData voData) {
        return this.selectedVo.equals(voData);
    }

    @Override
    public void setSelection(VoData voData) {
        Selectable selectable;
        VoData voData2 = voData;
        if (this.selectedVo != null && this.selectedVo.equals(voData2)) {
            return;
        }
        if (voData2 == null) {
            if (this.selectedVo != null) {
                return;
            }
            voData2 = this.findCabinetRbsVo();
        }
        if ((selectable = (Selectable)this.voToComponent.get(voData2)) != null) {
            if (this.selectedComponent != null) {
                this.selectedComponent.deSelect();
            }
            selectable.select();
            this.fireSelectionChanged(selectable, voData2);
            this.selectedComponent = selectable;
            this.selectedVo = voData2;
        }
    }

    public ViewableObject findCabinetRbsVo() {
        Enumeration enumeration = this.componentToVo.elements();
        ArrayList<ViewableObject> arrayList = new ArrayList<ViewableObject>();
        Comparator<ViewableObject> comparator = new Comparator<ViewableObject>(){

            @Override
            public int compare(ViewableObject viewableObject, ViewableObject viewableObject2) {
                String string;
                String string2 = viewableObject.getPrefix();
                if (string2.compareTo(string = viewableObject2.getPrefix()) > 0) {
                    return 1;
                }
                if (string2.compareTo(string) < 0) {
                    return -1;
                }
                return 0;
            }
        };
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            ViewableObject viewableObject = (ViewableObject)v;
            String string = viewableObject.getGeneralType();
            String string2 = viewableObject.getSpecificType();
            if (!string.equals("Cabinet") || !string2.equals("RBS")) continue;
            arrayList.add(viewableObject);
        }
        if (!arrayList.isEmpty()) {
            if (arrayList.size() > 1) {
                Collections.sort(arrayList, comparator);
            }
            this.topVo = (ViewableObject)arrayList.get(0);
        }
        return this.topVo;
    }

    @Override
    public void clearSelection() {
    }

    @Override
    public void addVoSelectionListener(VoSelectionListener voSelectionListener) {
        this.listerners.add(voSelectionListener);
    }

    @Override
    public void removeVoSelectionListener(VoSelectionListener voSelectionListener) {
        this.listerners.remove(voSelectionListener);
    }

    @Override
    public void removeAllListeners() {
        this.listerners = new ArrayList();
    }
}

