/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels;

import java.util.ArrayList;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.AttributeExtractor;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoData;

public class AllAttributesExtractor
implements AttributeExtractor {
    final AttributeExtractor[] extractors;

    public AllAttributesExtractor(AttributeExtractor[] attributeExtractorArray) {
        this.extractors = attributeExtractorArray;
    }

    @Override
    public void setVo(VoData voData) {
        for (int i = 0; i < this.extractors.length; ++i) {
            this.extractors[i].setVo(voData);
        }
    }

    @Override
    public String getKey() {
        return this.getAttributeName();
    }

    @Override
    public String[] getKeys() {
        return this.getAttributeNames();
    }

    @Override
    public Object get() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.extractors.length; ++i) {
            arrayList.add(this.extractors[i].get());
        }
        return arrayList.toArray();
    }

    @Override
    public boolean isExisting() {
        int n = 0;
        for (int i = 0; i < this.extractors.length; ++i) {
            if (!this.extractors[i].isExisting()) continue;
            ++n;
        }
        return n == this.extractors.length;
    }

    @Override
    public String getAttributeName() {
        return this.extractors[0].getAttributeName();
    }

    @Override
    public String[] getAttributeNames() {
        String[] stringArray = new String[this.extractors.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.extractors[i].getAttributeName();
        }
        return stringArray;
    }
}

