/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.mim;

import java.util.List;
import se.ericsson.cello.emt.nodeservices.NodeServices;
import se.ericsson.cello.mimparser.MimModel;
import se.ericsson.security.launcher.LauncherException;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.launch.LauncherData;
import se.ericsson.wcdma.rbs.cabinetviewer.mim.CabinetViewerMimModel;
import se.ericsson.wcdma.rbs.cabinetviewer.mim.MimData;
import se.ericsson.wcdma.rbs.cabinetviewer.mim.MimDataImpl;

public class DynamicMimModel
extends CabinetViewerMimModel {
    public DynamicMimModel(LauncherData launcherData) {
        this.init(launcherData);
    }

    private void init(LauncherData launcherData) {
        try {
            NodeServices nodeServices = (NodeServices)launcherData.launcher.runResource("/cello/emas/nodeservcfg.xml", launcherData.ipAddress, launcherData.properties, null);
            MimModel mimModel = nodeServices.getMimModel();
            this.setMimData(new MimDataImpl(mimModel));
        }
        catch (LauncherException launcherException) {
            Trace.warning(this, "Failed to parse MOM file ", (Exception)((Object)launcherException));
        }
    }

    public void print() {
        MimData mimData = this.getMimData();
        List<String> list = mimData.getAllMoTypes();
        for (String string : list) {
            List<String> list2 = mimData.getAttributeNames(string);
            System.out.println("MoType : " + string);
            System.out.println("Attributes: ");
            for (String string2 : list2) {
                System.out.println("\t\t" + string2);
            }
        }
    }
}

