/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.rbs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.GridMounting;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.MultiUnitBoard;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.SlotlessMultiUnitBoard;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.SubrackLayout;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoRelationship;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.ModelException;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.rbs.RbsAbstractTemplate;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.rbs.RbsProperty;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.template.Cardinality;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.util.Helper;

public class RbsVoRelationship
extends RbsAbstractTemplate {
    private String generalType;
    private String specificType;
    private Cardinality cardinality;
    private Collection rbsVoRelationships = new ArrayList();

    public RbsVoRelationship(Hashtable hashtable, Node node, boolean bl) {
        super(new Hashtable(hashtable), node);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equals("generalType")) {
                this.generalType = Helper.getDataInFirstTextNode(this.getParams(), node2);
                continue;
            }
            if (string.equals("specificType")) {
                this.specificType = Helper.getDataInFirstTextNode(this.getParams(), node2);
                continue;
            }
            if (string.equals("cardinality")) {
                this.cardinality = new Cardinality(this.getParams(), node2);
                continue;
            }
            if (!string.equals("voRelationship")) continue;
            String string2 = this.getConfigDependency(node2);
            if (string2.equals("MULTI_CABINET") && bl) {
                this.rbsVoRelationships.add(new RbsVoRelationship(this.getParams(), node2, bl));
                continue;
            }
            if (string2.equals("SINGLE_CABINET") && !bl) {
                this.rbsVoRelationships.add(new RbsVoRelationship(this.getParams(), node2, bl));
                continue;
            }
            if (string2.equals("MULTI_CABINET") || string2.equals("SINGLE_CABINET")) continue;
            this.rbsVoRelationships.add(new RbsVoRelationship(this.getParams(), node2, bl));
        }
    }

    private String getConfigDependency(Node node) {
        NodeList nodeList = node.getChildNodes();
        String string = "";
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string2 = node2.getNodeName();
            if (!string2.equals("configDependency")) continue;
            string = Helper.getDataInFirstTextNode(this.getParams(), node2);
        }
        return string;
    }

    public String getGeneralType() {
        return this.generalType;
    }

    public String getSpecificType() {
        return this.specificType;
    }

    public VoRelationship getVoRelationShip() {
        Hashtable hashtable;
        SubrackLayout subrackLayout;
        SlotlessMultiUnitBoard slotlessMultiUnitBoard;
        RbsProperty rbsProperty = this.getProperty();
        if (rbsProperty == null) {
            throw new ModelException("The child element property to element voRelationship does NOT exist in rbsTemplate.");
        }
        if (this.generalType == null) {
            throw new ModelException("The child element generalType to element rbsTemplate does NOT exist in rbsTemplate.");
        }
        if (this.specificType == null) {
            throw new ModelException("The child element specificType to element rbsTemplate does NOT exist in rbsTemplate.");
        }
        GridMounting gridMounting = rbsProperty.getGridMounting();
        VoRelationship voRelationship = new VoRelationship(this.generalType, this.specificType, gridMounting, this.cardinality);
        MultiUnitBoard multiUnitBoard = rbsProperty.getMultiUnitBoard();
        if (multiUnitBoard != null) {
            voRelationship.putProperty("MULTI_UNIT_BOARD", multiUnitBoard);
        }
        if ((slotlessMultiUnitBoard = rbsProperty.getSlotlessMultiUnitBoard()) != null) {
            voRelationship.putProperty("SLOTLESS_MULTI_UNIT_BOARD", slotlessMultiUnitBoard);
        }
        if ((subrackLayout = rbsProperty.getRbsSubRackLayout()) != null) {
            voRelationship.putProperty("SUBRACK_LAYOUT", subrackLayout);
        }
        if ((hashtable = new Hashtable(rbsProperty.getProperties())).containsKey("AUTO_CONTAINMENT")) {
            voRelationship.setAutoContainment(true);
            hashtable.remove("AUTO_CONTAINMENT");
        }
        voRelationship.putProperties(hashtable);
        this.addAllChildren(voRelationship);
        return voRelationship;
    }

    protected void addAllChildren(VoRelationship voRelationship) {
        for (Object e : this.rbsVoRelationships) {
            RbsVoRelationship rbsVoRelationship = (RbsVoRelationship)e;
            VoRelationship voRelationship2 = rbsVoRelationship.getVoRelationShip();
            if (voRelationship2 == null) continue;
            voRelationship.addChildRelationship(voRelationship2);
        }
    }
}

