/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.summary;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.ButtonGroup;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.converters.ValueConverter;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.summary.AbstractSummary;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.summary.ButtonElement;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.util.Helper;

public class ButtonGroupItemElement
extends AbstractSummary {
    private String objectName;
    private String moType;
    private String attributeName;
    private String nameOfConverter;
    private ValueConverter converter;
    private List<ButtonElement> buttonElements = new ArrayList<ButtonElement>();

    public ButtonGroupItemElement(Node node) {
        super(node);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equals("objectName")) {
                this.objectName = Helper.getDataInFirstTextNode(null, node2);
                continue;
            }
            if (string.equals("moType")) {
                this.moType = Helper.getDataInFirstTextNode(null, node2);
                continue;
            }
            if (string.equals("attribute")) {
                this.attributeName = Helper.getDataInFirstTextNode(null, node2);
                continue;
            }
            if (string.equals("converter")) {
                this.nameOfConverter = Helper.getDataInFirstTextNode(null, node2);
                continue;
            }
            if (!string.equals("button")) continue;
            ButtonElement buttonElement = new ButtonElement(node2);
            this.buttonElements.add(buttonElement);
        }
    }

    protected boolean updateConverterAndVerify(Hashtable hashtable) {
        boolean bl = true;
        Object var3_3 = null;
        if (this.nameOfConverter != null) {
            var3_3 = hashtable.get(this.nameOfConverter);
            if (var3_3 != null) {
                this.converter = var3_3;
            } else {
                Trace.warning(this, "There is an error in \"Summary.xml\". The Converter \"" + this.nameOfConverter + "\" is misspelled or NOT found " + " under xml element <" + "tabbedPanel" + ">.");
                bl = false;
            }
        }
        return bl;
    }

    public ButtonGroup getButtonGroup(Hashtable hashtable) {
        this.updateConverterAndVerify(hashtable);
        ButtonGroup buttonGroup = new ButtonGroup(this.objectName, this.moType, this.attributeName, this.converter);
        for (ButtonElement buttonElement : this.buttonElements) {
            buttonGroup.addButton(buttonElement.getButton());
        }
        return buttonGroup;
    }
}

