/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configirpimpl;

import BasicConfig.AttrMORef;
import BasicConfig.MOAttrValue;
import BasicConfig.NameValue;
import BasicConfig.ProcessingFailure;
import se.ericsson.cello.configirpimpl.ConfigExtendedImpl;
import se.ericsson.cello.support.debug.Assert;

public class AttrIterator {
    private static final int MAX_RETURNED_MOS = 300;
    private MOAttrValue[] elements;
    private String[] attrNames;
    private int nextIndex;

    public AttrIterator(MOAttrValue[] mOAttrValueArray, String[] stringArray) {
        this.elements = mOAttrValueArray;
        this.attrNames = stringArray;
        this.nextIndex = 0;
    }

    public AttrMORef nextMo() throws ProcessingFailure {
        if (this.nextIndex >= this.elements.length) {
            throw new ProcessingFailure("Iterator empty");
        }
        AttrMORef attrMORef = this.createAttrRef(this.elements[this.nextIndex]);
        ++this.nextIndex;
        return attrMORef;
    }

    public AttrMORef[] allMos() {
        return this.nextMos(300);
    }

    public AttrMORef[] nextMos(int n) {
        int n2 = n > this.noOfElementsLeft() ? this.noOfElementsLeft() : n;
        if (n2 > 300) {
            n2 = 300;
        }
        AttrMORef[] attrMORefArray = new AttrMORef[n2];
        try {
            for (int i = 0; i < n2; ++i) {
                attrMORefArray[i] = this.nextMo();
            }
        }
        catch (ProcessingFailure processingFailure) {
            Assert.cppAssert((boolean)false);
        }
        return attrMORefArray;
    }

    public boolean hasMoreElements() {
        return this.nextIndex < this.elements.length;
    }

    private int noOfElementsLeft() {
        return this.elements.length - this.nextIndex;
    }

    private AttrMORef createAttrRef(MOAttrValue mOAttrValue) {
        Assert.cppAssert((mOAttrValue.attrValues.length == this.attrNames.length ? 1 : 0) != 0);
        NameValue[] nameValueArray = new NameValue[mOAttrValue.attrValues.length];
        for (int i = 0; i < this.attrNames.length; ++i) {
            nameValueArray[i] = new NameValue();
            nameValueArray[i].name = this.attrNames[i];
            nameValueArray[i].value = mOAttrValue.attrValues[i];
        }
        return new AttrMORef(mOAttrValue.mo.oid, ConfigExtendedImpl.instance().getBasicConfigRef(), nameValueArray);
    }
}

