/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.csnotification;

import ConfigExtended.MIBChangeInfo;
import ConfigExtended.NotificationKind;
import ConfigExtended.NotificationProducerPackage.ToOldGenerationCount;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import se.ericsson.cello.csnotification.Subscription;
import se.ericsson.cello.csnotification.SubscriptionMgr;
import se.ericsson.cello.moframework.MosiNotificationSender;
import se.ericsson.cello.moframework.SequenceDiffInfo;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class NotificationReporter {
    private static SortedMap gcMap = new TreeMap();
    private static int gc = 0;
    private static final int DEFAULT_BUFFER_SIZE = 300;
    private static final int BUFFER_SIZE = NotificationReporter.setBufferSize();
    private static Map ldnMap = NotificationReporter.initLdnMap();

    public static synchronized void pushAVC(String string, String string2, String string3, int n, String[] stringArray, Object[] objectArray, Coordinator coordinator) {
        Enumeration enumeration = SubscriptionMgr.getAllSubscriptions();
        NotificationReporter.storeMIBChange(new MIBChangeInfo(string, NotificationKind.AVCType, ++gc));
        while (enumeration.hasMoreElements()) {
            Subscription subscription = (Subscription)enumeration.nextElement();
            if (subscription != null) {
                subscription.pushAVC(string, string2, string3, n, stringArray, objectArray, gc, coordinator);
                continue;
            }
            MessageLog.traceError((Class)(class$se$ericsson$cello$csnotification$NotificationReporter == null ? NotificationReporter.class$("se.ericsson.cello.csnotification.NotificationReporter") : class$se$ericsson$cello$csnotification$NotificationReporter), (String)"pushAVC: subscription is null, notification will not be sent.");
        }
        MosiNotificationSender.moChanged(string, string3, stringArray, objectArray);
    }

    public static synchronized void pushSequenceDeltaNotification(String string, String string2, String string3, int n, String[] stringArray, SequenceDiffInfo[] sequenceDiffInfoArray, Coordinator coordinator) {
        Enumeration enumeration = SubscriptionMgr.getAllSubscriptions();
        NotificationReporter.storeMIBChange(new MIBChangeInfo(string, NotificationKind.AVCType, ++gc));
        while (enumeration.hasMoreElements()) {
            Subscription subscription = (Subscription)enumeration.nextElement();
            if (subscription != null) {
                if (!subscription.getSupportSDN()) {
                    subscription.pushAVC(string, string2, string3, n, stringArray, NotificationReporter.getNewValues(sequenceDiffInfoArray), gc, coordinator);
                    continue;
                }
                subscription.pushSequenceDeltaNotification(string, string2, string3, n, stringArray, sequenceDiffInfoArray, gc, coordinator);
                continue;
            }
            MessageLog.traceError((Class)(class$se$ericsson$cello$csnotification$NotificationReporter == null ? NotificationReporter.class$("se.ericsson.cello.csnotification.NotificationReporter") : class$se$ericsson$cello$csnotification$NotificationReporter), (String)"pushSequenceDeltaNotification: subscription is null, notification will not be sent.");
        }
        MosiNotificationSender.moChanged(string, string3, stringArray, sequenceDiffInfoArray);
    }

    private static Object[] getNewValues(SequenceDiffInfo[] sequenceDiffInfoArray) {
        Object[] objectArray = new Object[sequenceDiffInfoArray.length];
        for (int i = 0; i < sequenceDiffInfoArray.length; ++i) {
            objectArray[i] = sequenceDiffInfoArray[i].getObject();
        }
        return objectArray;
    }

    public static synchronized void pushMoCreated(String string, String string2, String string3, int n, Coordinator coordinator) {
        Enumeration enumeration = SubscriptionMgr.getAllSubscriptions();
        NotificationReporter.storeMIBChange(new MIBChangeInfo(string, NotificationKind.MOCreatedType, ++gc));
        while (enumeration.hasMoreElements()) {
            Subscription subscription = (Subscription)enumeration.nextElement();
            if (subscription != null) {
                subscription.pushMoCreated(string, string2, string3, n, gc, coordinator);
                continue;
            }
            MessageLog.traceError((Class)(class$se$ericsson$cello$csnotification$NotificationReporter == null ? NotificationReporter.class$("se.ericsson.cello.csnotification.NotificationReporter") : class$se$ericsson$cello$csnotification$NotificationReporter), (String)"pushMoCreated: subscription is null, notification will not be sent.");
        }
        MosiNotificationSender.moCreated(string, string3);
    }

    public static synchronized void pushMoDeleted(String string, String string2, String string3, int n, Coordinator coordinator) {
        Enumeration enumeration = SubscriptionMgr.getAllSubscriptions();
        NotificationReporter.storeMIBChange(new MIBChangeInfo(string, NotificationKind.MODeletedType, ++gc));
        while (enumeration.hasMoreElements()) {
            Subscription subscription = (Subscription)enumeration.nextElement();
            if (subscription != null) {
                subscription.pushMoDeleted(string, string2, string3, n, gc, coordinator);
                continue;
            }
            MessageLog.traceError((Class)(class$se$ericsson$cello$csnotification$NotificationReporter == null ? NotificationReporter.class$("se.ericsson.cello.csnotification.NotificationReporter") : class$se$ericsson$cello$csnotification$NotificationReporter), (String)"pushMoDeleted: subscription is null, notification will not be sent.");
        }
        MosiNotificationSender.moDeleted(string, string3);
    }

    public static synchronized MIBChangeInfo[] getMIBChanges(int n) throws ToOldGenerationCount {
        if (n < 0 || n > gc) {
            throw new ToOldGenerationCount();
        }
        if (gcMap.isEmpty()) {
            return new MIBChangeInfo[0];
        }
        int n2 = (Integer)gcMap.firstKey();
        if (n < n2 - 1) {
            throw new ToOldGenerationCount();
        }
        SortedMap sortedMap = gcMap.tailMap(new Integer(n + 1));
        Collection collection = sortedMap.values();
        return collection.toArray(new MIBChangeInfo[collection.size()]);
    }

    public static synchronized int getGenerationCount() {
        return gc;
    }

    private static void storeMIBChange(MIBChangeInfo mIBChangeInfo) {
        if (ldnMap.containsKey(mIBChangeInfo.localDN)) {
            gcMap.remove((Integer)ldnMap.get(mIBChangeInfo.localDN));
        } else if (ldnMap.size() >= BUFFER_SIZE) {
            ldnMap.remove(((MIBChangeInfo)NotificationReporter.gcMap.get(NotificationReporter.gcMap.firstKey())).localDN);
            gcMap.remove(gcMap.firstKey());
        }
        Integer n = new Integer(mIBChangeInfo.generationCount);
        gcMap.put(n, mIBChangeInfo);
        ldnMap.put(mIBChangeInfo.localDN, n);
    }

    private static int setBufferSize() {
        int n = 300;
        String string = System.getProperty("se.ericsson.cello.MibDeltaBufferSize");
        if (string != null) {
            try {
                int n2 = Integer.parseInt(string);
                if (n2 > 300) {
                    n = n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                MessageLog.info((Class)NotificationReporter.class, (String)("The property se.ericsson.cello.MibDeltaBufferSize is invalid. Must be a number, now set to " + string + ". Using default value " + 300));
            }
        }
        MessageLog.trace((int)5, (Class)NotificationReporter.class, (String)("Setting BUFFER_SIZE to " + n));
        return n;
    }

    private static HashMap initLdnMap() {
        return new HashMap(BUFFER_SIZE);
    }
}

