/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.faultmanagement;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.faultmanagement.AdditionalInfo;
import se.ericsson.cello.faultmanagement.Alarm;
import se.ericsson.cello.faultmanagement.AlarmDuplicatedException;
import se.ericsson.cello.faultmanagement.Event;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.csnotifications.CSNotificationSubscriberMgrFactory;
import se.ericsson.cello.moframework.csnotifications.SubscriptionFilter;
import se.ericsson.cello.moframework.csnotifications.TopologyAndAVCSubscriber;
import se.ericsson.cello.support.debug.MessageLog;

public class AlarmManager {
    private static AlarmList alarmList;
    private static RepositoryImpl definitions;
    private static CSSubscriber csSubscriber;
    private static final int TRACE_GROUP = 5;

    public static DefinitionRepository getDefinitionRepository() {
        return definitions;
    }

    public static Reporter getReporter() {
        return alarmList;
    }

    static void initialize() {
        definitions = new RepositoryImpl();
        alarmList = new AlarmList(definitions);
        csSubscriber = new CSSubscriber(alarmList);
        SubscriptionFilter subscriptionFilter = new SubscriptionFilter();
        subscriptionFilter.setMoTypes(new String[0]);
        CSNotificationSubscriberMgrFactory.createCSNotificationSubscriberMgr().register(csSubscriber, subscriptionFilter);
    }

    private static class CSSubscriber
    implements TopologyAndAVCSubscriber {
        private AlarmList alarmList;

        CSSubscriber(AlarmList alarmList) {
            this.alarmList = alarmList;
        }

        public void moCreated(String string) {
        }

        public void moDeleted(String string) {
            this.alarmList.ceaseAlarmsForMo(string);
        }

        public void moChanged(String string, List list) {
        }

        public void queueOverflow() {
            MessageLog.trace((int)5, this.getClass(), (String)"Notification queue full");
            this.alarmList.removeAlarmsForDeletedMos();
        }
    }

    private static class AlarmList
    implements Reporter {
        private RepositoryImpl definitions;
        private Hashtable activeAlarms = new Hashtable();

        AlarmList(RepositoryImpl repositoryImpl) {
            this.definitions = repositoryImpl;
        }

        private String key(int n, String string) {
            return n + string;
        }

        public synchronized void raiseAlarm(int n, ManagedObject managedObject, String string, String string2, AdditionalInfo[] additionalInfoArray, int[] nArray, boolean bl, String string3) {
            DefinitionRepository.AlarmDef alarmDef = this.definitions.getAlarmDef(new Integer(n));
            if (alarmDef == null) {
                MessageLog.traceError(this.getClass(), (String)("raiseAlarm, alarm type is not defined: " + n + " mo: " + managedObject));
                return;
            }
            try {
                String string4 = this.key(n, managedObject.getLocalDistinguishedName());
                if (this.activeAlarms.containsKey(string4)) {
                    MessageLog.trace((int)5, this.getClass(), (String)("raiseAlarm, alarm already raised specProblem :" + n + " mo: " + managedObject));
                    return;
                }
                MoRepository moRepository = MoRepository.instance();
                if (moRepository.lookup(managedObject.getLocalDistinguishedName(), true) != null) {
                    Alarm alarm = Alarm.create(managedObject.getType(), managedObject.getFullDistinguishedName(), alarmDef.eventType, string, alarmDef.probableCause, alarmDef.perceivedSeverity, alarmDef.specificProblem, string2, additionalInfoArray, nArray, bl);
                    MessageLog.trace((int)5, this.getClass(), (String)("raiseAlarm, specProblem :" + n + " mo: " + managedObject));
                    this.activeAlarms.put(string4, new ActiveAlarm(alarm, string3, n));
                }
            }
            catch (AlarmDuplicatedException alarmDuplicatedException) {
                MessageLog.info(this.getClass(), (String)("raiseAlarm, alarm duplicated: " + n + " mo: " + managedObject));
            }
        }

        public synchronized void ceaseAlarmsForService(String string) {
            Iterator iterator = this.activeAlarms.values().iterator();
            while (iterator.hasNext()) {
                ActiveAlarm activeAlarm = (ActiveAlarm)iterator.next();
                if (!activeAlarm.serviceName.equals(string)) continue;
                this.ceaseAlarm(activeAlarm.id, activeAlarm.alarm.getLDN());
                iterator = this.activeAlarms.values().iterator();
            }
        }

        public synchronized void ceaseAlarmsForMo(String string) {
            Iterator iterator = this.activeAlarms.values().iterator();
            while (iterator.hasNext()) {
                ActiveAlarm activeAlarm = (ActiveAlarm)iterator.next();
                if (!activeAlarm.alarm.getLDN().equals(string)) continue;
                this.ceaseAlarm(activeAlarm.id, activeAlarm.alarm.getLDN());
                iterator = this.activeAlarms.values().iterator();
            }
        }

        public synchronized void removeAlarmsForDeletedMos() {
            MoRepository moRepository = MoRepository.instance();
            Iterator iterator = this.activeAlarms.values().iterator();
            while (iterator.hasNext()) {
                ActiveAlarm activeAlarm = (ActiveAlarm)iterator.next();
                String string = activeAlarm.alarm.getLDN();
                if (moRepository.lookup(string, true) != null) continue;
                this.ceaseAlarm(activeAlarm.id, activeAlarm.alarm.getLDN());
                iterator = this.activeAlarms.values().iterator();
            }
        }

        public synchronized void ceaseAlarm(int n, ManagedObject managedObject) {
            this.ceaseAlarm(n, managedObject.getLocalDistinguishedName());
        }

        void ceaseAlarm(int n, String string) {
            String string2 = this.key(n, string);
            ActiveAlarm activeAlarm = (ActiveAlarm)this.activeAlarms.remove(string2);
            if (activeAlarm == null) {
                MessageLog.trace((int)5, this.getClass(), (String)("ceaseAlarm, alarm already ceased specProblem specProblem:" + n + " mo :" + string));
            } else {
                MessageLog.trace((int)5, this.getClass(), (String)("ceaseAlarm, numericSpecificProblem : " + n + " mo :" + string));
                activeAlarm.alarm.clear();
            }
        }

        public void reportEvent(int n, ManagedObject managedObject, String string, String string2, AdditionalInfo[] additionalInfoArray) {
            DefinitionRepository.EventDef eventDef = this.definitions.getEventDef(new Integer(n));
            if (eventDef == null) {
                MessageLog.traceError(this.getClass(), (String)("reportEvent, event type is not defined :" + n + " mo :" + managedObject));
                return;
            }
            new Event(managedObject.getType(), managedObject.getFullDistinguishedName(), "0", string, eventDef.specificEvent, string2, additionalInfoArray);
        }

        public synchronized Alarm getActiveAlarm(int n, ManagedObject managedObject) {
            String string = this.key(n, managedObject.getLocalDistinguishedName());
            ActiveAlarm activeAlarm = (ActiveAlarm)this.activeAlarms.get(string);
            if (activeAlarm == null) {
                return null;
            }
            return activeAlarm.alarm;
        }

        private static class ActiveAlarm {
            Alarm alarm;
            String serviceName;
            int id;

            ActiveAlarm(Alarm alarm, String string, int n) {
                this.alarm = alarm;
                this.serviceName = string;
                this.id = n;
            }
        }
    }

    private static class RepositoryImpl
    implements DefinitionRepository {
        private Map eventDefs = new HashMap();
        private Map alarmDefs = new HashMap();

        private RepositoryImpl() {
        }

        public synchronized void registerEventDef(int n, String string) {
            Integer n2 = new Integer(n);
            if (this.eventDefs.containsKey(n2)) {
                MessageLog.traceError(this.getClass(), (String)("Event type is multiply defined: " + n2 + " specificEvent: " + string));
            } else {
                this.eventDefs.put(n2, new DefinitionRepository.EventDef(n, string));
            }
        }

        public synchronized void registerAlarmDef(int n, String string, String string2, String string3, String string4) {
            MessageLog.trace((int)5, this.getClass(), (String)("registerAlarmDef(). numericId:" + n + ", specificProblem:" + string + ", eventType:" + string2 + ", probableCause:" + string3 + ", perceivedSeverity:" + string4));
            Integer n2 = new Integer(n);
            if (this.alarmDefs.containsKey(n2)) {
                DefinitionRepository.AlarmDef alarmDef = this.getAlarmDef(n2);
                if (!alarmDef.getSpecificProblem().equals(string)) {
                    MessageLog.traceError(this.getClass(), (String)("Alarm type is multiply defined: " + n2 + " specificProblem1: " + alarmDef.getSpecificProblem() + " specificProblem2: " + string));
                }
            } else {
                this.alarmDefs.put(n2, new DefinitionRepository.AlarmDef(n, string, string2, string3, string4));
            }
        }

        public synchronized DefinitionRepository.AlarmDef getAlarmDef(Integer n) {
            return (DefinitionRepository.AlarmDef)this.alarmDefs.get(n);
        }

        public synchronized DefinitionRepository.EventDef getEventDef(Integer n) {
            return (DefinitionRepository.EventDef)this.eventDefs.get(n);
        }

        public synchronized Integer[] getDefinedAlarmSpecificProblems() {
            return this.alarmDefs.keySet().toArray(new Integer[0]);
        }

        public synchronized Integer[] getDefinedEventSpecificProblems() {
            return this.eventDefs.keySet().toArray(new Integer[0]);
        }
    }

    public static interface Reporter {
        public static final String TIME_NOW = null;

        public void raiseAlarm(int var1, ManagedObject var2, String var3, String var4, AdditionalInfo[] var5, int[] var6, boolean var7, String var8);

        public void ceaseAlarm(int var1, ManagedObject var2);

        public void ceaseAlarmsForService(String var1);

        public void reportEvent(int var1, ManagedObject var2, String var3, String var4, AdditionalInfo[] var5);

        public Alarm getActiveAlarm(int var1, ManagedObject var2);
    }

    public static interface DefinitionRepository {
        public void registerAlarmDef(int var1, String var2, String var3, String var4, String var5);

        public void registerEventDef(int var1, String var2);

        public AlarmDef getAlarmDef(Integer var1);

        public EventDef getEventDef(Integer var1);

        public Integer[] getDefinedAlarmSpecificProblems();

        public Integer[] getDefinedEventSpecificProblems();

        public static class EventDef {
            final int id;
            final String specificEvent;

            EventDef(int n, String string) {
                this.id = n;
                this.specificEvent = string;
            }

            public String toString() {
                return "\"(EventDef: id,specificEvent)\" " + this.id + " \"" + this.specificEvent + "\" ";
            }
        }

        public static class AlarmDef {
            final int id;
            final String specificProblem;
            final String eventType;
            final String probableCause;
            final String perceivedSeverity;

            AlarmDef(int n, String string, String string2, String string3, String string4) {
                this.id = n;
                this.specificProblem = string;
                this.eventType = string2;
                this.probableCause = string3;
                this.perceivedSeverity = string4;
            }

            public String toString() {
                return "\"(AlarmDef: id,specificProblem,eventType,probableCause,perceivedSeverity)\" " + this.id + " \"" + this.specificProblem + "\" " + this.eventType + " " + this.probableCause + " " + this.perceivedSeverity;
            }

            public String getSpecificProblem() {
                return this.specificProblem;
            }
        }
    }
}

