/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.faultmanagement;

import CelloAlarmIRPExtension.AlarmIRPExtensionPOATie;
import java.util.MissingResourceException;
import org.omg.CosNaming.NameComponent;
import se.ericsson.cello.faultmanagement.Alarm;
import se.ericsson.cello.faultmanagement.AlarmIRP_1Impl;
import se.ericsson.cello.faultmanagement.AlarmManager;
import se.ericsson.cello.faultmanagement.Event;
import se.ericsson.cello.faultmanagement.FilterTimer;
import se.ericsson.cello.pri.LongSystemParameter;
import se.ericsson.cello.pri.PriJavaProxy;
import se.ericsson.cello.pri.PriJavaProxyFactory;
import se.ericsson.cello.pri.PriProcessNotFoundException;
import se.ericsson.cello.pri.SystemParameterNotFoundException;
import se.ericsson.cello.pri.WrongSystemParameterTypeException;
import se.ericsson.cello.support.corba.CelloOrb;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.services.ServiceProvider;
import se.ericsson.cello.support.services.ServiceStateManager;
import se.ericsson.cello.support.thread.ActionListener;

public final class AlarmService {
    static final int FILTER_ALARMS_TIMER_DEFAULT = 120;
    static final long FILTER_ALARMS_TIMER_SP_KEY = 50L;
    static int filterTime = 120;
    private static int serviceProviderState = 2;
    private static ServiceProvider serviceProvider;

    public static void init() {
        try {
            AlarmService.initAlarmService();
            Alarm.createAlarmLog();
            Event.createEventLog();
            AlarmService.initAlarmFilterPeriod();
            AlarmManager.initialize();
            serviceProvider = new ServiceProviderImpl();
            ServiceStateManager.getInstance().registerService(serviceProvider);
            serviceProviderState = 1;
            ServiceStateManager.getInstance().updateServiceProviderState(serviceProvider);
        }
        catch (Exception exception) {
            throw new MissingResourceException(exception.toString(), "AlarmService", "");
        }
    }

    public static void reinit() {
        try {
            AlarmService.initAlarmService();
            serviceProviderState = 1;
            ServiceStateManager.getInstance().updateServiceProviderState(serviceProvider);
        }
        catch (Exception exception) {
            throw new MissingResourceException(exception.toString(), "AlarmService", "");
        }
    }

    private static void initAlarmFilterPeriod() {
        AlarmService.configureFilterTime();
        if (filterTime == 0) {
            Alarm.filterPeriod = false;
        } else {
            se.ericsson.cello.support.thread.Alarm alarm = new se.ericsson.cello.support.thread.Alarm(filterTime * 1000, se.ericsson.cello.support.thread.Alarm.ONE_SHOT);
            alarm.addActionListener((ActionListener)new FilterTimer());
            alarm.start();
        }
    }

    private static void configureFilterTime() {
        try {
            PriJavaProxy priJavaProxy = PriJavaProxyFactory.createPriJavaProxy();
            LongSystemParameter longSystemParameter = priJavaProxy.getLongSystemParameter(50L);
            if (longSystemParameter.isValid()) {
                filterTime = (int)longSystemParameter.getValue();
                MessageLog.info((Class)AlarmService.class, (String)("Using system parameter 50, FilterAlarmTimer = " + filterTime + "s"));
            }
        }
        catch (WrongSystemParameterTypeException wrongSystemParameterTypeException) {
            MessageLog.info((Class)AlarmService.class, (String)"Parameter 50 has wrong type, using default value");
        }
        catch (SystemParameterNotFoundException systemParameterNotFoundException) {
            MessageLog.info((Class)AlarmService.class, (String)"Parameter 50 not found, using default value");
        }
        catch (PriProcessNotFoundException priProcessNotFoundException) {
            MessageLog.info((Class)AlarmService.class, (String)"Parameter 50 not found, using default value");
        }
    }

    private static void initAlarmService() throws Exception {
        AlarmIRPExtensionPOATie alarmIRPExtensionPOATie = new AlarmIRPExtensionPOATie(AlarmIRP_1Impl.instance());
        CelloOrb.instance().connect("ALARM_IRP_VERSION_1_1", alarmIRPExtensionPOATie);
        NameComponent nameComponent = new NameComponent("ALARM_IRP_VERSION_1_1", "");
        NameComponent[] nameComponentArray = new NameComponent[]{nameComponent};
        CelloOrb.instance().rebind(nameComponentArray, CelloOrb.instance().servant_to_reference(alarmIRPExtensionPOATie));
    }

    private AlarmService() {
    }

    public static int getFilterTime() {
        return filterTime;
    }

    private static class ServiceProviderImpl
    implements ServiceProvider {
        public String getServiceName() {
            return "CPP.OAM.ALARMSERVICE";
        }

        public int getState() {
            return serviceProviderState;
        }
    }
}

