/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.moframework;

import java.io.Serializable;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.recovery.AttributeLookUp;
import se.ericsson.cello.recovery.AttributeLookupFactory;
import se.ericsson.cello.transaction.Coordinator;

public class FloatAttribute
extends Attribute
implements Serializable {
    static final long serialVersionUID = -8695339137367652444L;
    private transient float myBackup;
    private float myValue;
    private transient boolean myIsTransactionActive = false;

    public FloatAttribute(String string, boolean bl) {
        super(string, bl);
        this.myValue = 0.0f;
    }

    public FloatAttribute(String string, String string2) {
        super(string, string2.charAt(1));
        this.myValue = Float.valueOf(string2.substring(2)).floatValue();
    }

    public FloatAttribute(String string, boolean bl, float f) {
        super(string, bl);
        this.myValue = f;
    }

    public synchronized float getValue(Coordinator coordinator) {
        if (coordinator == null && this.myIsTransactionActive) {
            return this.myBackup;
        }
        return this.myValue;
    }

    public synchronized void setValue(float f) {
        this.myValue = f;
    }

    public synchronized void setValue(Float f) {
        this.myValue = f.floatValue();
    }

    synchronized void rollback() {
        this.myValue = this.myBackup;
        this.myIsTransactionActive = false;
    }

    synchronized void commit() {
        this.myIsTransactionActive = false;
    }

    synchronized void startTransaction() {
        this.myBackup = this.myValue;
        this.myIsTransactionActive = true;
    }

    Object getValueAsObject(Coordinator coordinator) {
        return new Float(this.getValue(coordinator));
    }

    Object getBackUpValueAsObject(Coordinator coordinator) {
        return new Float(this.myBackup);
    }

    boolean isModified() {
        return this.myValue != this.myBackup;
    }

    public String buildString() {
        AttributeLookUp attributeLookUp = AttributeLookupFactory.instance();
        String string = this.getName();
        if (!string.equalsIgnoreCase("")) {
            string = "" + attributeLookUp.lookup(string);
        }
        return string + this.buildValueString();
    }

    public String buildValueString() {
        String string = "";
        string = this.getNotificationType() != 0 ? "T" : "F";
        return "^f" + string + this.myValue;
    }
}

