/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.moframework;

import se.ericsson.cello.moframework.FilterSyntaxException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.Mib;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.moframework.MoAccessor;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoFilter;
import se.ericsson.cello.moframework.MoHasChildrenException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.Notifier;
import se.ericsson.cello.moframework.ParentAlreadyLockedException;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.WritableMoAccessor;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.support.servloc.ServiceRepository;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionServiceImpl;

final class MaoContextImpl
implements WritableMoAccessor,
InitialMaoContext {
    private static InitialMaoContext instance;

    public void registerMo(ManagedObject managedObject, Coordinator coordinator) throws MoNameAlreadyTakenException {
        MoRepository.instance().registerMo(managedObject, coordinator);
    }

    public void deregisterMo(ManagedObject managedObject, Coordinator coordinator) throws MoHasChildrenException, ParentAlreadyLockedException {
        MoRepository.instance().deregisterMo(managedObject, coordinator);
    }

    public WritableMoAccessor getWritableMoAccessor() {
        return this;
    }

    public MoData createMoData(String string, String string2, boolean bl, Coordinator coordinator) throws TransactionRequiredException {
        MoData moData = new MoData(string, string2, bl, coordinator);
        return moData;
    }

    public TransactionFactory getTransactionFactory() {
        return TransactionServiceImpl.instance().getTransactionFactory();
    }

    public Mib getMib() {
        return MibMgr.instance().getMib();
    }

    public MoAccessor getMoAccessor() {
        return this;
    }

    public ServiceRepository getServiceRepository() {
        return ServiceLocatorFacade.getRepository();
    }

    public ManagedObject lookup(String string) {
        return MoRepository.instance().lookup(string);
    }

    public MoFactory lookupFactory(String string) {
        return MoFactoryMgr.instance().lookup(string);
    }

    public MoIterator lookupType(String string) {
        return MoRepository.instance().lookupType(string);
    }

    public MoIterator select(ManagedObject managedObject, int n, Coordinator coordinator, String string, String string2) throws FilterSyntaxException {
        return MoRepository.instance().select(managedObject, n, coordinator, string, string2);
    }

    public MoIterator select(ManagedObject managedObject, int n, MoFilter moFilter) {
        return MoRepository.instance().select(managedObject, n, moFilter);
    }

    private MaoContextImpl() {
    }

    public Notifier getAVCNotificationSender() {
        return NotificationSender.getNotifier();
    }

    public static synchronized InitialMaoContext instance() {
        if (instance == null) {
            instance = new MaoContextImpl();
        }
        return instance;
    }
}

