/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.oms;

import BasicConfig.NameValue;
import java.util.Enumeration;
import java.util.Vector;
import se.ericsson.cello.configirpimpl.AsynchronousTxCollector;
import se.ericsson.cello.configirpimpl.ConfigExtendedImpl;
import se.ericsson.cello.configirpimpl.DynMoAccess;
import se.ericsson.cello.configirpimpl.NotificationProducerImpl;
import se.ericsson.cello.faultmanagement.AlarmIRP_1Impl;
import se.ericsson.cello.faultmanagement.AlarmService;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoDataConvMgr;
import se.ericsson.cello.moframework.MoDataConversionException;
import se.ericsson.cello.moframework.MoDataConverter;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.Mopplet;
import se.ericsson.cello.moframework.MoppletExtended;
import se.ericsson.cello.moframework.internal.MoppletInvocation;
import se.ericsson.cello.moframework.internal.MoppletManager;
import se.ericsson.cello.moframework.internal.MoppletNameStorage;
import se.ericsson.cello.moframework.internal.MoppletRunner;
import se.ericsson.cello.notification.NotificationIRPImpl;
import se.ericsson.cello.oms.NodeIpAddressSubscriber;
import se.ericsson.cello.oms.ORBRestartManager;
import se.ericsson.cello.oms.SecurityEventSubscriber;
import se.ericsson.cello.pms.generic.PerformanceMgmntService;
import se.ericsson.cello.pms.generic.PmsPortalImpl;
import se.ericsson.cello.productinventory.ProductInventory;
import se.ericsson.cello.recovery.MoRecoveryHandler;
import se.ericsson.cello.recovery.ProgressIndicator;
import se.ericsson.cello.support.corba.CelloOrb;
import se.ericsson.cello.support.corba.IpAddressHelper;
import se.ericsson.cello.support.debug.Assert;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.services.ServiceProvider;
import se.ericsson.cello.support.services.ServiceStateManager;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;

public class Oms {
    private static final int RETRY_INTERVAL = 5000;
    public static final int TRACE_GROUP = 5;
    private static int serviceProviderState = 2;
    private static ServiceProvider serviceProvider;
    private static Thread pmRecoveryThread;

    public static void main(String[] stringArray) {
        try {
            MessageLog.info((Class)Oms.class, (String)"OMS main triggered");
            serviceProvider = new ServiceProviderImpl();
            ServiceStateManager.getInstance().registerService(serviceProvider);
            AsynchronousTxCollector asynchronousTxCollector = AsynchronousTxCollector.instance();
            ServiceLocatorFacade.getRepository().addService(asynchronousTxCollector, asynchronousTxCollector.getClass(), null);
            ORBRestartManager.instance().setRestartAllowed(false);
            MoRepository.instance().setRecoveryPhase(true);
            Oms.registerSecLevelSubscriber();
            Oms.registerNIASubscriber();
            Oms.startCelloOrb();
            Oms.startNameService();
            Oms.startNotificationService();
            AlarmService.init();
            MessageLog.info((Class)Oms.class, (String)"Started Alarm Service");
            ConfigExtendedImpl.instance();
            PerformanceMgmntService.init();
            MoppletManager moppletManager = new MoppletManager();
            ServiceLocatorFacade.getRepository().addService(moppletManager.getStorage(), MoppletNameStorage.class, null);
            MoppletRunner moppletRunner = moppletManager.getMoppletRunner();
            MessageLog.info((Class)Oms.class, (String)"Entering mopplet init()");
            moppletRunner.invoke(Oms.init());
            MessageLog.info((Class)Oms.class, (String)"Exiting mopplet init()");
            ProgressIndicator.instance().start();
            Vector vector = null;
            MessageLog.info((Class)Oms.class, (String)"Start retrieving MoData");
            vector = MoRecoveryHandler.instance().retrieveAllMoData();
            MessageLog.info((Class)Oms.class, (String)"Retrieved all MoData");
            Oms.convertMoData(vector);
            MessageLog.info((Class)Oms.class, (String)"Starting to recover all MOs");
            if (!MoRecoveryHandler.instance().recoverMos(vector)) {
                Assert.cppAssert(null, (String)"Failed to recover MOs");
            }
            MessageLog.info((Class)Oms.class, (String)"All MOs recovered");
            ConfigExtendedImpl.restoreSubscriptions();
            MessageLog.info((Class)Oms.class, (String)"CS subscriptions restored");
            MessageLog.info((Class)Oms.class, (String)"Entering mopplet start()");
            moppletRunner.invoke(Oms.start());
            MessageLog.info((Class)Oms.class, (String)"Exiting mopplet start()");
            MessageLog.info((Class)Oms.class, (String)"Entering mopplet finish()");
            moppletRunner.invoke(Oms.finish());
            MessageLog.info((Class)Oms.class, (String)"Exiting mopplet finish()");
            ProgressIndicator.instance().stop();
            ProductInventory.init();
            MessageLog.info((Class)Oms.class, (String)"Started Inventory Service");
            MoRepository.instance().setRecoveryPhase(false);
            ConfigExtendedImpl.init();
            MessageLog.info((Class)Oms.class, (String)"Started Configuration Service");
            NotificationProducerImpl.instance();
            if (PmsPortalImpl.getPortal().isRecoveryDelayed().booleanValue()) {
                MessageLog.info((Class)Oms.class, (String)"Delayed PM Recovery enabled. ");
                pmRecoveryThread = new Thread(new PmRecoveryThread());
                pmRecoveryThread.setName("PMRecoveryDelayed");
                pmRecoveryThread.start();
            } else {
                PerformanceMgmntService.recover();
                PerformanceMgmntService.publish();
                MessageLog.info((Class)Oms.class, (String)"Started Performance Monitoring Service");
            }
            AlarmIRP_1Impl.instance().notifyAlarmListRebuilt();
            MessageLog.info((Class)Oms.class, (String)"Sent AlarmListRebuilt");
            MessageLog.info((Class)Oms.class, (String)"OMS initialized.");
            serviceProviderState = 1;
            ServiceStateManager.getInstance().updateServiceProviderState(serviceProvider);
            if (pmRecoveryThread != null) {
                pmRecoveryThread.join();
            }
            if (CelloOrb.instance().getIpv6Address() == null && IpAddressHelper.instance().getIpv6Address() != null && !ORBRestartManager.instance().isOrbRestartRequested()) {
                MessageLog.info((Class)Oms.class, (String)"Recieved IPv6 address by delay, ORB will be restated");
                ORBRestartManager.instance().restartORB();
            }
            ORBRestartManager.instance().setRestartAllowed(true);
            CelloOrb.instance().getOrb().run();
            boolean bl = true;
            while (bl) {
                bl = Oms.restartOrb();
            }
        }
        catch (Throwable throwable) {
            MessageLog.traceError((Class)Oms.class, (String)"Main", (Throwable)throwable);
            Assert.cppAssert(null, (String)("Main" + throwable.toString()));
        }
    }

    private static boolean restartOrb() {
        try {
            serviceProviderState = 2;
            ServiceStateManager.getInstance().updateServiceProviderState(serviceProvider);
            ORBRestartManager.instance().setRestartAllowed(false);
            Thread.sleep(2000L);
            Oms.startCelloOrb();
            Oms.startNameService();
            Oms.startNotificationService();
            AlarmService.reinit();
            MessageLog.info((Class)Oms.class, (String)"Started Alarm Service");
            ProductInventory.reinit();
            MessageLog.info((Class)Oms.class, (String)"Started Inventory Service");
            ConfigExtendedImpl.instance();
            ConfigExtendedImpl.init();
            MessageLog.info((Class)Oms.class, (String)"Started Configuration Service");
            NotificationProducerImpl.instance().reinit();
            PerformanceMgmntService.reinit();
            MessageLog.info((Class)Oms.class, (String)"Started Performance Monitoring Service");
            MessageLog.info((Class)Oms.class, (String)"OMS initialized.");
            serviceProviderState = 1;
            ServiceStateManager.getInstance().updateServiceProviderState(serviceProvider);
            ORBRestartManager.instance().setRestartAllowed(true);
            CelloOrb.instance().getOrb().run();
            return true;
        }
        catch (Throwable throwable) {
            MessageLog.traceError((Class)Oms.class, (String)"Main", (Throwable)throwable);
            Assert.cppAssert(null, (String)("Main" + throwable.toString()));
            return false;
        }
    }

    private static void startCelloOrb() {
        int n = 0;
        while (true) {
            try {
                ++n;
                CelloOrb.instance().start();
                MessageLog.info((Class)Oms.class, (String)"ORB started successfully");
            }
            catch (Exception exception) {
                if (n == 1 || n % 15 == 0) {
                    MessageLog.info((Class)(class$se$ericsson$cello$oms$Oms == null ? Oms.class$("se.ericsson.cello.oms.Oms") : class$se$ericsson$cello$oms$Oms), (String)("Failed to start Cello ORB, trying again. Exception caught: " + exception));
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    MessageLog.traceError((Class)(class$se$ericsson$cello$oms$Oms == null ? Oms.class$("se.ericsson.cello.oms.Oms") : class$se$ericsson$cello$oms$Oms), (String)"Thread interupted", (Throwable)interruptedException);
                }
                if (n != 5) continue;
                MessageLog.info((Class)(class$se$ericsson$cello$oms$Oms == null ? Oms.class$("se.ericsson.cello.oms.Oms") : class$se$ericsson$cello$oms$Oms), (String)"Could not start ORB after 5 attempts.");
                try {
                    Oms.restartJvm();
                }
                catch (MoAccessException moAccessException) {
                    Assert.cppAssert(null, (String)"Could not restart JVM, forcing JVM assertion");
                }
                continue;
            }
            break;
        }
    }

    private static void restartJvm() throws MoAccessException {
        String string = "ManagedElement=1,Equipment=1,Jvm=1";
        ManagedObject managedObject = MoRepository.instance().lookup(string);
        if (managedObject == null) {
            throw new MoNotFoundException(string);
        }
        MessageLog.info((Class)Oms.class, (String)"Graceful restart of Jvm requested");
        DynMoAccess.instance().invokeAction(managedObject, "restart", new NameValue[0], null);
    }

    private static void startNameService() {
        int n = 0;
        while (true) {
            try {
                ++n;
                CelloOrb.instance().startNameServer();
            }
            catch (Exception exception) {
                if (n == 1 || n % 15 == 0) {
                    MessageLog.info((Class)(class$se$ericsson$cello$oms$Oms == null ? Oms.class$("se.ericsson.cello.oms.Oms") : class$se$ericsson$cello$oms$Oms), (String)("Failed to start Name Service, trying again. Exception caught: " + exception));
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    MessageLog.traceError((Class)(class$se$ericsson$cello$oms$Oms == null ? Oms.class$("se.ericsson.cello.oms.Oms") : class$se$ericsson$cello$oms$Oms), (String)"Thread interupted", (Throwable)interruptedException);
                }
                continue;
            }
            break;
        }
    }

    private static void startNotificationService() {
        int n = 0;
        while (true) {
            try {
                ++n;
                NotificationIRPImpl.init();
                MessageLog.info((Class)Oms.class, (String)"Started Notification Service");
            }
            catch (Exception exception) {
                if (n == 1 || n % 15 == 0) {
                    MessageLog.info((Class)(class$se$ericsson$cello$oms$Oms == null ? Oms.class$("se.ericsson.cello.oms.Oms") : class$se$ericsson$cello$oms$Oms), (String)("Failed to start the Notification Service, trying again. Exception caught: " + exception));
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    MessageLog.traceError((Class)(class$se$ericsson$cello$oms$Oms == null ? Oms.class$("se.ericsson.cello.oms.Oms") : class$se$ericsson$cello$oms$Oms), (String)"Thread interupted", (Throwable)interruptedException);
                }
                continue;
            }
            break;
        }
    }

    private static void registerSecLevelSubscriber() {
        int n = 0;
        while (true) {
            try {
                ++n;
                SecurityEventSubscriber.getInstance().init();
                MessageLog.info((Class)Oms.class, (String)"Registered Security Level change subscriber");
            }
            catch (Exception exception) {
                if (n == 1 || n % 15 == 0) {
                    MessageLog.info((Class)(class$se$ericsson$cello$oms$Oms == null ? Oms.class$("se.ericsson.cello.oms.Oms") : class$se$ericsson$cello$oms$Oms), (String)("Failed to register for Security Level change notifications, trying again. Exception caught: " + exception));
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    MessageLog.traceError((Class)(class$se$ericsson$cello$oms$Oms == null ? Oms.class$("se.ericsson.cello.oms.Oms") : class$se$ericsson$cello$oms$Oms), (String)"Thread interupted", (Throwable)interruptedException);
                }
                continue;
            }
            break;
        }
    }

    private static void registerNIASubscriber() {
        int n = 0;
        while (true) {
            try {
                ++n;
                NodeIpAddressSubscriber.getInstance().init();
                MessageLog.info((Class)Oms.class, (String)"Registered Node IP Address change subscriber");
            }
            catch (Exception exception) {
                if (n == 1 || n % 15 == 0) {
                    MessageLog.info((Class)(class$se$ericsson$cello$oms$Oms == null ? Oms.class$("se.ericsson.cello.oms.Oms") : class$se$ericsson$cello$oms$Oms), (String)("Failed to register for Node IP Address change notifications, trying again. Exception caught: " + exception));
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    MessageLog.traceError((Class)(class$se$ericsson$cello$oms$Oms == null ? Oms.class$("se.ericsson.cello.oms.Oms") : class$se$ericsson$cello$oms$Oms), (String)"Thread interupted", (Throwable)interruptedException);
                }
                continue;
            }
            break;
        }
    }

    private static void convertMoData(Vector vector) {
        Vector<MoDataConverter> vector2 = new Vector<MoDataConverter>();
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        Enumeration enumeration = MoDataConvMgr.instance().elements();
        if (enumeration.hasMoreElements()) {
            MoDataConverter moDataConverter;
            Control control = Oms.startTransaction(10000);
            Coordinator coordinator = control.getCoordinator();
            while (enumeration.hasMoreElements()) {
                moDataConverter = (MoDataConverter)enumeration.nextElement();
                MessageLog.info((Class)(class$se$ericsson$cello$oms$Oms == null ? Oms.class$("se.ericsson.cello.oms.Oms") : class$se$ericsson$cello$oms$Oms), (String)("Calling convert method for converter " + moDataConverter.getClass().getName()));
                try {
                    bl = moDataConverter.convertMoData(vector, coordinator);
                    MessageLog.info((Class)(class$se$ericsson$cello$oms$Oms == null ? Oms.class$("se.ericsson.cello.oms.Oms") : class$se$ericsson$cello$oms$Oms), (String)("Convert method for converter " + moDataConverter.getClass().getName() + " returned with putLastInList = " + bl));
                }
                catch (MoDataConversionException moDataConversionException) {
                    Assert.cppAssert(null, (String)("Oms.convertMoData(): MoData conversion failed" + moDataConversionException));
                }
                if (!bl) continue;
                vector2.addElement(moDataConverter);
                ++n;
            }
            Assert.cppAssert((n < MoDataConvMgr.instance().noOfElements() ? 1 : 0) != 0, (String)"Oms.convertMoData: MoDataConverter(s) are faulty, causing eternal loop");
            while (n > 0) {
                MessageLog.info((Class)(class$se$ericsson$cello$oms$Oms == null ? Oms.class$("se.ericsson.cello.oms.Oms") : class$se$ericsson$cello$oms$Oms), (String)"Re-activating the 'putLastInList' converters");
                n = 0;
                n2 = vector2.size();
                enumeration = vector2.elements();
                vector2 = new Vector();
                while (enumeration.hasMoreElements()) {
                    moDataConverter = (MoDataConverter)enumeration.nextElement();
                    MessageLog.info((Class)(class$se$ericsson$cello$oms$Oms == null ? Oms.class$("se.ericsson.cello.oms.Oms") : class$se$ericsson$cello$oms$Oms), (String)("Calling convert method for converter " + moDataConverter.getClass().getName()));
                    try {
                        bl = moDataConverter.convertMoData(vector, coordinator);
                        MessageLog.info((Class)(class$se$ericsson$cello$oms$Oms == null ? Oms.class$("se.ericsson.cello.oms.Oms") : class$se$ericsson$cello$oms$Oms), (String)("Convert method for converter " + moDataConverter.getClass().getName() + " returned with putLastInList = " + bl));
                    }
                    catch (MoDataConversionException moDataConversionException) {
                        try {
                            control.getTerminator().rollback();
                        }
                        catch (InactiveTransactionException inactiveTransactionException) {
                            Assert.cppAssert((boolean)false, (String)("Oms.convertMoData: " + inactiveTransactionException.toString()));
                        }
                        Assert.cppAssert(null, (String)("Oms.convertMoData(): MoData conversion failed" + moDataConversionException));
                    }
                    if (!bl) continue;
                    vector2.addElement(moDataConverter);
                    ++n;
                }
                Assert.cppAssert((n < n2 ? 1 : 0) != 0, (String)"Oms.convertMoData: MoDataConverter(s) are faulty, causing eternal loop");
            }
            try {
                control.getTerminator().commit();
            }
            catch (TransactionRolledBackException transactionRolledBackException) {
                Assert.cppAssert((boolean)false, (String)("Oms.convertMoData: " + transactionRolledBackException.toString()));
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                Assert.cppAssert((boolean)false, (String)("Oms.convertMoData: " + inactiveTransactionException.toString()));
            }
        }
    }

    private static Control startTransaction(int n) {
        Control control = null;
        TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
        try {
            control = transactionFactory.create(n);
            Coordinator coordinator = control.getCoordinator();
            MessageLog.trace((int)5, (Class)Oms.class, (String)("Cello_OMS txId = " + coordinator.getTransactionID() + ", timeout = " + n));
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            Assert.cppAssert((boolean)false, (String)("Oms.startTransaction() exception :" + (Object)((Object)transactionRolledBackException)));
        }
        return control;
    }

    private static MoppletInvocation init() {
        return new MoppletInvocation(){

            public void execute(Mopplet mopplet) {
                Oms.logPreInvocation(mopplet, "init");
                mopplet.init();
                Oms.logPostInvocation(mopplet, "init");
            }
        };
    }

    private static MoppletInvocation start() {
        return new MoppletInvocation(){

            public void execute(Mopplet mopplet) {
                Oms.logPreInvocation(mopplet, "start");
                mopplet.start();
                Oms.logPostInvocation(mopplet, "start");
            }
        };
    }

    private static MoppletInvocation finish() {
        return new MoppletInvocation(){

            public void execute(Mopplet mopplet) {
                if (mopplet instanceof MoppletExtended) {
                    Oms.logPreInvocation(mopplet, "finish");
                    ((MoppletExtended)mopplet).finish();
                    Oms.logPostInvocation(mopplet, "finish");
                }
            }
        };
    }

    private static void logPreInvocation(Mopplet mopplet, String string) {
        MessageLog.trace((int)5, (Class)Oms.class, (String)("Calling " + string + "() method for mopplet " + mopplet.getClass().getName()));
    }

    private static void logPostInvocation(Mopplet mopplet, String string) {
        MessageLog.trace((int)5, (Class)Oms.class, (String)(string + "() method for mopplet " + mopplet.getClass().getName() + " returned"));
    }

    static {
        pmRecoveryThread = null;
    }

    private static class PmRecoveryThread
    implements Runnable {
        private PmRecoveryThread() {
        }

        public void run() {
            MessageLog.info((Class)(class$se$ericsson$cello$oms$Oms == null ? (class$se$ericsson$cello$oms$Oms = Oms.class$("se.ericsson.cello.oms.Oms")) : class$se$ericsson$cello$oms$Oms), (String)"Start PM recovery delay thread");
            PerformanceMgmntService.recover();
            PerformanceMgmntService.publish();
            MessageLog.info((Class)(class$se$ericsson$cello$oms$Oms == null ? (class$se$ericsson$cello$oms$Oms = Oms.class$("se.ericsson.cello.oms.Oms")) : class$se$ericsson$cello$oms$Oms), (String)"Started Performance Monitoring Service");
        }
    }

    private static class ServiceProviderImpl
    implements ServiceProvider {
        public String getServiceName() {
            return "CPP.OAM.SERVICES";
        }

        public int getState() {
            return serviceProviderState;
        }
    }
}

