/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pms.generic;

import java.util.Calendar;
import se.ericsson.cello.pms.generic.DataConsumer;
import se.ericsson.cello.pms.generic.GranularityAndAttributeActivationException;
import se.ericsson.cello.pms.generic.GranularityPeriod;
import se.ericsson.cello.pms.generic.OverloadException;
import se.ericsson.cello.pms.generic.PerformanceMonitoringState;
import se.ericsson.cello.pms.generic.ScannerTimer;
import se.ericsson.cello.pms.generic.Time;
import se.ericsson.cello.pms.generic.TransactionHelper;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.thread.ActionEvent;
import se.ericsson.cello.support.thread.ActionListener;
import se.ericsson.cello.support.thread.BlockingQueue;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.Resource;

public abstract class BasicScanner {
    protected GranularityPeriod granularityPeriod;
    protected DataConsumer destination;
    protected String name;
    private int seqNo = 0;
    private boolean isSuspended = true;
    private Thread worker;
    private BlockingQueue inQueue;
    private PeriodHandler periodHandler = null;
    private boolean allowedToScan;
    private static final int SCAN = 1;
    private static final int STOP = 2;

    public BasicScanner(GranularityPeriod granularityPeriod, PerformanceMonitoringState performanceMonitoringState, DataConsumer dataConsumer, String string, Coordinator coordinator) {
        TransactionHelper.registerResource(coordinator, new CreateTx(performanceMonitoringState));
        this.granularityPeriod = granularityPeriod;
        this.destination = dataConsumer;
        this.name = string;
    }

    public abstract void scan();

    public void init() {
    }

    public void setScannerState(PerformanceMonitoringState performanceMonitoringState, Coordinator coordinator) throws OverloadException, GranularityAndAttributeActivationException {
        if (performanceMonitoringState.value() == 0 && this.isSuspended) {
            TransactionHelper.registerResource(coordinator, new ResumeTx());
        } else if (performanceMonitoringState.value() == 1 && !this.isSuspended) {
            TransactionHelper.registerResource(coordinator, new SuspendTx());
        }
    }

    protected PerformanceMonitoringState getScannerState() {
        if (!this.isSuspended) {
            return PerformanceMonitoringState.ACTIVE;
        }
        return PerformanceMonitoringState.SUSPENDED;
    }

    public void delete(Coordinator coordinator) {
        TransactionHelper.registerResource(coordinator, new DeleteTx());
    }

    protected int getSeqNo() {
        return this.seqNo;
    }

    protected String getTimeStamp() {
        return "";
    }

    void runWorker() {
        while (true) {
            try {
                while (true) {
                    int n = (Integer)this.inQueue.dequeue();
                    switch (n) {
                        case 1: {
                            if (this.allowedToScan) {
                                this.setSequenceNo();
                                this.scan();
                                break;
                            }
                            this.init();
                            this.allowedToScan = true;
                            break;
                        }
                        case 2: {
                            return;
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            catch (Exception exception) {
                MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)exception);
                continue;
            }
            catch (Error error) {
                MessageLog.traceError(this.getClass(), (String)Thread.currentThread().getName(), (Throwable)error);
                continue;
            }
            break;
        }
    }

    void prepareScan(ActionEvent actionEvent) {
        if (this.isSuspended) {
            return;
        }
        if (this.worker == null || !this.worker.isAlive()) {
            this.startWorkerThread();
        }
        if (!actionEvent.getActionCommand().equals("stopped")) {
            this.inQueue.enqueue((Object)new Integer(1));
        }
    }

    void stop() {
        if (this.periodHandler != null) {
            this.periodHandler.stop();
        }
        this.suspend();
    }

    private void init(PerformanceMonitoringState performanceMonitoringState) {
        if (performanceMonitoringState.value() == 0 && this.isSuspended) {
            this.activate();
        } else if (performanceMonitoringState.value() == 1 && !this.isSuspended) {
            this.suspend();
        }
    }

    private void activate() {
        this.isSuspended = false;
        this.allowedToScan = false;
        this.startWorkerThread();
        if (this.periodHandler == null) {
            this.periodHandler = new PeriodHandler();
            this.periodHandler.start(this.granularityPeriod);
        }
    }

    private void startWorkerThread() {
        if (this.inQueue == null || !this.inQueue.isEmpty()) {
            this.inQueue = new BlockingQueue();
        }
        if (this.worker == null || !this.worker.isAlive()) {
            this.worker = new Thread((Runnable)new Worker(), "Pms_" + this.name);
            this.worker.start();
        }
    }

    private void stopWorkerThread() {
        if (this.worker != null && this.worker.isAlive()) {
            this.inQueue.enqueue((Object)new Integer(2));
        }
    }

    private void suspend() {
        this.isSuspended = true;
        this.stopWorkerThread();
        this.seqNo = 0;
    }

    private void setSequenceNo() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(Time.instance().getDate());
        int n = calendar.get(12);
        if (n >= 0 && n < 5) {
            this.seqNo = 12;
        } else if (n >= 5 && n < 10) {
            this.seqNo = 1;
        } else if (n >= 10 && n < 15) {
            this.seqNo = 2;
        } else if (n >= 15 && n < 20) {
            this.seqNo = 3;
        } else if (n >= 20 && n < 25) {
            this.seqNo = 4;
        } else if (n >= 25 && n < 30) {
            this.seqNo = 5;
        } else if (n >= 30 && n < 35) {
            this.seqNo = 6;
        } else if (n >= 35 && n < 40) {
            this.seqNo = 7;
        } else if (n >= 40 && n < 45) {
            this.seqNo = 8;
        } else if (n >= 45 && n < 50) {
            this.seqNo = 9;
        } else if (n >= 50 && n < 55) {
            this.seqNo = 10;
        } else if (n >= 55) {
            this.seqNo = 11;
        }
    }

    private class SuspendTx
    implements Resource {
        private SuspendTx() {
        }

        public void commit() {
            BasicScanner.this.suspend();
        }

        public boolean prepare() {
            return true;
        }

        public void rollback() {
        }
    }

    private class ResumeTx
    implements Resource {
        private ResumeTx() {
        }

        public void commit() {
            BasicScanner.this.activate();
        }

        public boolean prepare() {
            return true;
        }

        public void rollback() {
        }
    }

    private class DeleteTx
    implements Resource {
        private DeleteTx() {
        }

        public void commit() {
            BasicScanner.this.stop();
        }

        public boolean prepare() {
            return true;
        }

        public void rollback() {
        }
    }

    private class CreateTx
    implements Resource {
        private PerformanceMonitoringState txState;

        CreateTx(PerformanceMonitoringState performanceMonitoringState) {
            this.txState = performanceMonitoringState;
        }

        public void commit() {
            BasicScanner.this.init(this.txState);
            this.txState = null;
        }

        public boolean prepare() {
            return true;
        }

        public void rollback() {
        }
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        public void run() {
            BasicScanner.this.runWorker();
        }
    }

    private class PeriodHandler
    implements ActionListener {
        private ScannerTimer timer = null;

        public void actionPerformed(ActionEvent actionEvent) {
            BasicScanner.this.prepareScan(actionEvent);
        }

        PeriodHandler() {
        }

        void start(GranularityPeriod granularityPeriod) {
            if (this.timer == null) {
                this.timer = ScannerTimer.create(granularityPeriod);
                this.timer.addActionListener(this);
            }
        }

        void stop() {
            if (this.timer != null) {
                this.timer.removeActionListener(this);
                this.timer.stop();
                this.timer = null;
            }
        }
    }
}

