/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pms.generic;

import java.io.PrintWriter;
import java.util.Iterator;
import se.ericsson.cello.pms.generic.GranularityPeriod;
import se.ericsson.cello.pms.generic.MeasuredData;
import se.ericsson.cello.pms.generic.ValueContainerUpdatable;

public class MeasuredDataReusable
extends MeasuredData {
    private boolean locked = false;
    private int intAttributesLength = 0;
    private int objAttributesLength = 0;

    public MeasuredDataReusable(String[] stringArray, String[] stringArray2) {
        super(stringArray, stringArray2);
        if (stringArray != null) {
            this.intAttributesLength = stringArray.length;
        }
        if (stringArray2 != null) {
            this.objAttributesLength = stringArray2.length;
        }
    }

    public ValueContainerUpdatable removeMeasuredValues(String string) {
        return (ValueContainerUpdatable)this.measuredValues.remove(string);
    }

    public ValueContainerUpdatable getMeasuredValues(String string) {
        return (ValueContainerUpdatable)this.measuredValues.get(string);
    }

    public ValueContainerUpdatable addMeasuredValues(String string) {
        MeasuredData.ReusableValueContainer reusableValueContainer = new MeasuredData.ReusableValueContainer(string, this.intAttributesLength, this.objAttributesLength);
        this.measuredValues.put(string, reusableValueContainer);
        return reusableValueContainer;
    }

    public void clearMeasuredValues() {
        this.measuredValues.clear();
    }

    public Iterator getMeasuredValuesIterator() {
        return this.measuredValues.values().iterator();
    }

    public boolean isLocked() {
        return this.locked;
    }

    void printXml(PrintWriter printWriter, String string, GranularityPeriod granularityPeriod) {
        try {
            super.printXml(printWriter, string, granularityPeriod);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        finally {
            this.unlock();
        }
    }

    void lock() {
        this.locked = true;
    }

    void unlock() {
        this.locked = false;
    }
}

