/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.productinventory;

import se.ericsson.cello.ProductInventory.InventoryFailed;
import se.ericsson.cello.ProductInventory.InventoryResponse;
import se.ericsson.cello.ProductInventory.InventoryServiceOperations;
import se.ericsson.cello.ProductInventory.Message;
import se.ericsson.cello.ProductInventory.ProdId;
import se.ericsson.cello.ProductInventory.ProductType;
import se.ericsson.cello.ProductInventory.StringSeqHolder;
import se.ericsson.cello.productinventory.Collector;
import se.ericsson.cello.productinventory.CollectorFactory;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.thread.BlockingQueue;

public class InventoryServiceImpl
implements InventoryServiceOperations {
    private static BlockingQueue myQueue;
    private static int id;
    private static String[] interfaceVersionList;

    public InventoryServiceImpl(BlockingQueue blockingQueue) {
        InventoryServiceImpl.setMyQueue(blockingQueue);
    }

    private static void setMyQueue(BlockingQueue blockingQueue) {
        myQueue = blockingQueue;
    }

    public boolean set_interface_version(String string, StringSeqHolder stringSeqHolder) {
        try {
            boolean bl = false;
            stringSeqHolder.value = interfaceVersionList;
            for (int i = 0; i < interfaceVersionList.length; ++i) {
                if (!string.equals(interfaceVersionList[i])) continue;
                bl = true;
                stringSeqHolder.value[i] = interfaceVersionList[i];
                break;
            }
            return bl;
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError(this.getClass(), (String)"set_interface_version: ", (Throwable)runtimeException);
            throw runtimeException;
        }
        catch (Error error) {
            MessageLog.traceError(this.getClass(), (String)"set_interface_version: ", (Throwable)error);
            throw error;
        }
    }

    public int get_node_inventory_by_type(ProductType[] productTypeArray, InventoryResponse inventoryResponse, int n) throws InventoryFailed {
        try {
            int n2 = id++;
            Collector collector = CollectorFactory.instance().createTypeCollector(productTypeArray, n2, inventoryResponse, n);
            myQueue.enqueue((Object)collector);
            return n2;
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError(this.getClass(), (String)"get_node_inventory_by_type: ", (Throwable)runtimeException);
            throw new InventoryFailed(new Message(runtimeException.toString(), ""));
        }
        catch (Error error) {
            MessageLog.traceError(this.getClass(), (String)"get_node_inventory_by_type: ", (Throwable)error);
            throw new InventoryFailed(new Message(error.toString(), ""));
        }
    }

    public int get_node_inventory_by_name(String[] stringArray, InventoryResponse inventoryResponse, int n) throws InventoryFailed {
        return -1;
    }

    public int get_node_inventory_by_id(ProdId[] prodIdArray, InventoryResponse inventoryResponse, int n) throws InventoryFailed {
        return -1;
    }

    public int get_node_inventory_by_number(String[] stringArray, InventoryResponse inventoryResponse, int n) throws InventoryFailed {
        return -1;
    }

    public void cancel_request(int n) {
    }

    static {
        id = 1;
        interfaceVersionList = new String[]{"1.4"};
    }
}

