/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mao;

import se.ericsson.cello.mao.MaRevisionHelper;
import se.ericsson.cello.persistence.DbAccessException;
import se.ericsson.cello.persistence.DbStringWrapper;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;

public class MaRevisionWriter {
    private static final int TRACE_GROUP = 1;

    public static void writeRevision(Object object) {
        String string = MaRevisionHelper.getMaProductNumber(object);
        int n = MaRevisionWriter.getNumericCXC(string);
        String string2 = MaRevisionHelper.getAueRevision(object);
        try {
            MaRevisionWriter.writeMaRevision(n, string2);
        }
        catch (Exception exception) {
            MessageLog.traceError((Class)MaRevisionWriter.class, (String)("Could not write MaRevision for CXC " + n + " revision " + string2), (Throwable)exception);
        }
    }

    private static int getNumericCXC(String string) {
        int n = 0;
        try {
            String string2 = string.substring(3, 10);
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            MessageLog.traceError((Class)MaRevisionWriter.class, (String)("Invalid MaRevision " + string), (Throwable)exception);
        }
        return n;
    }

    public static void writeMaRevision(int n, String string) throws DbAccessException, TransactionRolledBackException, InactiveTransactionException {
        MessageLog.trace((int)1, (Class)MaRevisionWriter.class, (String)("cxc = " + n + ", revision = " + string));
        DbStringWrapper dbStringWrapper = new DbStringWrapper("cmarev_r2");
        dbStringWrapper.connectToDatabase();
        TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
        Control control = transactionFactory.create(100);
        MaRevisionWriter.writeCxc(n, string, dbStringWrapper, control.getCoordinator().getTransactionID());
        dbStringWrapper.disconnectFromDatabase();
        control.getTerminator().commit();
    }

    private static void writeCxc(int n, String string, DbStringWrapper dbStringWrapper, int n2) throws DbAccessException {
        MessageLog.trace((int)1, (Class)MaRevisionWriter.class, (String)("(primaryKeyExists(" + n + ") = " + MaRevisionWriter.primaryKeyExists(n, dbStringWrapper)));
        if (MaRevisionWriter.primaryKeyExists(n, dbStringWrapper)) {
            dbStringWrapper.updateRow(n2, n, string);
        } else {
            dbStringWrapper.createRow(n2, n, string);
        }
    }

    private static boolean primaryKeyExists(int n, DbStringWrapper dbStringWrapper) throws DbAccessException {
        int[] nArray = dbStringWrapper.retrieveAllPrimaryKeys();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }
}

