/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mao;

import java.util.Collection;
import java.util.Enumeration;
import java.util.StringTokenizer;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.IpFormatException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.LongAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.transaction.Coordinator;

public class MaoFroTypeConverter {
    public static int[] string2intArray(String string, int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = 0;
        }
        char[] cArray = new char[n];
        int n2 = string.length() <= n ? string.length() : n;
        string.getChars(0, n2, cArray, 0);
        for (int i = 0; i < n2; ++i) {
            nArray[i] = cArray[i];
        }
        return nArray;
    }

    public static String intArray2String(int[] nArray) {
        int n;
        char[] cArray = new char[nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            cArray[n] = '\u0000';
        }
        for (n = 0; n < nArray.length && nArray[n] != 0; ++n) {
            cArray[n] = (char)nArray[n];
        }
        return new String(cArray).trim();
    }

    public static int[] ipacIpAddrString2IntArray(String string) {
        int n;
        byte[] byArray = string.getBytes();
        int[] nArray = new int[40];
        for (n = 0; n < 40; ++n) {
            nArray[n] = 0;
        }
        n = string.length();
        for (int i = 0; i < n; ++i) {
            nArray[i] = byArray[i];
        }
        return nArray;
    }

    public static byte[] string2byteArray(String string, int n) {
        byte[] byArray = new byte[n];
        char[] cArray = new char[n];
        int n2 = string.length() <= n ? string.length() : n;
        string.getChars(0, n2, cArray, 0);
        for (int i = 0; i < n2; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        return byArray;
    }

    public static String byteArray2String(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            cArray[i] = (char)byArray[i];
        }
        return new String(cArray).trim();
    }

    public static int boolean2int(boolean bl) {
        return bl ? 1 : 0;
    }

    public static boolean int2boolean(int n) {
        return n == 1;
    }

    public static String inet_ntoa(int n) {
        long l = n < 0 ? 0x100000000L + (long)n : (long)n;
        String string = Long.toString(l >>> 24) + "." + Long.toString(l >>> 16 & 0xFFL) + "." + Long.toString(l >>> 8 & 0xFFL) + "." + Long.toString(l & 0xFFL);
        return string;
    }

    public static String ipAddrIntArray2String(int[] nArray) throws IpFormatException {
        if (nArray.length > 4) {
            MaoFroTypeConverter.formatException();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            long l = nArray[i] < 0 ? 0x100000000L + (long)nArray[i] : (long)nArray[i];
            if (i == 3) {
                stringBuffer.append(Long.toString(l & 0xFFL));
                continue;
            }
            stringBuffer.append(Long.toString(l & 0xFFL));
            stringBuffer.append(".");
        }
        return stringBuffer.toString();
    }

    public static String ipAddrLongArray2String(long[] lArray) throws IpFormatException {
        if (lArray.length > 4) {
            MaoFroTypeConverter.formatException();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < lArray.length; ++i) {
            if (i == 3) {
                stringBuffer.append(Long.toString(lArray[i] & 0xFFL));
                continue;
            }
            stringBuffer.append(Long.toString(lArray[i] & 0xFFL));
            stringBuffer.append(".");
        }
        return stringBuffer.toString();
    }

    public static String ipAddressLong2String(long l) {
        String string = Long.toString(l >>> 24) + "." + Long.toString(l >>> 16 & 0xFFL) + "." + Long.toString(l >>> 8 & 0xFFL) + "." + Long.toString(l & 0xFFL);
        return string;
    }

    public static boolean lastPartOfIpAddrIsZero(int n) {
        long l = n < 0 ? 0x100000000L + (long)n : (long)n;
        return (l & 0xFFL) == 0L;
    }

    public static int inet_addr(String string) throws IpFormatException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            try {
                n = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                MaoFroTypeConverter.formatException();
            }
            if (n < 0 || n > 255) {
                MaoFroTypeConverter.formatException();
            }
            if ((string2 = Integer.toHexString(n)).length() == 1) {
                stringBuffer.append("0");
                stringBuffer.append(string2);
            } else {
                stringBuffer.append(string2);
            }
            ++n2;
        }
        if (n2 != 4) {
            MaoFroTypeConverter.formatException();
        }
        return (int)Long.parseLong(stringBuffer.toString(), 16);
    }

    public static long ipAddrString2Long(String string) throws IpFormatException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            try {
                n = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                MaoFroTypeConverter.formatException();
            }
            if (n < 0 || n > 255) {
                MaoFroTypeConverter.formatException();
            }
            if ((string2 = Integer.toHexString(n)).length() == 1) {
                stringBuffer.append("0");
                stringBuffer.append(string2);
            } else {
                stringBuffer.append(string2);
            }
            ++n2;
        }
        if (n2 != 4) {
            MaoFroTypeConverter.formatException();
        }
        return Long.parseLong(stringBuffer.toString(), 16);
    }

    public static int[] ipAddrString2IntArray(String string) throws IpFormatException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = 0;
        int n2 = 0;
        int[] nArray = new int[4];
        for (int i = 0; i < 4; ++i) {
            nArray[i] = 0;
        }
        while (stringTokenizer.hasMoreTokens()) {
            try {
                n = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                MaoFroTypeConverter.formatException();
            }
            if (n < 0 || n > 255) {
                MaoFroTypeConverter.formatException();
            }
            if (n2 > 4) {
                MaoFroTypeConverter.formatException();
            }
            nArray[n2] = n;
            ++n2;
        }
        return nArray;
    }

    public static long[] ipAddrString2LongArray(String string) throws IpFormatException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        long l = 0L;
        int n = 0;
        long[] lArray = new long[4];
        for (int i = 0; i < 4; ++i) {
            lArray[i] = 0L;
        }
        while (stringTokenizer.hasMoreTokens()) {
            try {
                l = Long.parseLong(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                MaoFroTypeConverter.formatException();
            }
            if (l < 0L || l > 255L) {
                MaoFroTypeConverter.formatException();
            }
            if (n > 4) {
                MaoFroTypeConverter.formatException();
            }
            lArray[n] = l;
            ++n;
        }
        return lArray;
    }

    public static byte[] ipAddrStringArray2ByteArray(String[] stringArray, int n) throws IpFormatException {
        int n2;
        byte[] byArray = new byte[8 * n];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < 8 * n; ++n2) {
            byArray[n2] = 0;
            byArray[n2++] = 46;
        }
        for (n2 = 0; n2 < n; ++n2) {
            String string = stringArray[n2];
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            n5 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    n4 = Integer.parseInt(stringTokenizer.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    MaoFroTypeConverter.formatException();
                }
                if (n4 < 0 || n4 > 255) {
                    MaoFroTypeConverter.formatException();
                }
                if (n5 > 4) {
                    MaoFroTypeConverter.formatException();
                }
                byArray[n3++] = (byte)n4;
                if (++n5 == 4) {
                    byArray[n3++] = 0;
                    continue;
                }
                byArray[n3++] = 46;
            }
        }
        return byArray;
    }

    public static String[] intArray2IpAddrStringArray(int[] nArray, int n) throws IpFormatException {
        String[] stringArray = new String[n / 8];
        for (int i = 0; i < n; i += 8) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int j = 0; j < 7; ++j) {
                if (nArray[i + j] == 46) {
                    stringBuffer.append(".");
                    continue;
                }
                stringBuffer.append(Integer.toString(nArray[i + j]));
            }
            stringArray[i / 8] = stringBuffer.toString();
        }
        return stringArray;
    }

    public static Attribute[] longArr2AttrArr(long[] lArray) {
        int n = lArray.length;
        long[] lArray2 = new long[n];
        System.arraycopy(lArray, 0, lArray2, 0, n);
        Attribute[] attributeArray = new Attribute[n];
        for (int i = 0; i < lArray2.length; ++i) {
            LongAttribute longAttribute = new LongAttribute("froId", false);
            longAttribute.setValue(lArray2[i]);
            attributeArray[i] = longAttribute;
        }
        return attributeArray;
    }

    public static ManagedObject[] convertCollToMOArr(Collection collection) {
        ManagedObject[] managedObjectArray = new ManagedObject[collection.size()];
        collection.toArray(managedObjectArray);
        return managedObjectArray;
    }

    public static long[] attrArr2LongArr(Attribute[] attributeArray, Coordinator coordinator) {
        long[] lArray = new long[attributeArray.length];
        for (int i = 0; i < attributeArray.length; ++i) {
            lArray[i] = ((LongAttribute)attributeArray[i]).getValue(coordinator);
        }
        return lArray;
    }

    private static void formatException() throws IpFormatException {
        throw new IpFormatException("Not a valid IP address");
    }

    public static int calculateSubnetMask(int n, String string) throws MoAccessException {
        int n2 = -1;
        int n3 = 0;
        n3 = n2 >>> n;
        return (n3 ^= 0xFFFFFFFF) & MaoFroTypeConverter.inet_addr(string);
    }

    public static ManagedObject froId2MaoInstance(String string, int n, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = null;
        MoIterator moIterator = MoRepository.instance().lookupType(string);
        while (moIterator != null && moIterator.hasMoreElements()) {
            managedObject = moIterator.nextMo();
            if (!(managedObject instanceof FroInfo) || n != ((FroInfo)managedObject).getFroId(coordinator)) continue;
            return managedObject;
        }
        return null;
    }

    public static ManagedObject froId2MaoInstance(String[] stringArray, int n, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = null;
        for (int i = 0; i < stringArray.length; ++i) {
            MoIterator moIterator = MoRepository.instance().lookupType(stringArray[i]);
            while (moIterator != null && moIterator.hasMoreElements()) {
                managedObject = moIterator.nextMo();
                if (!(managedObject instanceof FroInfo) || n != ((FroInfo)managedObject).getFroId(coordinator)) continue;
                return managedObject;
            }
        }
        return null;
    }

    public static ReferenceAttribute retrieveReferenceFromSequence(ManagedObject managedObject, SequenceAttribute sequenceAttribute, Coordinator coordinator) throws MoAccessException {
        Enumeration enumeration = sequenceAttribute.elements();
        while (enumeration.hasMoreElements()) {
            ReferenceAttribute referenceAttribute = (ReferenceAttribute)enumeration.nextElement();
            if (!managedObject.equals(referenceAttribute.getValue(coordinator))) continue;
            return referenceAttribute;
        }
        return null;
    }

    public static SequenceAttribute getSequenceAttrFromRefArray(ManagedObject[] managedObjectArray, String string, Coordinator coordinator) {
        SequenceAttribute sequenceAttribute = new SequenceAttribute(string, true);
        ReferenceAttribute referenceAttribute = null;
        if (managedObjectArray != null) {
            for (int i = 0; i < managedObjectArray.length; ++i) {
                referenceAttribute = new ReferenceAttribute("", false);
                referenceAttribute.setValue(managedObjectArray[i]);
                sequenceAttribute.addElement((Attribute)referenceAttribute);
            }
        }
        return sequenceAttribute;
    }

    public static ReferenceAttribute[] getReferenceAttrArray(ManagedObject[] managedObjectArray, Coordinator coordinator) {
        ReferenceAttribute[] referenceAttributeArray = null;
        ReferenceAttribute referenceAttribute = null;
        if (managedObjectArray != null) {
            referenceAttributeArray = new ReferenceAttribute[managedObjectArray.length];
            for (int i = 0; i < managedObjectArray.length; ++i) {
                referenceAttribute = new ReferenceAttribute("", false);
                referenceAttribute.setValue(managedObjectArray[i]);
                referenceAttributeArray[i] = referenceAttribute;
            }
        }
        return referenceAttributeArray;
    }
}

