/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mao;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import se.ericsson.cello.mao.PmRequestContext;
import se.ericsson.cello.moframework.IllegalArgumentTypeException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.pmapp.GenPmMao;
import se.ericsson.cello.pmapp.PmAppException;
import se.ericsson.cello.transaction.Coordinator;

public abstract class PmRequestContextBase
implements PmRequestContext {
    protected final ManagedObject owner;
    protected final Map proxy2FroIdMap;
    protected final Coordinator coordinator;
    private final Map tempVars = new HashMap();

    protected PmRequestContextBase(ManagedObject managedObject, Map map, Coordinator coordinator) throws MoAccessException {
        if (!(managedObject instanceof GenPmMao)) {
            throw new SoftwareErrorException((Throwable)new IllegalArgumentException("The ManagedObject instance is not a generic PM MAO, MO type=" + (managedObject == null ? "null" : managedObject.getType())));
        }
        if (map == null) {
            throw new SoftwareErrorException((Throwable)new IllegalArgumentException("The passed value of pm proxy:froIds map is null"));
        }
        this.owner = managedObject;
        this.coordinator = coordinator;
        if (map.isEmpty() && managedObject.isCreated()) {
            this.resolveProxies(map);
        }
        this.proxy2FroIdMap = Collections.unmodifiableMap(map);
    }

    public final Coordinator getCoordinator() {
        return this.coordinator;
    }

    public final Object setVariable(Object object, Object object2) {
        return this.tempVars.put(object, object2);
    }

    public final Object getVariable(Object object) {
        return this.tempVars.get(object);
    }

    public Object getPmAttribute(String string, Object object) throws MoAccessException {
        String string2 = this.getPmAttrNameValue(string);
        if (string2 == "") {
            throw new NoSuchAttributeException(string, this.owner.getType());
        }
        if (object == GenPmMao.INTEGER_PM_TYPE) {
            int n = this.getPmIntAttributeValue(string, string2);
            return new Integer(n);
        }
        if (object == GenPmMao.LONG_PM_TYPE) {
            long l = this.getPmLongAttributeValue(string, string2);
            return new Long(l);
        }
        if (object == GenPmMao.INTEGER_ARRAY_PM_TYPE) {
            int[] nArray = this.getPmIntArrayAttributeValue(string, string2);
            Integer[] integerArray = new Integer[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                integerArray[i] = new Integer(nArray[i]);
            }
            return integerArray;
        }
        if (object == GenPmMao.LONG_ARRAY_PM_TYPE) {
            long[] lArray = this.getPmLongArrayAttributeValue(string, string2);
            Long[] longArray = new Long[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                longArray[i] = new Long(lArray[i]);
            }
            return longArray;
        }
        String string3 = "Invalid Type for PM Attribute: attrName =" + string + ", type=" + (object == null ? "null" : object.getClass().getName()) + ", txId=" + (this.coordinator == null ? 0 : this.coordinator.getTransactionID());
        throw new ValueOutOfRangeException(string, this.owner.getType(), string3);
    }

    private int getPmIntAttributeValue(String string, String string2) throws IllegalArgumentTypeException {
        int n = string2.indexOf("=");
        String string3 = string2.substring(0, n).trim();
        if (string3.equals(string)) {
            return Integer.parseInt(string2.substring(n + 1, string2.length()));
        }
        throw new IllegalArgumentTypeException(this.owner, string);
    }

    private long getPmLongAttributeValue(String string, String string2) throws IllegalArgumentTypeException {
        int n = string2.indexOf("=");
        String string3 = string2.substring(0, n).trim();
        if (string3.equals(string)) {
            return Long.parseLong(string2.substring(n + 1, string2.length()));
        }
        throw new IllegalArgumentTypeException(this.owner, string);
    }

    private int[] getPmIntArrayAttributeValue(String string, String string2) throws IllegalArgumentTypeException {
        int n = string2.indexOf("=");
        String string3 = string2.substring(0, n).trim();
        if (string3.equalsIgnoreCase(string)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2.substring(n + 1, string2.length()), " ");
            int[] nArray = new int[stringTokenizer.countTokens()];
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                nArray[n2] = Integer.parseInt(stringTokenizer.nextToken());
                ++n2;
            }
            return nArray;
        }
        throw new IllegalArgumentTypeException(this.owner, string);
    }

    private long[] getPmLongArrayAttributeValue(String string, String string2) throws IllegalArgumentTypeException {
        int n = string2.indexOf("=");
        String string3 = string2.substring(0, n).trim();
        if (string3.equalsIgnoreCase(string)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2.substring(n + 1, string2.length()), " ");
            long[] lArray = new long[stringTokenizer.countTokens()];
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                lArray[n2] = Long.parseLong(stringTokenizer.nextToken());
                ++n2;
            }
            return lArray;
        }
        throw new IllegalArgumentTypeException(this.owner, string);
    }

    public abstract void init();

    public abstract String[] getCurrentPmRegister() throws MoAccessException;

    public abstract String getPmAttrNameValue(String var1) throws MoAccessException;

    abstract void resolveProxies(Map var1) throws PmAppException;
}

