/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pmapp.fropxy;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import se.ericsson.cello.maofro.proxy.TagNameDictionaryException;
import se.ericsson.cello.pmapp.fropxy.GenericPmFroProxy;
import se.ericsson.cello.pmapp.fropxy.GenericPmFroProxyFactory;
import se.ericsson.cello.pmapp.fropxy.Mo2FroIdTranslator;
import se.ericsson.cello.pmapp.fropxy.PmDictionaries;
import se.ericsson.cello.pmapp.fropxy.PmFroProxy;

public class OsePmFroProxyFactory
implements GenericPmFroProxyFactory {
    private Map proxyMap = new HashMap();
    private static GenericPmFroProxyFactory instance;

    public static GenericPmFroProxyFactory getInstance() {
        if (instance == null) {
            instance = new OsePmFroProxyFactory();
        }
        return instance;
    }

    public synchronized GenericPmFroProxy create(String string) throws TagNameDictionaryException {
        PmFroProxy pmFroProxy = null;
        if (this.proxyMap.containsKey(string)) {
            return (GenericPmFroProxy)this.proxyMap.get(string);
        }
        pmFroProxy = new PmFroProxy(PmDictionaries.get(ResourceBundle.getBundle(string)));
        this.checkProxy(pmFroProxy);
        this.proxyMap.put(string, pmFroProxy);
        return pmFroProxy;
    }

    private void checkProxy(GenericPmFroProxy genericPmFroProxy) {
        int n = genericPmFroProxy.getFroType();
        GenericPmFroProxy genericPmFroProxy2 = this.lookupByFroType(n);
        if (genericPmFroProxy2 != null) {
            throw new RuntimeException("The new pm fro proxy: " + genericPmFroProxy + " overlaps with respect to fro type with another already created pm fro proxy!");
        }
        String[] stringArray = genericPmFroProxy.getMoTypes();
        for (int i = 0; i < stringArray.length; ++i) {
            genericPmFroProxy2 = this.lookupByMoType(stringArray[i]);
            if (genericPmFroProxy2 == null) continue;
            throw new RuntimeException("The new pm fro proxy: " + genericPmFroProxy + " overlaps with respect to mo type with another already created pm fro proxy!");
        }
    }

    public GenericPmFroProxy lookupByMoType(String string) {
        Iterator iterator = this.proxyMap.entrySet().iterator();
        while (iterator.hasNext()) {
            PmFroProxy pmFroProxy = (PmFroProxy)iterator.next().getValue();
            if (!pmFroProxy.supportsMoType(string)) continue;
            return pmFroProxy;
        }
        return null;
    }

    public String toString() {
        return this.getClass().getName() + " No of created pm fro proxies: " + this.proxyMap.size();
    }

    public GenericPmFroProxy lookupByDistinguishedName(String string) {
        String string2 = Mo2FroIdTranslator.extractMoTypeFromDistinguishedName(string);
        return this.lookupByMoType(string2);
    }

    public GenericPmFroProxy lookupByFroType(int n) {
        Iterator iterator = this.proxyMap.entrySet().iterator();
        while (iterator.hasNext()) {
            GenericPmFroProxy genericPmFroProxy = (GenericPmFroProxy)iterator.next().getValue();
            if (genericPmFroProxy.getFroType() != n) continue;
            return genericPmFroProxy;
        }
        return null;
    }
}

