/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pmapp.fropxy;

import enea.ose.system.AttachSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import se.ericsson.cello.maofro.proxy.KeyNotFoundException;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.maofro.proxy.TagNameDictionaryException;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.pmapp.fropxy.CelloMaoFroPmDataStruct;
import se.ericsson.cello.pmapp.fropxy.GenericPmFroProxy;
import se.ericsson.cello.pmapp.fropxy.GenericPmFroProxyException;
import se.ericsson.cello.pmapp.fropxy.MaoFroGetCurrentPm64Cfm;
import se.ericsson.cello.pmapp.fropxy.MaoFroGetCurrentPmCfm;
import se.ericsson.cello.pmapp.fropxy.MaoFroGetCurrentPmCfmBase;
import se.ericsson.cello.pmapp.fropxy.MaoFroGetCurrentPmReq;
import se.ericsson.cello.pmapp.fropxy.MaoFroSubscribePmCfm;
import se.ericsson.cello.pmapp.fropxy.MaoFroSubscribePmReq;
import se.ericsson.cello.pmapp.fropxy.MaoFroUnsubscribePmCfm;
import se.ericsson.cello.pmapp.fropxy.MaoFroUnsubscribePmReq;
import se.ericsson.cello.pmapp.fropxy.PVSessionEvent;
import se.ericsson.cello.pmapp.fropxy.PmrRecoveryProxy;
import se.ericsson.cello.pmapp.fropxy.SignalCreator;
import se.ericsson.cello.pmreporter.PmReporterAdmin;
import se.ericsson.cello.pmreporter.PmReporterFactory;
import se.ericsson.cello.pms.generic.PerformanceMgmntService;
import se.ericsson.cello.session.NameServerWrapper;
import se.ericsson.cello.session.PVSession;
import se.ericsson.cello.session.ServiceSubscriber;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.sigutil.SignalHelper;
import se.ericsson.cello.support.thread.AWTEventMulticaster;
import se.ericsson.cello.support.thread.ActionEvent;
import se.ericsson.cello.support.thread.ActionListener;
import se.ericsson.cello.transaction.Coordinator;

class PmFroProxy
implements GenericPmFroProxy,
ServiceSubscriber,
PmrRecoveryProxy {
    private PVSession pvSession;
    private TagNameDictionary dictionary;
    private ActionListener subscribers;
    private boolean isSessionCreated;
    private int froType;
    private Set moTypes = new HashSet();
    private String serviceName;
    static final int RESULT_OK = 0;
    private PmReporterAdmin omsPmReporter = null;
    private boolean pmReporterIsValid = false;
    static /* synthetic */ Class class$se$ericsson$cello$pmapp$fropxy$MaoFroSubscribePmCfm;
    static /* synthetic */ Class class$se$ericsson$cello$pmapp$fropxy$MaoFroUnsubscribePmCfm;

    public void pmSubscribe(Coordinator coordinator, int n, int[] nArray, String[] stringArray) throws GenericPmFroProxyException {
    }

    public void pmSubscribe(Coordinator coordinator, int n, int[] nArray, String[] stringArray, String[] stringArray2) throws GenericPmFroProxyException {
        MessageLog.trace((int)2, this.getClass(), (String)("pmSubscribe(): froType=" + this.getFroType() + " froIdList=' " + this.toString(nArray) + " ', pmCounters=' " + this.toString(stringArray) + " ldns=' " + this.toString(stringArray2) + " '"));
        if (PerformanceMgmntService.getHighCapacityPMEnabled() == 1 && !this.pmReporterIsValid) {
            throw new GenericPmFroProxyException(25, 25, "System Parameter PmriEnabled set to 1, but PmReporter missing on node");
        }
        long[] lArray = this.getPmAttrList(stringArray);
        try {
            SignalCreator signalCreator = new SignalCreator(coordinator.getTransactionID(), this.pvSession.obtainSession().getClientId(), this.getFroType(), n, nArray, lArray);
            List list = signalCreator.createSubscribeSignal();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                MaoFroSubscribePmReq maoFroSubscribePmReq = (MaoFroSubscribePmReq)((Object)iterator.next());
                Signal signal = SignalHelper.sendAndReceiveAttachedClean((OseProcess)this.getPmFro(), (Signal)maoFroSubscribePmReq, (Class)(class$se$ericsson$cello$pmapp$fropxy$MaoFroSubscribePmCfm == null ? PmFroProxy.class$("se.ericsson.cello.pmapp.fropxy.MaoFroSubscribePmCfm") : class$se$ericsson$cello$pmapp$fropxy$MaoFroSubscribePmCfm), (int)SignalHelper.getTimeOut());
                if (signal == null) {
                    String string = "pmSubscribe(): No response (MaoFroSubscribePmCfm signal was null).";
                    throw new GenericPmFroProxyException(101, 24, "froType = " + this.getFroType() + " .Message: " + string);
                }
                if (signal instanceof AttachSignal) {
                    String string = "pmSubscribe(): MaoFroSubscribePmCfm signal returned with an AttachSignal).";
                    throw new GenericPmFroProxyException(101, 23, "froType = " + this.getFroType() + " .Message: " + string);
                }
                if (((MaoFroSubscribePmCfm)signal).getResult() == 0) continue;
                String string = "pmSubscribe(): MaoFroSubscribePmCfm signal returned not OK.\n" + ((MaoFroSubscribePmCfm)signal).getResultText();
                throw new GenericPmFroProxyException(101, ((MaoFroSubscribePmCfm)signal).getResult(), "froType = " + this.getFroType() + " .Message: " + string);
            }
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            String string = "pmSubscribe() failed" + froNotAccessibleException.getMessage();
            throw new GenericPmFroProxyException(101, 26, "froType = " + this.getFroType() + " .Message: " + string);
        }
        if (PerformanceMgmntService.getHighCapacityPMEnabled() == 1 && this.omsPmReporter != null) {
            this.omsPmReporter.registerLdns(n, this.getFroType(), nArray, stringArray2);
            this.sendMeasurementInfoToOmsPmReporter(stringArray, n);
            this.sendPdfCounterInfoToOmsPmReporter(n);
        }
    }

    public void pmUnsubscribe(Coordinator coordinator, int[] nArray, String[] stringArray) throws GenericPmFroProxyException {
    }

    public void pmUnsubscribe(Coordinator coordinator, int n, int[] nArray, String[] stringArray) throws GenericPmFroProxyException {
        MessageLog.trace((int)2, this.getClass(), (String)("pmUnsubscribe(): froType=" + this.getFroType() + " froIdList=' " + this.toString(nArray) + "'"));
        if (PerformanceMgmntService.getHighCapacityPMEnabled() == 1 && !this.pmReporterIsValid) {
            throw new GenericPmFroProxyException(25, 25, "System Parameter HighCapacityPMEnabled set to 1, but PmReporter missing on node");
        }
        try {
            long[] lArray = this.getPmAttrList(stringArray);
            SignalCreator signalCreator = new SignalCreator(coordinator.getTransactionID(), this.pvSession.obtainSession().getClientId(), this.getFroType(), 0, nArray, lArray);
            List list = signalCreator.createUnsubscribeSignal();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                MaoFroUnsubscribePmReq maoFroUnsubscribePmReq = (MaoFroUnsubscribePmReq)((Object)iterator.next());
                Signal signal = SignalHelper.sendAndReceiveAttachedClean((OseProcess)this.getPmFro(), (Signal)maoFroUnsubscribePmReq, (Class)(class$se$ericsson$cello$pmapp$fropxy$MaoFroUnsubscribePmCfm == null ? PmFroProxy.class$("se.ericsson.cello.pmapp.fropxy.MaoFroUnsubscribePmCfm") : class$se$ericsson$cello$pmapp$fropxy$MaoFroUnsubscribePmCfm), (int)SignalHelper.getTimeOut());
                if (signal == null) {
                    String string = "pmUnsubscribe(): No response (MaoFroUnsubscribePmCfm signal was null).";
                    throw new GenericPmFroProxyException(102, 24, "froType = " + this.getFroType() + " .Message: " + string);
                }
                if (signal instanceof AttachSignal) {
                    String string = "pmUnsubscribe(): MaoFroSubscribePmCfm signal returned with an AttachSignal).";
                    throw new GenericPmFroProxyException(102, 23, "froType = " + this.getFroType() + " .Message: " + string);
                }
                if (((MaoFroUnsubscribePmCfm)signal).getResult() == 0) continue;
                String string = "pmUnsubscribe(): MaoFroUnsubscribePmCfm signal returned not OK.\n" + ((MaoFroUnsubscribePmCfm)signal).getResultText();
                throw new GenericPmFroProxyException(102, ((MaoFroUnsubscribePmCfm)signal).getResult(), "froType = " + this.getFroType() + " .Message: " + string);
            }
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            String string = "pmUnsubscribe() failed" + froNotAccessibleException.getMessage();
            throw new GenericPmFroProxyException(102, 26, "froType = " + this.getFroType() + " .Message: " + string);
        }
        if (PerformanceMgmntService.getHighCapacityPMEnabled() == 1) {
            this.sendReleaseMeasurementInfoToOmsPmReporter(stringArray, n);
        }
    }

    public String[] getCurrentPmRegister(int n) throws GenericPmFroProxyException {
        MessageLog.trace((int)5, this.getClass(), (String)("getCurrentPmRegister(): froType=" + this.getFroType() + " froId=" + n));
        MaoFroGetCurrentPmCfmBase maoFroGetCurrentPmCfmBase = null;
        try {
            MaoFroGetCurrentPmReq maoFroGetCurrentPmReq = new MaoFroGetCurrentPmReq(this.pvSession.obtainSession().getClientId(), this.getFroType(), new int[]{n});
            Class[] classArray = new Class[]{MaoFroGetCurrentPmCfm.class, MaoFroGetCurrentPm64Cfm.class};
            Signal signal = SignalHelper.sendAndReceiveAttachedClean((OseProcess)this.getPmFro(), (Signal)maoFroGetCurrentPmReq, (Class[])classArray, (int)SignalHelper.getTimeOut());
            if (signal == null) {
                String string = "getCurrentPmRegister(): No response. MaoFroSubscribePmCfm/MaoFroSubscribePm64Cfm returned null).";
                throw new GenericPmFroProxyException(100, 24, "froType = " + this.getFroType() + " .Message: " + string);
            }
            if (signal instanceof AttachSignal) {
                String string = "getCurrentPmRegister(): Receiver process terminated: " + this.getServiceName();
                throw new GenericPmFroProxyException(100, 24, "froType = " + this.getFroType() + " .Message: " + string);
            }
            if (!(signal instanceof MaoFroGetCurrentPmCfmBase)) {
                String string = "Unexpected cfm signal received at MaoFroGetCurrentPmReq, signal: " + signal.getSigNo() + ", froType: " + this.getFroType();
                MessageLog.traceError(this.getClass(), (String)string);
                throw new GenericPmFroProxyException(100, 25, "froType = " + this.getFroType() + " .Message: " + string);
            }
            maoFroGetCurrentPmCfmBase = (MaoFroGetCurrentPmCfmBase)signal;
            if (maoFroGetCurrentPmCfmBase.getResult() != 0) {
                String string = "getCurrentPmRegister(): MaoFroSubscribePmCfm/MaoFroSubscribePm64Cfm signal returned not OK.";
                throw new GenericPmFroProxyException(100, 1, "froType = " + this.getFroType() + " .Message: " + string);
            }
            CelloMaoFroPmDataStruct[] celloMaoFroPmDataStructArray = maoFroGetCurrentPmCfmBase.getPmAttrsPerFroArray();
            if (celloMaoFroPmDataStructArray.length != 1) {
                String string = "getCurrentPmRegister(): CelloMaoFroPmDataStruct array of unexpected length (" + celloMaoFroPmDataStructArray.length + ")";
                MessageLog.traceError(this.getClass(), (String)string);
                throw new GenericPmFroProxyException(100, 25, "froType = " + this.getFroType() + " .Message: " + string);
            }
            if (celloMaoFroPmDataStructArray[0].getFroId() != n) {
                String string = "getCurrentPmRegister(): CelloMaoFroPmDataStruct froId has unexpected value (" + celloMaoFroPmDataStructArray[0].getFroId() + " instead of " + n + ")";
                MessageLog.traceError(this.getClass(), (String)string);
                throw new GenericPmFroProxyException(100, 25, "froType = " + this.getFroType() + " .Message: " + string);
            }
            String[] stringArray = this.translate2PmTags(this.getPmAttributeNames());
            long[] lArray = celloMaoFroPmDataStructArray[0].getPmAttrList();
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                int n2 = stringArray[i].indexOf(":");
                if (n2 == -1) {
                    stringArray2[i] = this.getDictionary().lookupKey(stringArray[i]) + "=" + lArray[new Integer(stringArray[i])];
                    continue;
                }
                String string = this.extractPmArrayValue(lArray, stringArray[i]);
                stringArray2[i] = this.getDictionary().lookupKey(stringArray[i]) + "=" + string;
            }
            return stringArray2;
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            String string = "getCurrentPmRegister() failed" + froNotAccessibleException.getMessage();
            throw new GenericPmFroProxyException(100, 26, "froType = " + this.getFroType() + " .Message: " + string);
        }
        catch (TagNameDictionaryException tagNameDictionaryException) {
            String string = "getCurrentPmRegister() failed" + tagNameDictionaryException.getMessage();
            throw new GenericPmFroProxyException(100, 22, "froType = " + this.getFroType() + " .Message: " + string);
        }
    }

    public void recoverPmrData(int n, int[] nArray, String[] stringArray, String[] stringArray2) {
        if (this.omsPmReporter != null) {
            this.omsPmReporter.registerLdns(n, this.getFroType(), nArray, stringArray2);
            this.sendMeasurementInfoToOmsPmReporter(stringArray, n);
            this.sendPdfCounterInfoToOmsPmReporter(n);
        } else {
            MessageLog.traceError(this.getClass(), (String)"No PmReporter instance!");
        }
    }

    private String extractPmArrayValue(long[] lArray, String string) {
        int n = new Integer(string.substring(string.indexOf(":") + 1, string.indexOf(",")));
        int n2 = new Integer(string.substring(string.indexOf(",") + 1));
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i <= n2; ++i) {
            stringBuffer.append(lArray[i]);
            stringBuffer.append(" ");
        }
        return stringBuffer.toString().trim();
    }

    public List getNoOfValuesPerAttribute(String[] stringArray) {
        int n = 0;
        int n2 = 0;
        String[] stringArray2 = this.translate2PmTags(stringArray);
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (int i = 0; i < stringArray2.length; ++i) {
            if (stringArray2[i].indexOf(":") != -1) {
                n = new Integer(stringArray2[i].substring(stringArray2[i].indexOf(":") + 1, stringArray2[i].indexOf(",")));
                n2 = new Integer(stringArray2[i].substring(stringArray2[i].indexOf(",") + 1));
                linkedList.add(i, new Integer(n2 - n + 1));
                continue;
            }
            linkedList.add(i, new Integer(1));
        }
        return linkedList;
    }

    public TagNameDictionary getDictionary() {
        return this.dictionary;
    }

    public int getFroType() {
        return this.froType;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void addActionEventListener(ActionListener actionListener) {
        this.subscribers = AWTEventMulticaster.add((ActionListener)this.subscribers, (ActionListener)actionListener);
    }

    public void removeActionEventListener(ActionListener actionListener) {
        this.subscribers = AWTEventMulticaster.remove((ActionListener)this.subscribers, (ActionListener)actionListener);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        MessageLog.trace((int)5, this.getClass(), (String)("actionPerformed subscribers = " + this.subscribers));
        if (this.subscribers != null) {
            this.subscribers.actionPerformed(actionEvent);
        }
    }

    public boolean supportsMoType(String string) {
        return this.moTypes.contains(string);
    }

    public String[] getMoTypes() {
        String[] stringArray = new String[this.moTypes.size()];
        this.moTypes.toArray(stringArray);
        return stringArray;
    }

    public String toString() {
        return this.getClass().getName() + " moTypes=" + this.moTypes.toString() + ", froType=" + this.getFroType();
    }

    public String[] translate2PmTags(String[] stringArray) throws GenericPmFroProxyException {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                stringArray2[i] = this.getDictionary().lookupValue(stringArray[i]);
                continue;
            }
            catch (TagNameDictionaryException tagNameDictionaryException) {
                throw new GenericPmFroProxyException(103, 22, tagNameDictionaryException.toString());
            }
        }
        return stringArray2;
    }

    public void serviceAdded() {
        try {
            PVSession.PVSessionObject pVSessionObject = this.pvSession.obtainSession();
            MessageLog.trace((int)5, this.getClass(), (String)("sessionCreated serviceName = " + this.serviceName));
            this.isSessionCreated = true;
            PVSessionEvent pVSessionEvent = new PVSessionEvent(this, this.isSessionCreated);
            if (this.subscribers != null) {
                this.subscribers.actionPerformed(pVSessionEvent.getActionEvent());
            }
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            MessageLog.info(this.getClass(), (String)("No session created for pmFroProxy:" + froNotAccessibleException.getVariablesAsString()));
        }
    }

    public void serviceRemoved() {
        MessageLog.trace((int)5, this.getClass(), (String)("sessionRemoved serviceName = " + this.serviceName));
        this.isSessionCreated = false;
        PVSessionEvent pVSessionEvent = new PVSessionEvent(this, this.isSessionCreated);
        if (this.subscribers != null) {
            this.subscribers.actionPerformed(pVSessionEvent.getActionEvent());
        }
    }

    public boolean isSessionCreated() {
        return this.isSessionCreated;
    }

    private String toString(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(nArray[i]);
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private String toString(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public String[] getPmAttributeNames() {
        String[] stringArray;
        Iterator iterator = this.getDictionary().keys();
        LinkedList<String[]> linkedList = new LinkedList<String[]>();
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            try {
                if (!stringArray.startsWith("pm")) continue;
                String string = this.getDictionary().lookupValue((String)stringArray);
                int n = string.indexOf(":");
                if (n == -1) {
                    if (new Integer(string) >= 10000) continue;
                    linkedList.add(stringArray);
                    continue;
                }
                linkedList.add(stringArray);
            }
            catch (TagNameDictionaryException tagNameDictionaryException) {
                throw new GenericPmFroProxyException(103, 22, tagNameDictionaryException.toString());
            }
        }
        stringArray = new String[linkedList.size()];
        linkedList.toArray(stringArray);
        return stringArray;
    }

    public String[] getAttributeNames() {
        String[] stringArray;
        Iterator iterator = this.getDictionary().keys();
        LinkedList<String[]> linkedList = new LinkedList<String[]>();
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            if (pmPropertyData.contains(stringArray)) continue;
            linkedList.add(stringArray);
        }
        stringArray = new String[linkedList.size()];
        linkedList.toArray(stringArray);
        return stringArray;
    }

    public String[] getPdfCounterNames(String[] stringArray) {
        return this.filterPdfCounterNames(stringArray, true);
    }

    public String[] getOrdinaryCounterNames(String[] stringArray) {
        return this.filterPdfCounterNames(stringArray, false);
    }

    private String[] filterPdfCounterNames(String[] stringArray, boolean bl) {
        try {
            String[] stringArray2 = this.translate2PmTags(stringArray);
            LinkedList<String> linkedList = new LinkedList<String>();
            for (int i = 0; i < stringArray2.length; ++i) {
                if (stringArray2[i].indexOf(":") == -1 && !bl) {
                    linkedList.add(this.getDictionary().lookupKey(stringArray2[i]));
                    continue;
                }
                if (stringArray2[i].indexOf(":") == -1 || !bl) continue;
                linkedList.add(this.getDictionary().lookupKey(stringArray2[i]));
            }
            String[] stringArray3 = new String[linkedList.size()];
            linkedList.toArray(stringArray3);
            return stringArray3;
        }
        catch (TagNameDictionaryException tagNameDictionaryException) {
            throw new GenericPmFroProxyException(103, 22, tagNameDictionaryException.toString());
        }
    }

    private long[] getPmAttrList(String[] stringArray) {
        String[] stringArray2 = this.translate2PmTags(stringArray);
        long[] lArray = new long[this.getNoOfPmTags()];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = -1L;
            for (int j = 0; j < stringArray2.length; ++j) {
                int n = stringArray2[j].indexOf(":");
                int n2 = n == -1 ? new Integer(stringArray2[j]).intValue() : new Integer(stringArray2[j].substring(0, stringArray2[j].indexOf(":"))).intValue();
                if (n2 != i) continue;
                lArray[i] = 0L;
            }
        }
        return lArray;
    }

    private int getNoOfPmTags() {
        return this.getPmAttributeNames().length;
    }

    private void sendMeasurementInfoToOmsPmReporter(String[] stringArray, int n) {
        int[] nArray = this.getMeasuredTags(stringArray);
        this.omsPmReporter.registerCounterNames(n, this.getFroType(), nArray, stringArray);
    }

    private void sendReleaseMeasurementInfoToOmsPmReporter(String[] stringArray, int n) {
        int[] nArray = this.getMeasuredTags(stringArray);
        this.omsPmReporter.deregisterCounterNames(n, this.getFroType(), nArray, stringArray);
    }

    private void sendPdfCounterInfoToOmsPmReporter(int n) {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
        String[] stringArray = this.getPmAttributeNames();
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            try {
                String string = this.getDictionary().lookupValue(stringArray[i]);
                if (string.indexOf(":") == -1) continue;
                bl = true;
                arrayList.add(stringArray[i]);
                arrayList2.add(new Integer(Integer.parseInt(string.substring(0, string.indexOf(":")))));
                arrayList3.add(new Integer(Integer.parseInt(string.substring(string.indexOf(":") + 1, string.indexOf(",")))));
                arrayList4.add(new Integer(Integer.parseInt(string.substring(string.indexOf(",") + 1))));
                continue;
            }
            catch (KeyNotFoundException keyNotFoundException) {
                MessageLog.info(this.getClass(), (String)("KeyNotFoundException:" + (Object)((Object)keyNotFoundException)));
            }
        }
        if (bl) {
            String[] stringArray2 = new String[arrayList.size()];
            arrayList.toArray(stringArray2);
            PmReporterAdmin.PdfIndexInfo[] pdfIndexInfoArray = new PmReporterAdmin.PdfIndexInfo[arrayList2.size()];
            for (int i = 0; i < pdfIndexInfoArray.length; ++i) {
                pdfIndexInfoArray[i] = new PmReporterAdmin.PdfIndexInfo(((Integer)arrayList2.get(i)).intValue(), ((Integer)arrayList3.get(i)).intValue(), ((Integer)arrayList4.get(i)).intValue());
            }
            this.omsPmReporter.registerPdfCounters(n, this.getFroType(), pdfIndexInfoArray);
        }
    }

    private int[] getMeasuredTags(String[] stringArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                String string = this.getDictionary().lookupValue(stringArray[i]);
                if (string.indexOf(":") == -1) {
                    arrayList.add(new Integer(Integer.parseInt(this.getDictionary().lookupValue(stringArray[i]))));
                    continue;
                }
                arrayList.add(new Integer(Integer.parseInt(string.substring(0, string.indexOf(":")))));
                continue;
            }
            catch (KeyNotFoundException keyNotFoundException) {
                MessageLog.info(this.getClass(), (String)("KeyNotFoundException:" + (Object)((Object)keyNotFoundException)));
            }
        }
        if (arrayList.size() != 0) {
            int[] nArray = new int[arrayList.size()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = (Integer)arrayList.get(i);
            }
            return nArray;
        }
        return new int[0];
    }

    PmFroProxy(TagNameDictionary tagNameDictionary) throws TagNameDictionaryException {
        this.dictionary = tagNameDictionary;
        this.froType = Integer.parseInt(this.getDictionary().lookupValue("froType"), 16);
        String string = this.getDictionary().lookupValue("moType");
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t,");
        while (stringTokenizer.hasMoreTokens()) {
            this.moTypes.add(stringTokenizer.nextToken());
        }
        this.serviceName = this.getDictionary().lookupValue("serviceName");
        this.pvSession = new PVSession(this.serviceName, this.getDictionary().lookupValue("pvFirstWanted"), this.getDictionary().lookupValue("pvSecondWanted"), this.getDictionary().lookupValue("pvThirdWanted"), string, this.froType);
        new NameServerWrapper(this.serviceName, (ServiceSubscriber)this);
        if (PerformanceMgmntService.getHighCapacityPMEnabled() == 1) {
            try {
                Class.forName("se.ericsson.cello.pmreporter.PmReporterFactory");
                this.pmReporterIsValid = true;
                this.omsPmReporter = PmReporterFactory.create();
            }
            catch (ClassNotFoundException classNotFoundException) {
                MessageLog.traceError(this.getClass(), (String)"Cannot find se.ericsson.cello.pmreporter.PmReporterFactory even though HighCapacityPMEnabled is true");
            }
        }
    }

    private OseProcess getPmFro() throws FroNotAccessibleException {
        return this.pvSession.obtainSession().getFroProcess();
    }
}

