/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pmapp.fropxy;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import se.ericsson.cello.pmapp.fropxy.MaoFroSubscribePmReq;
import se.ericsson.cello.pmapp.fropxy.MaoFroUnsubscribePmReq;

public class SignalCreator {
    private int txId;
    private int clientId;
    private int froType;
    private int collectionInterval;
    private int[] froIdList;
    private long[] pmAttrList;
    private static final int SIGNAL_MAX_LENGTH = 16000;
    private static final int STRUCT_HEADER_LENGTH = 16;
    private static final int ATTRIBUTE_LENGTH = 4;
    private static final int HEADER_LENGTH_PMSUBSCRIBE = 20;
    private static final int HEADER_LENGTH_PMUNSUBSCRIBE = 16;

    public SignalCreator(int n, int n2, int n3, int n4, int[] nArray, long[] lArray) {
        this.txId = n;
        this.clientId = n2;
        this.froType = n3;
        this.collectionInterval = n4;
        this.froIdList = nArray;
        this.pmAttrList = lArray;
    }

    public List createSubscribeSignal() {
        List list = this.partitionFroIds(20);
        Vector<MaoFroSubscribePmReq> vector = new Vector<MaoFroSubscribePmReq>();
        for (int i = 0; i < list.size(); ++i) {
            vector.add(new MaoFroSubscribePmReq(this.txId, this.clientId, this.froType, this.collectionInterval, (int[])list.get(i), this.pmAttrList));
        }
        return vector;
    }

    public List createUnsubscribeSignal() {
        List list = this.partitionFroIds(16);
        Vector<MaoFroUnsubscribePmReq> vector = new Vector<MaoFroUnsubscribePmReq>();
        for (int i = 0; i < list.size(); ++i) {
            vector.add(new MaoFroUnsubscribePmReq(this.txId, this.clientId, this.froType, (int[])list.get(i), this.pmAttrList));
        }
        return vector;
    }

    private List partitionFroIds(int n) {
        int n2;
        int[] nArray;
        int n3;
        int n4 = 16 + 4 * this.pmAttrList.length;
        int n5 = 0;
        int n6 = 0;
        int n7 = n;
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        for (n3 = 0; n3 < this.froIdList.length; ++n3) {
            if ((n7 += n4) > 16000) {
                nArray = new int[n5];
                for (n2 = 0; n2 < n5; ++n2) {
                    nArray[n2] = this.froIdList[n2 + n6];
                }
                arrayList.add(nArray);
                n5 = 0;
                n6 = n3;
                n7 = n + n4;
            }
            ++n5;
        }
        if (n6 == 0) {
            arrayList.add(this.froIdList);
        } else {
            n3 = n5;
            nArray = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                nArray[n2] = this.froIdList[n2 + n6];
            }
            arrayList.add(nArray);
        }
        return arrayList;
    }
}

